/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.parsers.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.IRegistryService;
import org.eclipse.gendoc.services.exception.IncompleteTagException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.parsers.ITagParserService;
import org.eclipse.gendoc.tags.parsers.impl.IncompleteTag;
import org.eclipse.gendoc.tags.parsers.impl.StructuredTag;
import org.eclipse.gendoc.tags.parsers.impl.TextTag;

public class TagParserService
extends AbstractService
implements ITagParserService {
    private final String TAG_REG_SRV_PREFIX = String.valueOf(ITagParserService.class.getName()) + ":";

    @Override
    public List<ITag> parse(ITag parent, String text, List<String> tagNames) throws IncompleteTagException {
        StructuredTag tag;
        String tagName;
        LinkedList<ITag> tags = new LinkedList<ITag>();
        Stack<String> stack = new Stack<String>();
        int iCurrent = 0;
        int iTextEnd = 0;
        int iTagStart = 0;
        int iNameStart = 0;
        int iNameEnd = 0;
        int iTagEnd = 0;
        int iTextStart = 0;
        boolean isClosingTag = false;
        boolean searchClosingTag = false;
        while (iCurrent < text.length()) {
            iTagStart = text.indexOf("&lt;", iCurrent);
            if (iTagStart < 0 || (iTagEnd = text.indexOf("&gt;", iNameStart = iTagStart + "&lt;".length())) < 0) break;
            while (text.indexOf("&lt;", iNameStart) >= 0 && text.indexOf("&lt;", iNameStart) < iTagEnd) {
                iTagStart = text.indexOf("&lt;", iNameStart);
                iNameStart = iTagStart + "&lt;".length();
            }
            if (text.startsWith("/", iTagEnd - "/".length())) {
                iTagEnd -= "/".length();
                if (!searchClosingTag) {
                    iNameEnd = text.indexOf(32, iNameStart);
                    if (iNameEnd < 0 || iNameEnd > iTagEnd) {
                        iNameEnd = iTagEnd;
                    }
                    tagName = text.substring(iNameStart, iNameEnd);
                    iTagEnd += "/".length() + "&gt;".length();
                    if (tagNames != null && tagNames.contains(tagName)) {
                        iTextEnd = iTagStart;
                        if (iTextStart < iTextEnd) {
                            tags.add(new TextTag(parent, text.substring(iTextStart, iTextEnd)));
                        }
                        tag = new StructuredTag(parent, text.substring(iTagStart, iTagEnd));
                        tags.add(tag);
                        iTextStart = iTagEnd;
                    }
                }
            } else {
                boolean bl = isClosingTag = iTagStart < text.length() && text.startsWith("/", iNameStart);
                if (isClosingTag) {
                    iNameEnd = text.indexOf(32, iNameStart += "/".length());
                    if (iNameEnd < 0 || iNameEnd > iTagEnd) {
                        iNameEnd = iTagEnd;
                    }
                    tagName = text.substring(iNameStart, iNameEnd);
                    iTagEnd += "&gt;".length();
                    if (!stack.isEmpty() && ((String)stack.peek()).equals(tagName)) {
                        stack.pop();
                        if (stack.isEmpty()) {
                            if (iTextStart < iTextEnd) {
                                tags.add(new TextTag(parent, text.substring(iTextStart, iTextEnd)));
                            }
                            tag = new StructuredTag(parent, text.substring(iTextEnd, iTagEnd));
                            tags.add(tag);
                            iTextStart = iTagEnd;
                            searchClosingTag = false;
                        }
                    }
                } else {
                    iNameEnd = text.indexOf(32, iNameStart);
                    if (iNameEnd < 0 || iNameEnd > iTagEnd) {
                        iNameEnd = iTagEnd;
                    }
                    tagName = text.substring(iNameStart, iNameEnd);
                    iTagEnd += "&gt;".length();
                    if (tagNames != null && tagNames.contains(tagName)) {
                        if (stack.isEmpty()) {
                            iTextEnd = iTagStart;
                        }
                        stack.push(tagName);
                        searchClosingTag = true;
                    }
                }
            }
            iCurrent = iTagEnd;
        }
        if (!stack.isEmpty()) {
            if (iTextStart < iTextEnd) {
                tags.add(new TextTag(parent, text.substring(iTextStart, iTextEnd)));
            }
            tagName = (String)stack.firstElement();
            tag = new IncompleteTag(parent, text.substring(iTextEnd, text.length()), tagName);
            this.increaseTagIndex(tagName);
            tags.add(tag);
        } else if (iTextStart >= 0 && iTextStart < text.length()) {
            tags.add(new TextTag(parent, text.substring(iTextStart, text.length())));
        }
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        StringBuffer buffer = new StringBuffer("Tags found :");
        for (ITag tag2 : tags) {
            buffer.append("- ");
            buffer.append(tag2.getName());
            buffer.append("  value :");
            buffer.append(tag2.getValue());
            buffer.append("\n");
        }
        logger.log(buffer.toString(), 16);
        return tags;
    }

    @Override
    public int increaseTagIndex(String tagName) {
        IRegistryService registryService = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        int currentTagIndex = this.getTagIndex(String.valueOf(this.TAG_REG_SRV_PREFIX) + tagName);
        registryService.put((Object)tagName, (Object)(currentTagIndex + 1));
        return currentTagIndex + 1;
    }

    @Override
    public int getTagIndex(String tagName) {
        int currentTagIndex = 0;
        IRegistryService registryService = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        Integer value = (Integer)registryService.get((Object)(String.valueOf(this.TAG_REG_SRV_PREFIX) + tagName));
        if (value != null) {
            currentTagIndex = value;
        }
        return currentTagIndex;
    }
}

