/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.provider;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.glsp.example.workflow.handler.GridSnapper;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.server.features.contextmenu.ContextMenuItemProvider;
import org.eclipse.glsp.server.features.contextmenu.MenuItem;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.CreateNodeOperation;

public class WorkflowContextMenuItemProvider
implements ContextMenuItemProvider {
    @Inject
    protected GModelState modelState;

    public List<MenuItem> getItems(List<String> selectedElementIds, GPoint position, Map<String, String> args) {
        if (this.modelState.isReadonly()) {
            return Collections.emptyList();
        }
        GPoint snappedPosition = GridSnapper.snap(position);
        MenuItem newAutTask = new MenuItem("newAutoTask", "Automated Task", Arrays.asList(new CreateNodeOperation("task:automated", snappedPosition)), true);
        MenuItem newManTask = new MenuItem("newManualTask", "Manual Task", Arrays.asList(new CreateNodeOperation("task:manual", snappedPosition)), true);
        MenuItem newChildMenu = new MenuItem("new", "New", Arrays.asList(newAutTask, newManTask), "add", "0_new");
        return new ArrayList<MenuItem>(List.of(newChildMenu));
    }
}

