/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.ComponentTransferFunction;
import org.apache.batik.ext.awt.image.ConcreteComponentTransferFunction;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFeComponentTransferElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feComponentTransfer";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        Element element3;
        Filter filter2 = AbstractSVGFilterPrimitiveElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        ComponentTransferFunction componentTransferFunction = null;
        ComponentTransferFunction componentTransferFunction2 = null;
        ComponentTransferFunction componentTransferFunction3 = null;
        ComponentTransferFunction componentTransferFunction4 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            Bridge bridge;
            if (node.getNodeType() == 1 && (bridge = bridgeContext.getBridge(element3 = (Element)node)) != null && bridge instanceof SVGFeFuncElementBridge) {
                SVGFeFuncElementBridge sVGFeFuncElementBridge = (SVGFeFuncElementBridge)bridge;
                ComponentTransferFunction componentTransferFunction5 = sVGFeFuncElementBridge.createComponentTransferFunction(element, element3);
                if (sVGFeFuncElementBridge instanceof SVGFeFuncRElementBridge) {
                    componentTransferFunction = componentTransferFunction5;
                } else if (sVGFeFuncElementBridge instanceof SVGFeFuncGElementBridge) {
                    componentTransferFunction2 = componentTransferFunction5;
                } else if (sVGFeFuncElementBridge instanceof SVGFeFuncBElementBridge) {
                    componentTransferFunction3 = componentTransferFunction5;
                } else if (sVGFeFuncElementBridge instanceof SVGFeFuncAElementBridge) {
                    componentTransferFunction4 = componentTransferFunction5;
                }
            }
            node = node.getNextSibling();
        }
        element3 = new ComponentTransferRable8Bit(filter2, componentTransferFunction4, componentTransferFunction, componentTransferFunction2, componentTransferFunction3);
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters((Filter)element3, element);
        element3 = new PadRable8Bit((Filter)element3, rectangle2D3, PadMode.ZERO_PAD);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(element, (Filter)element3, map);
        return element3;
    }

    public static class SVGFeFuncAElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncA";
        }
    }

    public static class SVGFeFuncBElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncB";
        }
    }

    protected static abstract class SVGFeFuncElementBridge
    extends AbstractSVGBridge {
        protected SVGFeFuncElementBridge() {
        }

        public ComponentTransferFunction createComponentTransferFunction(Element element, Element element2) {
            int n = SVGFeFuncElementBridge.convertType(element2);
            switch (n) {
                case 2: {
                    float[] fArray = SVGFeFuncElementBridge.convertTableValues(element2);
                    if (fArray == null) {
                        return ConcreteComponentTransferFunction.getIdentityTransfer();
                    }
                    return ConcreteComponentTransferFunction.getDiscreteTransfer((float[])fArray);
                }
                case 0: {
                    return ConcreteComponentTransferFunction.getIdentityTransfer();
                }
                case 4: {
                    float f = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "amplitude", 1.0f);
                    float f2 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "exponent", 1.0f);
                    float f3 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "offset", 0.0f);
                    return ConcreteComponentTransferFunction.getGammaTransfer((float)f, (float)f2, (float)f3);
                }
                case 3: {
                    float f = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "slope", 1.0f);
                    float f4 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "intercept", 0.0f);
                    return ConcreteComponentTransferFunction.getLinearTransfer((float)f, (float)f4);
                }
                case 1: {
                    float[] fArray = SVGFeFuncElementBridge.convertTableValues(element2);
                    if (fArray == null) {
                        return ConcreteComponentTransferFunction.getIdentityTransfer();
                    }
                    return ConcreteComponentTransferFunction.getTableTransfer((float[])fArray);
                }
            }
            throw new Error();
        }

        protected static float[] convertTableValues(Element element) {
            String string = element.getAttributeNS(null, "tableValues");
            if (string.length() == 0) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            float[] fArray = new float[stringTokenizer.countTokens()];
            try {
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    fArray[n] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(element, "attribute.malformed", new Object[]{"tableValues", string});
            }
            return fArray;
        }

        protected static int convertType(Element element) {
            String string = element.getAttributeNS(null, "type");
            if (string.length() == 0) {
                throw new BridgeException(element, "attribute.missing", new Object[]{"type"});
            }
            if ("discrete".equals(string)) {
                return 2;
            }
            if ("identity".equals(string)) {
                return 0;
            }
            if ("gamma".equals(string)) {
                return 4;
            }
            if ("linear".equals(string)) {
                return 3;
            }
            if ("table".equals(string)) {
                return 1;
            }
            throw new BridgeException(element, "attribute.malformed", new Object[]{"type", string});
        }
    }

    public static class SVGFeFuncGElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncG";
        }
    }

    public static class SVGFeFuncRElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncR";
        }
    }
}

