/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.commands;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.internal.l10n.DiagramCoreMessages;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class GroupCommand
extends AbstractTransactionalCommand {
    private List nodes;

    public GroupCommand(TransactionalEditingDomain editingDomain, List nodes) {
        this(editingDomain, nodes, null);
    }

    public GroupCommand(TransactionalEditingDomain editingDomain, List nodes, Map options) {
        super(editingDomain, DiagramCoreMessages.GroupCommand_Label, options, GroupCommand.getWorkspaceFiles((List)nodes));
        this.nodes = nodes;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Node group = NotationFactory.eINSTANCE.createNode();
        group.setType(ViewType.GROUP);
        group.setElement(null);
        View parentView = (View)((View)this.getNodes().get(0)).eContainer();
        parentView.getPersistedChildren().add((Object)group);
        int x = 0;
        int y = 0;
        boolean first = true;
        for (Object view : this.getNodes()) {
            if (!(view instanceof Node)) continue;
            LayoutConstraint layoutConstraint = ((Node)view).getLayoutConstraint();
            if (layoutConstraint instanceof Location) {
                Location location = (Location)layoutConstraint;
                if (first) {
                    x = location.getX();
                    y = location.getY();
                    first = false;
                } else {
                    if (x > location.getX()) {
                        x = location.getX();
                    }
                    if (y > location.getY()) {
                        y = location.getY();
                    }
                }
            }
            group.insertChild((View)view);
        }
        Bounds groupBounds = NotationFactory.eINSTANCE.createBounds();
        groupBounds.setX(x);
        groupBounds.setY(y);
        groupBounds.setWidth(-1);
        groupBounds.setHeight(-1);
        group.setLayoutConstraint((LayoutConstraint)groupBounds);
        this.translateChildrenLocations(x, y);
        return CommandResult.newOKCommandResult((Object)group);
    }

    private void translateChildrenLocations(int x, int y) {
        if (x == 0 && y == 0) {
            return;
        }
        for (Object view : this.getNodes()) {
            LayoutConstraint layoutConstraint;
            if (!(view instanceof Node) || !((layoutConstraint = ((Node)view).getLayoutConstraint()) instanceof Location)) continue;
            Location location = (Location)layoutConstraint;
            location.setX(location.getX() - x);
            location.setY(location.getY() - y);
        }
    }

    protected List getNodes() {
        return this.nodes;
    }
}

