/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.NetworkCreation;

final class ImmutableNetworkCreation
implements NetworkCreation {
    private final String id;
    @Nullable
    private final String warnings;

    private ImmutableNetworkCreation(String id, @Nullable String warnings) {
        this.id = id;
        this.warnings = warnings;
    }

    @Override
    @JsonProperty(value="Id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Warnings")
    @Nullable
    public String warnings() {
        return this.warnings;
    }

    public final ImmutableNetworkCreation withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkCreation(newValue, this.warnings);
    }

    public final ImmutableNetworkCreation withWarnings(@Nullable String value) {
        if (Objects.equals(this.warnings, value)) {
            return this;
        }
        return new ImmutableNetworkCreation(this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkCreation && this.equalsByValue((ImmutableNetworkCreation)another);
    }

    private boolean equalsByValue(ImmutableNetworkCreation another) {
        return this.id.equals(another.id) && Objects.equals(this.warnings, another.warnings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.warnings);
        return h;
    }

    public String toString() {
        return "NetworkCreation{id=" + this.id + ", warnings=" + this.warnings + "}";
    }

    public static ImmutableNetworkCreation copyOf(NetworkCreation instance) {
        if (instance instanceof ImmutableNetworkCreation) {
            return (ImmutableNetworkCreation)instance;
        }
        return ImmutableNetworkCreation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private String id;
        private String warnings;

        private Builder() {
        }

        public final Builder from(NetworkCreation instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            String warningsValue = instance.warnings();
            if (warningsValue != null) {
                this.warnings(warningsValue);
            }
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Warnings")
        public final Builder warnings(@Nullable String warnings) {
            this.warnings = warnings;
            return this;
        }

        public ImmutableNetworkCreation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkCreation(this.id, this.warnings);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build NetworkCreation, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

