/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import activity.Move;
import expressions.BigDecimalConstant;
import expressions.Expression;
import expressions.ExpressionsFactory;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import machine.Axis;
import machine.Distance;
import machine.Position;
import machine.Profile;
import machine.SymbolicPosition;
import machine.impl.MachineQueries;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import setting.MotionSettings;
import setting.PhysicalLocation;
import setting.PhysicalSettings;
import setting.SettingPackage;
import setting.Settings;

public class MoveHelper {
    private final Move move;
    private final Axis axis;
    private final Settings settings;

    public MoveHelper(Move move, Axis axis, Settings settings) {
        this.move = move;
        this.axis = axis;
        this.settings = settings;
    }

    public boolean canModify() {
        return this.getEditableObject() != null;
    }

    public Object getEditableObject() {
        Object result = this.getPhysicalLocation(false);
        if (result == null) {
            result = this.getDistance();
        }
        return null;
    }

    protected PhysicalLocation getPhysicalLocation(boolean atStartOfMove) {
        if (!this.move.isPositionMove()) {
            return null;
        }
        MotionSettings motionSettings = this.getMotionSettings();
        if (motionSettings != null) {
            Position axisPosition = atStartOfMove ? this.move.getSourcePosition().getPosition(this.axis) : this.move.getTargetPosition().getPosition(this.axis);
            return (PhysicalLocation)motionSettings.getLocationSettings().get((Object)axisPosition);
        }
        return null;
    }

    protected Map.Entry<Distance, Expression> getDistance() {
        if (this.move.isPositionMove()) {
            return null;
        }
        MotionSettings motionSettings = this.getMotionSettings();
        if (motionSettings != null) {
            for (Map.Entry entry : motionSettings.getDistanceSettings().entrySet()) {
                if (!((Distance)entry.getKey()).equals(this.move.getDistance())) continue;
                return entry;
            }
        }
        return null;
    }

    public MotionSettings getMotionSettings() {
        PhysicalSettings physicalSettings = this.settings.getPhysicalSettings(this.move.getResource(), this.move.getPeripheral());
        if (physicalSettings != null) {
            return (MotionSettings)physicalSettings.getMotionSettings().get((Object)this.axis);
        }
        return null;
    }

    public BigDecimal getSourcePosition() {
        return this.getPosition(true, BigDecimal.ZERO);
    }

    public BigDecimal getTargetPosition() {
        return this.getPosition(false, BigDecimal.ZERO);
    }

    public BigDecimal getPosition(boolean atStartOfMove, BigDecimal defaultValue) {
        if (this.move.isPositionMove()) {
            PhysicalLocation physicalLocation = this.getPhysicalLocation(atStartOfMove);
            return physicalLocation != null ? physicalLocation.getDefault() : defaultValue;
        }
        if (atStartOfMove) {
            return defaultValue;
        }
        Map.Entry<Distance, Expression> entry = this.getDistance();
        return entry != null ? entry.getValue().evaluate() : defaultValue;
    }

    public BigDecimal getValue() {
        if (this.move.isPositionMove()) {
            PhysicalLocation physicalLocation = this.getPhysicalLocation(false);
            return physicalLocation != null ? physicalLocation.getDefault() : null;
        }
        Map.Entry<Distance, Expression> entry = this.getDistance();
        return entry != null ? entry.getValue().evaluate() : null;
    }

    public void setValue(BigDecimal value) {
        BigDecimalConstant exp = ExpressionsFactory.eINSTANCE.createBigDecimalConstant();
        exp.setValue(value);
        this.setValue((Expression)exp);
    }

    public Expression toExpression(Object value) {
        if (value instanceof Expression) {
            return (Expression)value;
        }
        if (value instanceof BigDecimal) {
            BigDecimalConstant exp = ExpressionsFactory.eINSTANCE.createBigDecimalConstant();
            exp.setValue((BigDecimal)value);
            return exp;
        }
        return null;
    }

    public void setValue(EditingDomain editingDomain, Object value) {
        Expression exp = this.toExpression(value);
        if (exp == null) {
            return;
        }
        if (this.move.isPositionMove()) {
            PhysicalLocation physicalLocation = this.getPhysicalLocation(false);
            if (physicalLocation != null && exp.evaluate().compareTo(physicalLocation.getDefault()) != 0) {
                editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)physicalLocation, (EStructuralFeature)SettingPackage.Literals.PHYSICAL_LOCATION__DEFAULT_EXP, (Object)exp));
            }
        } else {
            Map.Entry<Distance, Expression> entry = this.getDistance();
            if (entry instanceof EObject) {
                editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, (EObject)entry, (EStructuralFeature)SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__VALUE, (Object)exp));
            }
        }
    }

    public void setValue(Expression expression) {
        if (this.move.isPositionMove()) {
            PhysicalLocation physicalLocation = this.getPhysicalLocation(false);
            if (physicalLocation != null) {
                physicalLocation.setDefaultExp(expression);
            }
        } else {
            Map.Entry<Distance, Expression> entry = this.getDistance();
            if (entry != null) {
                entry.setValue(expression);
            }
        }
    }

    public static String getDescription(Move move, boolean verbose) {
        StringBuffer description = new StringBuffer();
        description.append("Move ");
        if (verbose) {
            description.append(move.getResource().fqn()).append('.');
            description.append(move.getPeripheral().getName()).append(' ');
        }
        if (move.isPositionMove()) {
            description.append(move.isStopAtTarget() ? "to " : "passing ");
        } else {
            description.append(move.isStopAtTarget() ? "for " : "continuing ");
        }
        description.append(MoveHelper.getName(move));
        if (verbose) {
            description.append(" with speed profile ");
            description.append(move.getProfile().getName());
        }
        return description.toString();
    }

    public static Set<Profile> getAvailabeProfiles(Move move) {
        if (move.isPositionMove()) {
            return MachineQueries.getAvailableProfiles((SymbolicPosition)move.getSourcePosition(), (SymbolicPosition)move.getTargetPosition());
        }
        return move.getPeripheral().getProfiles().stream().collect(Collectors.toSet());
    }

    public static String getName(Move m) {
        if (m.isPositionMove()) {
            return m.getTargetPosition().getName();
        }
        return m.getDistance().getName();
    }

    public static Collection<Axis> getSettlingAxes(Move m) {
        if (m.isPositionMove()) {
            return MachineQueries.findPath((SymbolicPosition)m.getSourcePosition(), (SymbolicPosition)m.getTargetPosition(), (Profile)m.getProfile()).getSettling();
        }
        return m.getDistance().getSettling();
    }

    public static boolean isSettling(Move m, Axis axis) {
        return MoveHelper.getSettlingAxes(m).stream().anyMatch(a -> EcoreUtil.equals((EObject)a, (EObject)axis));
    }
}

