/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class AppendableIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> initial;
    private final LinkedList<E> queue = new LinkedList();

    public AppendableIterator() {
        this(Collections.emptyIterator());
    }

    public AppendableIterator(Iterator<? extends E> initial) {
        this.initial = initial;
    }

    public boolean append(E e) {
        return this.queue.add(e);
    }

    public E undoAppend() {
        return this.queue.removeLast();
    }

    @Override
    public boolean hasNext() {
        return this.initial.hasNext() || !this.queue.isEmpty();
    }

    @Override
    public E next() {
        return this.initial.hasNext() ? this.initial.next() : this.queue.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

