/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.contributions.ui.project;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsat.contributions.ui.Activator;
import org.eclipse.ui.IActionDelegate;

public class LogisticsNatureHandler
implements IActionDelegate {
    private IStructuredSelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void run(IAction action) {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        try {
            if (LogisticsNatureHandler.hasNatures(project, "org.eclipse.lsat.LogisticsProjectNature")) {
                LogisticsNatureHandler.removeNatures(project, "org.eclipse.lsat.LogisticsProjectNature");
            } else {
                LogisticsNatureHandler.addNatures(project, "org.eclipse.lsat.LogisticsProjectNature");
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.lsat.contributions.ui", e.getMessage(), (Throwable)e));
        }
    }

    private IProject getProject() {
        Object firstElement = this.selection.getFirstElement();
        IAdapterManager adapterManager = Platform.getAdapterManager();
        IResource resource = (IResource)adapterManager.getAdapter(firstElement, IResource.class);
        return resource == null ? null : resource.getProject();
    }

    public static boolean hasNatures(IProject project, String ... natureIds) throws CoreException {
        IProjectDescription projectDescription = project.getDescription();
        Set<String> newNatureIds = LogisticsNatureHandler.getNatureIds(projectDescription);
        return newNatureIds.containsAll(Arrays.asList(natureIds));
    }

    public static void addNatures(IProject project, String ... natureIds) throws CoreException {
        IProjectDescription projectDescription = project.getDescription();
        Set<String> newNatureIds = LogisticsNatureHandler.getNatureIds(projectDescription);
        newNatureIds.addAll(Arrays.asList(natureIds));
        LogisticsNatureHandler.setNatureIds(projectDescription, newNatureIds);
        project.setDescription(projectDescription, null);
    }

    public static void removeNatures(IProject project, String ... natureIds) throws CoreException {
        IProjectDescription projectDescription = project.getDescription();
        Set<String> newNatureIds = LogisticsNatureHandler.getNatureIds(projectDescription);
        newNatureIds.removeAll(Arrays.asList(natureIds));
        LogisticsNatureHandler.setNatureIds(projectDescription, newNatureIds);
        project.setDescription(projectDescription, null);
    }

    private static Set<String> getNatureIds(IProjectDescription projectDescription) {
        return new LinkedHashSet<String>(Arrays.asList(projectDescription.getNatureIds()));
    }

    private static void setNatureIds(IProjectDescription projectDescription, Set<String> natureIds) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] newNatures = workspace.sortNatureSet(natureIds.toArray(new String[natureIds.size()]));
        projectDescription.setNatureIds(newNatures);
    }
}

