/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCompletionParams;
import org.eclipse.lsp4jakarta.commons.JavaCursorContextKind;
import org.eclipse.lsp4jakarta.commons.JavaCursorContextResult;
import org.eclipse.lsp4jakarta.jdt.codeAction.CodeActionHandler;
import org.eclipse.lsp4jakarta.jdt.core.ASTNodeUtils;
import org.eclipse.lsp4jakarta.jdt.core.DiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.annotations.AnnotationDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.beanvalidation.BeanValidationDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.cdi.ManagedBeanDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.di.DependencyInjectionDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jax_rs.Jax_RSClassDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jax_rs.ResourceMethodDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jsonb.JsonbDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jsonp.JsonpDiagnosticCollector;
import org.eclipse.lsp4jakarta.jdt.core.persistence.PersistenceEntityDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.persistence.PersistenceMapKeyDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.servlet.FilterDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.servlet.ListenerDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.servlet.ServletDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.websocket.WebSocketDiagnosticsCollector;

public class JDTServicesManager {
    private List<DiagnosticsCollector> diagnosticsCollectors = new ArrayList<DiagnosticsCollector>();
    private static final JDTServicesManager INSTANCE = new JDTServicesManager();
    private final CodeActionHandler codeActionHandler;

    public static JDTServicesManager getInstance() {
        return INSTANCE;
    }

    private JDTServicesManager() {
        this.diagnosticsCollectors.add(new ServletDiagnosticsCollector());
        this.diagnosticsCollectors.add(new AnnotationDiagnosticsCollector());
        this.diagnosticsCollectors.add(new FilterDiagnosticsCollector());
        this.diagnosticsCollectors.add(new ListenerDiagnosticsCollector());
        this.diagnosticsCollectors.add(new BeanValidationDiagnosticsCollector());
        this.diagnosticsCollectors.add(new PersistenceEntityDiagnosticsCollector());
        this.diagnosticsCollectors.add(new PersistenceMapKeyDiagnosticsCollector());
        this.diagnosticsCollectors.add(new ResourceMethodDiagnosticsCollector());
        this.diagnosticsCollectors.add(new Jax_RSClassDiagnosticsCollector());
        this.diagnosticsCollectors.add(new JsonbDiagnosticsCollector());
        this.diagnosticsCollectors.add(new ManagedBeanDiagnosticsCollector());
        this.diagnosticsCollectors.add(new DependencyInjectionDiagnosticsCollector());
        this.diagnosticsCollectors.add(new JsonpDiagnosticCollector());
        this.diagnosticsCollectors.add(new WebSocketDiagnosticsCollector());
        this.codeActionHandler = new CodeActionHandler();
    }

    public List<PublishDiagnosticsParams> getJavaDiagnostics(JakartaDiagnosticsParams javaParams) {
        return this.getJavaDiagnostics(javaParams.getUris(), (IProgressMonitor)new NullProgressMonitor());
    }

    public List<PublishDiagnosticsParams> getJavaDiagnostics(List<String> uris, IProgressMonitor monitor) {
        if (uris == null) {
            return Collections.emptyList();
        }
        ArrayList<PublishDiagnosticsParams> publishDiagnostics = new ArrayList<PublishDiagnosticsParams>();
        for (String uri : uris) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            URI u = JDTUtils.toURI(uri);
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(u);
            for (DiagnosticsCollector d : this.diagnosticsCollectors) {
                if (monitor.isCanceled()) break;
                d.collectDiagnostics(unit, diagnostics);
            }
            PublishDiagnosticsParams publishDiagnostic = new PublishDiagnosticsParams(uri, diagnostics);
            publishDiagnostics.add(publishDiagnostic);
            if (!monitor.isCanceled()) continue;
            return Collections.emptyList();
        }
        return publishDiagnostics;
    }

    public List<String> getExistingContextsFromClassPath(String uri, List<String> snippetContexts) {
        ArrayList<String> classpath = new ArrayList<String>();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(JDTUtils.toURI(uri));
        IJavaProject project = unit.getJavaProject();
        if (project != null) {
            snippetContexts.forEach(ctx -> {
                IType classPathctx = null;
                try {
                    classPathctx = project.findType(ctx);
                    if (classPathctx != null) {
                        classpath.add((String)ctx);
                    } else {
                        classpath.add(null);
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException((String)"Failed to retrieve projectContext from JDT...", (Throwable)e);
                    classpath.add(null);
                }
            });
        } else {
            snippetContexts.forEach(ctx -> classpath.add(null));
        }
        String className = unit.getElementName();
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5);
        }
        String packageName = unit.getParent() != null ? unit.getParent().getElementName() : "";
        classpath.add(packageName);
        classpath.add(className);
        return classpath;
    }

    public List<CodeAction> getCodeAction(JakartaJavaCodeActionParams params, JDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        return this.codeActionHandler.codeAction(params, utils, monitor);
    }

    public JavaCursorContextResult javaCursorContext(JakartaJavaCompletionParams params, JDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = JDTServicesManager.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return new JavaCursorContextResult(JavaCursorContextKind.IN_EMPTY_FILE, "");
        }
        CompilationUnit ast = ASTResolving.createQuickFixAST((ICompilationUnit)((ICompilationUnit)typeRoot), (IProgressMonitor)monitor);
        JavaCursorContextKind kind = JDTServicesManager.getJavaCursorContextKind(params, typeRoot, ast, utils, monitor);
        String prefix = JDTServicesManager.getJavaCursorPrefix(params, typeRoot, ast, utils, monitor);
        return new JavaCursorContextResult(kind, prefix);
    }

    private static JavaCursorContextKind getJavaCursorContextKind(JakartaJavaCompletionParams params, ITypeRoot typeRoot, CompilationUnit ast, JDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        ASTNode node;
        if (typeRoot.findPrimaryType() == null) {
            return JavaCursorContextKind.IN_EMPTY_FILE;
        }
        Position completionPosition = params.getPosition();
        int completionOffset = JDTUtils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
        NodeFinder nodeFinder = new NodeFinder((ASTNode)ast, completionOffset, 0);
        ASTNode oldNode = node = nodeFinder.getCoveringNode();
        while (!(node == null || node instanceof AbstractTypeDeclaration && JDTServicesManager.offsetOfFirstNonAnnotationModifier((BodyDeclaration)node) < completionOffset)) {
            if (node.getParent() != null) {
                switch (node.getParent().getNodeType()) {
                    case 23: 
                    case 31: 
                    case 72: 
                    case 82: {
                        if (ASTNodeUtils.isAnnotation(node) || node.getStartPosition() >= completionOffset) break;
                        return JavaCursorContextKind.NONE;
                    }
                }
            }
            oldNode = node;
            node = node.getParent();
        }
        if (node == null) {
            FindWhatsBeingAnnotatedASTVisitor visitor = new FindWhatsBeingAnnotatedASTVisitor(completionOffset, false);
            oldNode.accept((ASTVisitor)visitor);
            switch (visitor.getAnnotatedNodeType()) {
                case 55: 
                case 71: 
                case 81: 
                case 103: {
                    if (visitor.isInAnnotations()) {
                        return JavaCursorContextKind.IN_CLASS_ANNOTATIONS;
                    }
                    return JavaCursorContextKind.BEFORE_CLASS;
                }
            }
            return JavaCursorContextKind.NONE;
        }
        AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
        FindWhatsBeingAnnotatedASTVisitor visitor = new FindWhatsBeingAnnotatedASTVisitor(completionOffset);
        typeDeclaration.accept((ASTVisitor)visitor);
        switch (visitor.getAnnotatedNodeType()) {
            case 55: 
            case 71: 
            case 81: 
            case 103: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_CLASS_ANNOTATIONS : JavaCursorContextKind.BEFORE_CLASS;
            }
            case 31: 
            case 82: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_METHOD_ANNOTATIONS : JavaCursorContextKind.BEFORE_METHOD;
            }
            case 23: 
            case 72: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_FIELD_ANNOTATIONS : JavaCursorContextKind.BEFORE_FIELD;
            }
        }
        return JavaCursorContextKind.IN_CLASS;
    }

    @NonNull
    private static String getJavaCursorPrefix(JakartaJavaCompletionParams params, ITypeRoot typeRoot, CompilationUnit ast, JDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        String fileContents;
        int completionOffset;
        block5: {
            Position completionPosition = params.getPosition();
            completionOffset = JDTUtils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
            fileContents = null;
            try {
                buffer = typeRoot.getBuffer();
                if (buffer != null) break block5;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return "";
            }
        }
        fileContents = buffer.getContents();
        if (fileContents == null) {
            return "";
        }
        int i = completionOffset;
        while (i > 0 && !Character.isWhitespace(fileContents.charAt(i - 1))) {
            --i;
        }
        return fileContents.substring(i, completionOffset);
    }

    private static ITypeRoot resolveTypeRoot(String uri, JDTUtils utils, IProgressMonitor monitor) {
        JDTUtils.waitForLifecycleJobs(monitor);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        IClassFile classFile = null;
        if (unit == null ? (classFile = JDTUtils.resolveClassFile(uri)) == null : !unit.getResource().exists() || monitor.isCanceled()) {
            return null;
        }
        return unit != null ? unit : classFile;
    }

    private static int offsetOfFirstNonAnnotationModifier(BodyDeclaration node) {
        List modifiers = node.modifiers();
        int i = 0;
        while (i < modifiers.size()) {
            ASTNode modifier = (ASTNode)modifiers.get(i);
            if (!ASTNodeUtils.isAnnotation(modifier)) {
                return modifier.getStartPosition();
            }
            ++i;
        }
        BodyDeclaration bodyDeclaration = node;
        if (bodyDeclaration instanceof MethodDeclaration && (i = (MethodDeclaration)bodyDeclaration) == (MethodDeclaration)bodyDeclaration) {
            if (method.getReturnType2() != null) {
                return method.getReturnType2().getStartPosition();
            }
            return method.getName().getStartPosition();
        }
        if (node instanceof FieldDeclaration var5_7) {
            return field.getType().getStartPosition();
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
        int nameOffset = type.getName().getStartPosition();
        switch (type.getNodeType()) {
            case 55: {
                if (((TypeDeclaration)type).isInterface()) {
                    v0 = "interface";
                    break;
                }
                v0 = "class";
                break;
            }
            case 71: {
                v0 = "enum";
                break;
            }
            case 81: {
                v0 = "@interface";
                break;
            }
            case 103: {
                v0 = "record";
                break;
            }
            default: {
                v0 = "";
            }
        }
        int keywordLength = v0.length();
        return nameOffset - (keywordLength + 1);
    }

    private static boolean isGenerated(ASTNode node) {
        try {
            return (Boolean)node.getClass().getField("$isGenerated").get(node);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return false;
        }
    }

    private static class FindWhatsBeingAnnotatedASTVisitor
    extends ASTVisitor {
        private int completionOffset;
        private int closest = Integer.MAX_VALUE;
        private int annotatedNode = 0;
        private boolean visitedParentType;
        private boolean inAnnotations = false;

        public FindWhatsBeingAnnotatedASTVisitor(int completionOffset, boolean startingInParent) {
            this.completionOffset = completionOffset;
            this.visitedParentType = !startingInParent;
        }

        public FindWhatsBeingAnnotatedASTVisitor(int completionOffset) {
            this(completionOffset, true);
        }

        public boolean visit(MethodDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(FieldDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(EnumConstantDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(RecordDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        private boolean visitAbstractType(AbstractTypeDeclaration node) {
            if (!this.visitedParentType) {
                this.visitedParentType = true;
                return true;
            }
            return this.visitNode((BodyDeclaration)node);
        }

        private boolean visitNode(BodyDeclaration node) {
            int start;
            if (JDTServicesManager.isGenerated((ASTNode)node)) {
                return false;
            }
            int n = start = node.modifiers().isEmpty() ? node.getStartPosition() : JDTServicesManager.offsetOfFirstNonAnnotationModifier(node);
            if (start < this.closest && this.completionOffset <= start) {
                this.closest = node.getStartPosition();
                this.annotatedNode = node.getNodeType();
                this.inAnnotations = node.getStartPosition() < this.completionOffset && this.completionOffset <= start;
            }
            return false;
        }

        public int getAnnotatedNodeType() {
            return this.annotatedNode;
        }

        public boolean isInAnnotations() {
            return this.inAnnotations;
        }
    }
}

