/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.Messages;

public class AnnotationDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-annotations";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            try {
                IField[] iFieldArray;
                IType[] types;
                int n;
                IType[] annotations;
                IPackageDeclaration[] packages;
                ArrayList<Tuple.Two> annotatables = new ArrayList<Tuple.Two>();
                String[] validAnnotations = new String[]{"jakarta.annotation.Generated"};
                String[] validTypeAnnotations = new String[]{"jakarta.annotation.Generated", "jakarta.annotation.Resource"};
                String[] validMethodAnnotations = new String[]{"jakarta.annotation.Generated", "jakarta.annotation.PostConstruct", "jakarta.annotation.PreDestroy", "jakarta.annotation.Resource"};
                IPackageDeclaration[] iPackageDeclarationArray = packages = unit.getPackageDeclarations();
                int n2 = packages.length;
                int n3 = 0;
                while (n3 < n2) {
                    IPackageDeclaration p = iPackageDeclarationArray[n3];
                    IType[] iTypeArray = annotations = p.getAnnotations();
                    n = annotations.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IType annotation = iTypeArray[n4];
                        if (AnnotationDiagnosticsCollector.isValidAnnotation(annotation.getElementName(), validAnnotations)) {
                            annotatables.add(new Tuple.Two((Object)annotation, (Object)p));
                        }
                        ++n4;
                    }
                    ++n3;
                }
                annotations = types = unit.getAllTypes();
                int n5 = types.length;
                n2 = 0;
                while (n2 < n5) {
                    IField[] fields;
                    int n6;
                    IAnnotation[] iAnnotationArray;
                    int n7;
                    IMethod[] methods;
                    IAnnotation[] annotations2;
                    IType type = annotations[n2];
                    IAnnotation[] iAnnotationArray2 = annotations2 = type.getAnnotations();
                    int n8 = annotations2.length;
                    n = 0;
                    while (n < n8) {
                        IAnnotation annotation = iAnnotationArray2[n];
                        if (AnnotationDiagnosticsCollector.isValidAnnotation(annotation.getElementName(), validTypeAnnotations)) {
                            annotatables.add(new Tuple.Two((Object)annotation, (Object)type));
                        }
                        ++n;
                    }
                    IMethod[] iMethodArray = methods = type.getMethods();
                    int n9 = methods.length;
                    n8 = 0;
                    while (n8 < n9) {
                        IMethod method = iMethodArray[n8];
                        IAnnotation[] iAnnotationArray3 = annotations2 = method.getAnnotations();
                        n7 = annotations2.length;
                        int n10 = 0;
                        while (n10 < n7) {
                            IAnnotation annotation = iAnnotationArray3[n10];
                            if (AnnotationDiagnosticsCollector.isValidAnnotation(annotation.getElementName(), validMethodAnnotations)) {
                                annotatables.add(new Tuple.Two((Object)annotation, (Object)method));
                            }
                            ++n10;
                        }
                        ILocalVariable[] parameters = method.getParameters();
                        iAnnotationArray = parameters;
                        n6 = parameters.length;
                        n7 = 0;
                        while (n7 < n6) {
                            IAnnotation parameter = iAnnotationArray[n7];
                            IAnnotation[] iAnnotationArray4 = annotations2 = parameter.getAnnotations();
                            int n11 = annotations2.length;
                            int n12 = 0;
                            while (n12 < n11) {
                                IAnnotation annotation = iAnnotationArray4[n12];
                                if (AnnotationDiagnosticsCollector.isValidAnnotation(annotation.getElementName(), validAnnotations)) {
                                    annotatables.add(new Tuple.Two((Object)annotation, (Object)parameter));
                                }
                                ++n12;
                            }
                            ++n7;
                        }
                        ++n8;
                    }
                    iFieldArray = fields = type.getFields();
                    int n13 = fields.length;
                    n9 = 0;
                    while (n9 < n13) {
                        IField field = iFieldArray[n9];
                        iAnnotationArray = annotations2 = field.getAnnotations();
                        n6 = annotations2.length;
                        n7 = 0;
                        while (n7 < n6) {
                            IAnnotation annotation = iAnnotationArray[n7];
                            if (AnnotationDiagnosticsCollector.isValidAnnotation(annotation.getElementName(), validTypeAnnotations)) {
                                annotatables.add(new Tuple.Two((Object)annotation, (Object)field));
                            }
                            ++n7;
                        }
                        ++n9;
                    }
                    ++n2;
                }
                for (Tuple.Two annotatable : annotatables) {
                    IMethod method;
                    IType type;
                    IAnnotation annotation = (IAnnotation)annotatable.getFirst();
                    IAnnotatable element = (IAnnotatable)annotatable.getSecond();
                    if (AnnotationDiagnosticsCollector.isMatchedAnnotation(unit, annotation, "jakarta.annotation.Generated")) {
                        IMemberValuePair[] field = annotation.getMemberValuePairs();
                        int fields = field.length;
                        int methods = 0;
                        while (methods < fields) {
                            String date;
                            IMemberValuePair pair = field[methods];
                            if (pair.getMemberName().equals("date") && pair.getValue() instanceof String && !(date = (String)pair.getValue()).equals("") && !Pattern.matches("^([\\+-]?\\d{4}(?!\\d{2}\\b))((-?)((0[1-9]|1[0-2])(\\3([12]\\d|0[1-9]|3[01]))?|W([0-4]\\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\\d|[12]\\d{2}|3([0-5]\\d|6[1-6])))([T\\s]((([01]\\d|2[0-3])((:?)[0-5]\\d)?|24\\:?00)([\\.,]\\d+(?!:))?)?(\\17[0-5]\\d([\\.,]\\d+)?)?([zZ]|([\\+-])([01]\\d|2[0-3]):?([0-5]\\d)?)?)?)?$", date)) {
                                String diagnosticMessage = Messages.getMessage("AnnotationMustDefineAttributeFollowing8601", "@Generated", "date");
                                diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, diagnosticMessage, "InvalidDateFormat", null, DiagnosticSeverity.Error));
                            }
                            ++methods;
                        }
                    } else if (AnnotationDiagnosticsCollector.isMatchedAnnotation(unit, annotation, "jakarta.annotation.Resource") && element instanceof IType && (type = (IType)element).getElementType() == 7 && type.isClass()) {
                        String diagnosticMessage;
                        Boolean nameEmpty = true;
                        Boolean typeEmpty = true;
                        iFieldArray = annotation.getMemberValuePairs();
                        int n14 = iFieldArray.length;
                        int n15 = 0;
                        while (n15 < n14) {
                            IField pair = iFieldArray[n15];
                            if (pair.getMemberName().equals("name")) {
                                nameEmpty = false;
                            }
                            if (pair.getMemberName().equals("type")) {
                                typeEmpty = false;
                            }
                            ++n15;
                        }
                        if (nameEmpty.booleanValue()) {
                            diagnosticMessage = Messages.getMessage("AnnotationMustDefineAttribute", "@Resource", "name");
                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, diagnosticMessage, "MissingResourceNameAttribute", null, DiagnosticSeverity.Error));
                        }
                        if (typeEmpty.booleanValue()) {
                            diagnosticMessage = Messages.getMessage("AnnotationMustDefineAttribute", "@Resource", "type");
                            diagnostics.add(this.createDiagnostic((IJavaElement)annotation, unit, diagnosticMessage, "MissingResourceTypeAttribute", null, DiagnosticSeverity.Error));
                        }
                    }
                    if (AnnotationDiagnosticsCollector.isMatchedAnnotation(unit, annotation, "jakarta.annotation.PostConstruct")) {
                        if (!(element instanceof IMethod)) continue;
                        method = (IMethod)element;
                        if (method.getNumberOfParameters() != 0) {
                            String diagnosticMessage = AnnotationDiagnosticsCollector.generateDiagnosticMethod("PostConstruct", "not have any parameters.");
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, diagnosticMessage, "PostConstructParams", null, DiagnosticSeverity.Error));
                        }
                        if (!method.getReturnType().equals("V")) {
                            String diagnosticMessage = AnnotationDiagnosticsCollector.generateDiagnosticMethod("PostConstruct", "be void.");
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, diagnosticMessage, "PostConstructReturnType", null, DiagnosticSeverity.Error));
                        }
                        if (method.getExceptionTypes().length == 0) continue;
                        String diagnosticMessage = AnnotationDiagnosticsCollector.generateDiagnosticMethod("PostConstruct", "not throw checked exceptions.");
                        diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, diagnosticMessage, "PostConstructException", null, DiagnosticSeverity.Warning));
                        continue;
                    }
                    if (!AnnotationDiagnosticsCollector.isMatchedAnnotation(unit, annotation, "jakarta.annotation.PreDestroy") || !(element instanceof IMethod)) continue;
                    method = (IMethod)element;
                    if (method.getNumberOfParameters() != 0) {
                        String diagnosticMessage = AnnotationDiagnosticsCollector.generateDiagnosticMethod("PreDestroy", "not have any parameters.");
                        diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, diagnosticMessage, "PreDestroyParams", null, DiagnosticSeverity.Error));
                    }
                    if (Flags.isStatic((int)method.getFlags())) {
                        String diagnosticMessage = AnnotationDiagnosticsCollector.generateDiagnosticMethod("PreDestroy", "not be static.");
                        diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, diagnosticMessage, "PreDestroyStatic", method.getElementType(), DiagnosticSeverity.Error));
                    }
                    if (method.getExceptionTypes().length == 0) continue;
                    String diagnosticMessage = AnnotationDiagnosticsCollector.generateDiagnosticMethod("PreDestroy", "not throw checked exceptions.");
                    diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, diagnosticMessage, "PreDestroyException", null, DiagnosticSeverity.Warning));
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
            }
        }
    }

    private static String generateDiagnosticMethod(String annotation, String message) {
        String finalMessage = "A method with the @" + annotation + " annotation must " + message;
        return finalMessage;
    }

    private static boolean isValidAnnotation(String annotationName, String[] validAnnotations) {
        String[] stringArray = validAnnotations;
        int n = validAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            String fqName = stringArray[n2];
            if (fqName.endsWith(annotationName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

