/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.jax_rs;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.junit.Test;

public class ResourceClassConstructorTest
extends BaseJakartaTest {
    protected static JDTUtils JDT_UTILS = new JDTUtils();

    @Test
    public void MultipleConstructorsWithEqualParams() throws Exception {
        JDTUtils utils = JDT_UTILS;
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jax_rs/RootResourceClassConstructorsEqualLen.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(7, 8, 45, "Multiple constructors have the same number of parameters, it might be ambiguous which constructor is used.", DiagnosticSeverity.Warning, "jakarta-jax_rs", "AmbiguousConstructors");
        Diagnostic d2 = JakartaForJavaAssert.d(11, 8, 45, "Multiple constructors have the same number of parameters, it might be ambiguous which constructor is used.", DiagnosticSeverity.Warning, "jakarta-jax_rs", "AmbiguousConstructors");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2);
    }

    @Test
    public void MultipleConstructorsWithDifferentLength() throws Exception {
        JDTUtils utils = JDT_UTILS;
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jax_rs/RootResourceClassConstructorsDiffLen.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d = JakartaForJavaAssert.d(7, 8, 44, "This constructor is unused, as root resource classes will only use the constructor with the most parameters.", DiagnosticSeverity.Warning, "jakarta-jax_rs", "UnusedConstructor");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d);
    }

    @Test
    public void NoPublicConstructor() throws Exception {
        JDTUtils utils = JDT_UTILS;
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jax_rs/NoPublicConstructorClass.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(7, 12, 36, "Root resource classes are instantiated by the JAX-RS runtime and MUST have a public constructor", DiagnosticSeverity.Error, "jakarta-jax_rs", "NoPublicConstructors");
        Diagnostic d2 = JakartaForJavaAssert.d(11, 14, 38, "Root resource classes are instantiated by the JAX-RS runtime and MUST have a public constructor", DiagnosticSeverity.Error, "jakarta-jax_rs", "NoPublicConstructors");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2);
    }

    @Test
    public void NoPublicConstructorProviderClass() throws Exception {
        JDTUtils utils = JDT_UTILS;
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jax_rs/NoPublicConstructorProviderClass.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(19, 12, 44, "Provider classes are instantiated by the JAX-RS runtime and MUST have a public constructor", DiagnosticSeverity.Error, "jakarta-jax_rs", "NoPublicConstructors");
        Diagnostic d2 = JakartaForJavaAssert.d(23, 14, 46, "Provider classes are instantiated by the JAX-RS runtime and MUST have a public constructor", DiagnosticSeverity.Error, "jakarta-jax_rs", "NoPublicConstructors");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2);
    }
}

