/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import javax.imageio.ImageWriteParam;
import org.eclipse.birt.chart.device.image.JavaxImageIOWriter;

public final class JpegRendererImpl
extends JavaxImageIOWriter {
    private boolean isQualitySet = false;
    private int jpegQuality;

    @Override
    protected String getFormat() {
        return "jpeg";
    }

    @Override
    protected int getImageType() {
        return 5;
    }

    public String getMimeType() {
        return "image/jpeg";
    }

    @Override
    protected void updateWriterParameters(ImageWriteParam iwp) {
        float quality = this.isQualitySet ? (float)this.jpegQuality : 0.95f;
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
    }

    public void setCompressionQuality(int jpegQuality) {
        if (jpegQuality < 0 || jpegQuality > 1) {
            throw new IllegalArgumentException("Jpeg quality must be within the [0-1] range");
        }
        this.isQualitySet = true;
        this.jpegQuality = jpegQuality;
    }

    @Override
    protected boolean supportsTransparency() {
        return false;
    }
}

