/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.HeapObjectsTracker;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="find_strings")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/find_strings.html")
@Icon(value="/META-INF/icons/find_strings.gif")
@Subject(value="java.lang.String")
public class FindStringsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none", isMandatory=false)
    public IHeapObjectArgument objects = new IHeapObjectArgument(){

        @Override
        public Iterator<int[]> iterator() {
            return null;
        }

        @Override
        public int[] getIds(IProgressListener listener) throws SnapshotException {
            return null;
        }

        @Override
        public String getLabel() {
            return "java.lang.String";
        }
    };
    @Argument
    public Pattern pattern;

    public IResult execute(IProgressListener listener) throws Exception {
        ArrayInt result;
        block16: {
            boolean onlyStrings = false;
            result = new ArrayInt();
            Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.String", false);
            if (this.objects == null) {
                if (classes != null) {
                    for (IClass clasz : classes) {
                        int[] objectIds = clasz.getObjectIds();
                        listener.beginTask(Messages.FindStringsQuery_SearchingStrings, objectIds.length);
                        int[] nArray = objectIds;
                        int n = objectIds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int id = nArray[n2];
                            if (!listener.isCanceled()) {
                                String value = this.snapshot.getObject(id).getClassSpecificName();
                                if (value != null && this.pattern.matcher(value).matches()) {
                                    result.add(id);
                                }
                                listener.worked(1);
                                ++n2;
                                continue;
                            }
                            break block16;
                        }
                        listener.done();
                    }
                }
            } else if (classes != null && !classes.isEmpty()) {
                IClass javaLangString = classes.iterator().next();
                HeapObjectsTracker hot = new HeapObjectsTracker(this.objects);
                listener.beginTask(Messages.FindStringsQuery_SearchingStrings, hot.totalWork());
                Iterator it = this.objects.iterator();
                block2: while (it.hasNext()) {
                    int[] objectIds = (int[])it.next();
                    hot.beginBlock(objectIds, !it.hasNext());
                    int[] nArray = objectIds;
                    int n = objectIds.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int id = nArray[n3];
                        if (listener.isCanceled()) break block2;
                        if (this.snapshot.isArray(id) || this.snapshot.isClass(id) || this.snapshot.isClassLoader(id)) {
                            listener.worked(hot.work());
                        } else {
                            IObject instance = this.snapshot.getObject(id);
                            if (onlyStrings && !javaLangString.equals(instance.getClazz())) {
                                listener.worked(hot.work());
                            } else {
                                String value = instance.getClassSpecificName();
                                if (value != null && this.pattern.matcher(value).matches()) {
                                    result.add(id);
                                }
                                listener.worked(hot.work());
                            }
                        }
                        ++n3;
                    }
                    listener.worked(hot.endBlock());
                }
                listener.done();
            }
        }
        if (listener.isCanceled() && result.isEmpty()) {
            throw new IProgressListener.OperationCanceledException();
        }
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }
}

