/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2m.atl.engine.vm.NativeOperation;
import org.eclipse.m2m.atl.engine.vm.NativeStackFrame;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;

public class ClassNativeOperation
extends NativeOperation {
    public ClassNativeOperation(Method method, List parameters, ASMOclType returnType, ASMOclType contextType) {
        super(method, parameters, returnType, contextType);
    }

    public ClassNativeOperation(Method method) {
        super(method, ClassNativeOperation.getParameters(method), ClassNativeOperation.getReturnType(method), ClassNativeOperation.getContextType(method));
    }

    private static List getParameters(Method method) {
        ArrayList<ASMOclType> ret = new ArrayList<ASMOclType>();
        Class<?>[] paramTypes = method.getParameterTypes();
        int i = 2;
        while (i < paramTypes.length) {
            ret.add(ClassNativeOperation.getASMType(paramTypes[i], false));
            ++i;
        }
        return ret;
    }

    private static ASMOclType getReturnType(Method method) {
        ASMOclType ret = null;
        ret = ClassNativeOperation.getASMType(method.getReturnType(), false);
        return ret;
    }

    private static ASMOclType getContextType(Method method) {
        ASMOclType ret = null;
        ret = ClassNativeOperation.getASMType(method.getParameterTypes()[1], false);
        return ret;
    }

    public ASMOclAny exec(StackFrame frame) {
        ASMOclAny ret = null;
        try {
            ArrayList<StackFrame> args = new ArrayList<StackFrame>(frame.getArgs());
            args.add(0, frame);
            ret = (ASMOclAny)this.getMethod().invoke(null, args.toArray());
        }
        catch (IllegalAccessException iae) {
            frame.printStackTrace(iae);
        }
        catch (IllegalArgumentException iae2) {
            frame.printStackTrace(iae2);
        }
        catch (InvocationTargetException ite) {
            frame.printStackTrace(ite);
        }
        ((NativeStackFrame)frame).setRet(ret);
        frame.leaveFrame();
        return ret;
    }
}

