/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.BasicQVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.Execution2GraphVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractInvocation;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalObjectManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyObjectManager;

public class QVTiIncrementalExecutor
extends BasicQVTiExecutor {
    public static int RUN_TIME_EVALUATOR_API_VERSION = 1102;
    protected final @NonNull Mode mode;
    protected final @NonNull QVTiTransformationAnalysis transformationAnalysis;
    protected final @NonNull InvocationManager invocationManager;
    protected final @NonNull ObjectManager objectManager;
    private @Nullable InterpretedInvocation currentInvocation = null;

    public QVTiIncrementalExecutor(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull Transformation transformation, @NonNull Mode mode) {
        super(environmentFactory, transformation);
        this.mode = mode;
        this.transformationAnalysis = this.getModelManager().getTransformationAnalysis();
        boolean isLazy = mode == Mode.LAZY;
        this.invocationManager = isLazy ? new LazyInvocationManager() : new IncrementalInvocationManager();
        this.objectManager = isLazy ? new LazyObjectManager((LazyInvocationManager)this.invocationManager) : new IncrementalObjectManager((IncrementalInvocationManager)this.invocationManager);
    }

    public @NonNull String createGraph(@NonNull GraphStringBuilder s) {
        Execution2GraphVisitor execution2GraphVisitor = new Execution2GraphVisitor(s);
        this.invocationManager.accept((ExecutionVisitor)execution2GraphVisitor);
        this.objectManager.accept((ExecutionVisitor)execution2GraphVisitor);
        String string = ((Object)((Object)execution2GraphVisitor)).toString();
        assert (string != null);
        return string;
    }

    @Override
    public @Nullable Object internalExecuteMappingCall(final @NonNull MappingCall mappingCall, final @NonNull Map<Variable, Object> variable2value, final @NonNull EvaluationVisitor undecoratedVisitor) {
        if (this.mode == Mode.LAZY) {
            Mapping asMapping = mappingCall.getReferredMapping();
            assert (asMapping != null);
            if (!this.transformationAnalysis.isHazardous(asMapping)) {
                return QVTiIncrementalExecutor.super.internalExecuteMappingCall(mappingCall, variable2value, undecoratedVisitor);
            }
        }
        ArrayList<Object> newBoundValues = new ArrayList<Object>();
        for (MappingCallBinding binding : mappingCall.getBinding()) {
            Variable boundVariable = (Variable)ClassUtil.nonNullModel((Object)binding.getBoundVariable());
            Object valueOrValues = variable2value.get(boundVariable);
            newBoundValues.add(valueOrValues);
        }
        InterpretedInvocation invocation = new InterpretedInvocation(newBoundValues){

            public boolean execute() throws InvocationFailedException, ReflectiveOperationException {
                QVTiIncrementalExecutor.this.currentInvocation = this;
                try {
                    this.returnStatus = QVTiIncrementalExecutor.super.internalExecuteMappingCall(mappingCall, variable2value, undecoratedVisitor);
                    boolean bl = this.returnStatus == ValueUtil.TRUE_VALUE;
                    return bl;
                }
                finally {
                    QVTiIncrementalExecutor.this.currentInvocation = null;
                }
            }

            public String toString() {
                return String.valueOf(mappingCall.getReferredMapping().getName()) + "@" + Integer.toHexString(System.identityHashCode((Object)this));
            }
        };
        AbstractTransformer.INVOCATIONS.println("invoke " + (Object)((Object)invocation));
        try {
            this.invocationManager.invoke((Invocation)invocation, true);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public @Nullable Object internalExecuteNavigationCallExp(@NonNull NavigationCallExp navigationCallExp, @NonNull Property referredProperty, @Nullable Object sourceValue) {
        InterpretedInvocation currentInvocation2;
        Object ecoreValue;
        EStructuralFeature eFeature;
        Mapping asMapping;
        QVTiModelManager modelManager;
        Integer cacheIndex;
        if (referredProperty.isIsImplicit() && (cacheIndex = (modelManager = this.getModelManager()).getTransformationAnalysis().getCacheIndex((OppositePropertyCallExp)navigationCallExp)) != null) {
            if (sourceValue != null) {
                Object middleOpposite = modelManager.getUnnavigableOpposite(cacheIndex, sourceValue);
                if (middleOpposite != null) {
                    return middleOpposite;
                }
            } else {
                throw new InvalidValueException("Failed to evaluate '" + referredProperty + "'", new Object[]{sourceValue, navigationCallExp});
            }
        }
        if ((asMapping = QVTimperativeUtil.getContainingMapping((EObject)navigationCallExp)) != null && this.transformationAnalysis.isHazardousRead(asMapping, navigationCallExp)) {
            if (sourceValue == null) {
                throw new InvalidValueException("Null source for '" + referredProperty + "'", new Object[]{sourceValue, navigationCallExp});
            }
            boolean isOpposite = false;
            eFeature = (EStructuralFeature)referredProperty.getESObject();
            if (eFeature == null) {
                assert (referredProperty.isIsImplicit());
                isOpposite = true;
                eFeature = (EStructuralFeature)referredProperty.getOpposite().getESObject();
            }
            this.objectManager.getting(sourceValue, eFeature, isOpposite);
            ecoreValue = super.internalExecuteNavigationCallExp(navigationCallExp, referredProperty, sourceValue);
            AbstractTransformer.INVOCATIONS.println("got " + eFeature.getEContainingClass().getName() + "::" + eFeature.getName() + " for " + sourceValue + " = " + ecoreValue);
        } else {
            ecoreValue = super.internalExecuteNavigationCallExp(navigationCallExp, referredProperty, sourceValue);
        }
        if (this.mode != Mode.LAZY && (currentInvocation2 = this.currentInvocation) != null) {
            assert (sourceValue != null);
            eFeature = (EStructuralFeature)referredProperty.getESObject();
            assert (currentInvocation2 != null);
            this.objectManager.got((Invocation.Incremental)currentInvocation2, sourceValue, eFeature, ecoreValue);
        }
        return ecoreValue;
    }

    @Override
    public void internalExecuteNavigationAssignment(@NonNull NavigationAssignment navigationAssignment, @NonNull Object sourceObject, @Nullable Object ecoreValue, @Nullable Object childKey) {
        super.internalExecuteNavigationAssignment(navigationAssignment, sourceObject, ecoreValue, childKey);
        if (this.mode == Mode.LAZY) {
            Mapping asMapping = QVTimperativeUtil.getContainingMapping((EObject)navigationAssignment);
            assert (asMapping != null);
            if (this.transformationAnalysis.isHazardousWrite(asMapping, navigationAssignment)) {
                Property targetProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
                assert (targetProperty != null);
                EStructuralFeature eFeature = (EStructuralFeature)targetProperty.getESObject();
                this.objectManager.assigned(sourceObject, eFeature, ecoreValue, childKey);
            }
        } else {
            Property targetProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
            assert (targetProperty != null);
            EStructuralFeature eFeature = (EStructuralFeature)targetProperty.getESObject();
            InterpretedInvocation currentInvocation2 = this.currentInvocation;
            assert (currentInvocation2 != null);
            this.objectManager.assigned((Invocation.Incremental)currentInvocation2, sourceObject, eFeature, ecoreValue, childKey);
        }
    }

    @Override
    public @Nullable Object internalExecuteRealizedVariable(@NonNull RealizedVariable realizedVariable, @NonNull EvaluationVisitor undecoratedVisitor) {
        Object element = super.internalExecuteRealizedVariable(realizedVariable, undecoratedVisitor);
        if (element != null && this.mode == Mode.INCREMENTAL) {
            InterpretedInvocation currentInvocation2 = this.currentInvocation;
            assert (currentInvocation2 != null);
            this.objectManager.created((Invocation.Incremental)currentInvocation2, element);
        }
        return element;
    }

    protected static abstract class InterpretedInvocation
    extends AbstractInvocation.Incremental {
        protected final @NonNull List<Object> theseValues;
        protected Object returnStatus;

        public InterpretedInvocation(@NonNull List<Object> theseValues) {
            this.theseValues = theseValues;
        }

        public boolean isEqual(@NonNull IdResolver idResolver, @NonNull Object @NonNull [] thoseValues) {
            int iMax = thoseValues.length;
            if (iMax != this.theseValues.size()) {
                return false;
            }
            int i = 0;
            while (i < iMax) {
                if (!ClassUtil.safeEquals((Object)this.theseValues.get(i), (Object)thoseValues[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static enum Mode {
        LAZY,
        INCREMENTAL,
        REPAIR;

    }
}

