/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.StatusNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class AssignmentPartition
extends AbstractPartition {
    public AssignmentPartition(@NonNull MappingPartitioner partitioner, @NonNull Edge realizedEdge) {
        super(partitioner);
        Node targetNode;
        for (Node traceNode : partitioner.getTraceNodes()) {
            this.addNode(traceNode, Role.PREDICATED);
            Node statusNode = partitioner.getStatusNode(traceNode);
            if (statusNode == null) continue;
            this.addNode(statusNode, Role.PREDICATED);
        }
        Node sourceNode = realizedEdge.getEdgeSource();
        if (!this.hasNode(sourceNode)) {
            Role sourceNodeRole = QVTscheduleUtil.getNodeRole((Node)sourceNode);
            if (sourceNodeRole == Role.REALIZED) {
                sourceNodeRole = QVTscheduleUtil.asPredicated((Role)sourceNodeRole);
            }
            this.addNode(sourceNode, sourceNodeRole);
        }
        if (!this.hasNode(targetNode = realizedEdge.getEdgeTarget())) {
            Role targetNodeRole = QVTscheduleUtil.getNodeRole((Node)targetNode);
            if (targetNodeRole == Role.REALIZED) {
                targetNodeRole = QVTscheduleUtil.asPredicated((Role)targetNodeRole);
            }
            this.addNode(targetNode, targetNodeRole);
        }
        this.resolvePrecedingNodes();
        this.resolveDisambiguations();
        this.resolveEdges();
    }

    @Override
    protected @NonNull PartitioningVisitor createPartitioningVisitor(@NonNull MicroMappingRegion partialRegion) {
        return new PartitioningVisitor(new RegionHelper<MicroMappingRegion>(this.scheduleManager, partialRegion), this){

            public @Nullable Element visitStatusNode(@NonNull StatusNode node) {
                Node partialNode = this.regionHelper.createTrueNode();
                this.addNode((Node)node, partialNode);
                return partialNode;
            }
        };
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) {
            AbstractPartition realizingPartition = this.partitioner.getRealizingPartition(edge);
            if (realizingPartition instanceof AssignmentPartition && !this.isCorrolary(QVTscheduleUtil.getTargetNode((Edge)edge))) {
                return null;
            }
            if (realizingPartition != null) {
                edgeRole = Role.PREDICATED;
            }
        }
        return edgeRole;
    }
}

