/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ParameterVariable;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.QVTrelationFactory;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomainAssignment;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.util.AbstractExtendingQVTrelationVisitor;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationHelper;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public abstract class AbstractQVTr2QVTr
extends QVTrelationHelper {
    protected final @NonNull AbstractCreateVisitor<@NonNull ?> createVisitor;
    protected final @NonNull AbstractUpdateVisitor<@NonNull ?> updateVisitor;
    private final @NonNull Map<@Nullable NamedElement, @NonNull Map<@NonNull Element, @NonNull List<@NonNull Element>>> scope2source2targets = new HashMap<NamedElement, Map<Element, List<Element>>>();
    private final @NonNull Stack<@NonNull NamedElement> scopeStack = new Stack();
    private final @NonNull Map<@NonNull Element, @NonNull Element> target2source = new HashMap<Element, Element>();
    private final @NonNull Map<@NonNull Element, @NonNull Element> debugCopy2source = new HashMap<Element, Element>();
    private @Nullable ASResource debugSource = null;
    private @Nullable ASResource debugTarget = null;

    protected AbstractQVTr2QVTr(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
        this.createVisitor = this.createCreateVisitor();
        this.updateVisitor = this.createUpdateVisitor();
    }

    public void addDebugCopies(@NonNull Map<EObject, EObject> copier) {
        for (EObject eSource : copier.keySet()) {
            EObject eTarget = copier.get(eSource);
            assert (eSource != null && eTarget != null);
            this.debugCopy2source.put((Element)eTarget, (Element)eSource);
        }
    }

    public void addTrace(@NonNull Element source, @NonNull Element target) {
        this.addTrace(source, target, false);
    }

    public void addTrace(@NonNull Element source, @NonNull Element target, boolean replaceTargets) {
        List<Element> targets;
        this.target2source.put(target, source);
        NamedElement scope = this.scopeStack.peek();
        Map<@NonNull Element, @NonNull List<@NonNull Element>> source2targets = this.scope2source2targets.get(scope);
        if (source2targets == null) {
            source2targets = new HashMap<Element, List<Element>>();
            this.scope2source2targets.put(scope, source2targets);
        }
        if ((targets = source2targets.get(source)) == null) {
            targets = new ArrayList<Element>();
            source2targets.put(source, targets);
        }
        if (replaceTargets) {
            targets.clear();
        }
        assert (!targets.contains(target));
        targets.add(target);
    }

    protected @Nullable Element basicEquivalentSource(@Nullable Element target) {
        if (target == null) {
            return null;
        }
        assert (target.eResource() != this.debugSource) : "source element used for basicEquivalentSource " + target;
        return this.target2source.get(target);
    }

    protected abstract @NonNull AbstractCreateVisitor<@NonNull ?> createCreateVisitor();

    protected @NonNull Import createImport(@NonNull Import iIn) {
        Import iOut = this.createImport(iIn.getName(), (Namespace)ClassUtil.nonNull((Object)iIn.getImportedNamespace()));
        this.addTrace((Element)iIn, (Element)iOut);
        return iOut;
    }

    protected @NonNull Package createPackage(@NonNull Package pIn) {
        Package pOut = this.createPackage((String)ClassUtil.nonNull((Object)pIn.getName()), pIn.getNsPrefix(), pIn.getURI());
        this.addTrace((Element)pIn, (Element)pOut);
        return pOut;
    }

    protected @NonNull DomainPattern createTracedDomainPattern(@NonNull Element source, @NonNull TemplateExp asTemplateExp) {
        DomainPattern asDomainPattern = this.createDomainPattern(asTemplateExp);
        this.addTrace(source, (Element)asDomainPattern);
        return asDomainPattern;
    }

    protected @NonNull Import createTracedImport(@NonNull Element source, @Nullable String name, @NonNull Namespace namespace) {
        Import asImport = this.createImport(name, namespace);
        this.addTrace(source, (Element)asImport);
        return asImport;
    }

    protected @NonNull ObjectTemplateExp createTracedObjectTemplateExp(@NonNull Element source, @NonNull TemplateVariable asTemplateVariable, @NonNull Class asClass, boolean isRequired) {
        ObjectTemplateExp asObjectTemplateExp = this.createObjectTemplateExp(asTemplateVariable, asClass, isRequired);
        this.addTrace(source, (Element)asObjectTemplateExp);
        return asObjectTemplateExp;
    }

    protected @NonNull OperationCallExp createTracedOperationCallExp(@NonNull Element source, @NonNull OCLExpression asSourceExpression, @NonNull String opName, OCLExpression ... asArguments) {
        OperationCallExp asOperationCallExp = this.createOperationCallExp(asSourceExpression, opName, asArguments);
        this.addTrace(source, (Element)asOperationCallExp);
        return asOperationCallExp;
    }

    protected @NonNull Pattern createTracedPattern(@NonNull Element source) {
        Pattern asPattern = this.createPattern();
        this.addTrace(source, (Element)asPattern);
        return asPattern;
    }

    protected @NonNull Predicate createTracedPredicate(@NonNull Element source, @NonNull OCLExpression asConditionExpression) {
        Predicate asPredicate = this.createPredicate(asConditionExpression);
        this.addTrace(source, (Element)asPredicate);
        return asPredicate;
    }

    protected @NonNull PropertyTemplateItem createTracedPropertyTemplateItem(@NonNull Element source, @NonNull Property asProperty, @NonNull OCLExpression asExpression) {
        PropertyTemplateItem asPropertyTemplateItem = this.createPropertyTemplateItem(asProperty, asExpression);
        this.addTrace(source, (Element)asPropertyTemplateItem);
        return asPropertyTemplateItem;
    }

    protected @NonNull RelationCallExp createTracedRelationCallExp(@NonNull Element source, @NonNull Relation asRelation, @NonNull List<? extends @NonNull OCLExpression> asArguments) {
        RelationCallExp asInvocation = this.createRelationCallExp(asRelation, asArguments);
        this.addTrace(source, (Element)asInvocation);
        return asInvocation;
    }

    protected @NonNull RelationDomain createTracedRelationDomain(@NonNull Element source, @NonNull TypedModel asTypedModel) {
        RelationDomain asRelationDomain = this.createRelationDomain(asTypedModel);
        this.addTrace(source, (Element)asRelationDomain);
        return asRelationDomain;
    }

    protected @NonNull TemplateVariable createTracedTemplateVariable(@NonNull Element source, @NonNull String name, @NonNull Type asType, boolean isRequired, @Nullable OCLExpression asInitExpression) {
        TemplateVariable asTemplateVariable = this.createTemplateVariable(name, asType, isRequired, asInitExpression);
        this.addTrace(source, (Element)asTemplateVariable);
        return asTemplateVariable;
    }

    protected @NonNull TypedModel createTracedTypedModel(@NonNull Element source, @NonNull String name, @NonNull Iterable<@NonNull Package> usedPackages) {
        TypedModel asTypedModel = this.createTypedModel(name, usedPackages);
        this.addTrace(source, (Element)asTypedModel);
        return asTypedModel;
    }

    protected @NonNull VariableExp createTracedVariableExp(@NonNull Element source, @NonNull VariableDeclaration asVariable) {
        VariableExp asVariableExp = this.createVariableExp(asVariable);
        this.addTrace(source, (Element)asVariableExp);
        return asVariableExp;
    }

    protected abstract @NonNull AbstractUpdateVisitor<@NonNull ?> createUpdateVisitor();

    protected <T extends Element> @NonNull T equivalentSource(@NonNull T target) {
        assert (target.eResource() != this.debugSource) : "source element used for equivalentSource " + target;
        Element source = this.target2source.get(target);
        assert (source != null);
        return (T)source;
    }

    protected <T extends Element> @NonNull T equivalentTarget(T source) {
        assert (source != null);
        assert (source.eResource() != this.debugTarget) : "target element used for equivalentTarget " + source;
        List<@NonNull Element> targets = null;
        int i = this.scopeStack.size();
        while (targets == null && --i >= 0) {
            NamedElement scope = (NamedElement)this.scopeStack.get(i);
            Map<@NonNull Element, @NonNull List<@NonNull Element>> source2targets = this.scope2source2targets.get(scope);
            if (source2targets == null) continue;
            targets = source2targets.get(source);
        }
        if (targets != null) {
            Element target = (Element)targets.get(0);
            assert (target != null);
            return (T)target;
        }
        return source;
    }

    public void popScope() {
        this.scopeStack.pop();
    }

    public void pushScope(@NonNull NamedElement scope) {
        assert (!this.scopeStack.contains(scope));
        this.scopeStack.push(scope);
    }

    public void transform(@NonNull ASResource source, @NonNull ASResource target) throws IOException {
        this.debugSource = source;
        this.debugTarget = target;
        for (EObject eContent : source.getContents()) {
            if (!(eContent instanceof RelationModel)) continue;
            RelationModel mIn = (RelationModel)eContent;
            this.transform(mIn, (List<EObject>)target.getContents());
        }
        TreeIterator tit = target.getAllContents();
        while (tit.hasNext()) {
            EObject eTarget = (EObject)tit.next();
            EObject eSource = (EObject)this.target2source.get(eTarget);
            EObject eCopied = (EObject)this.debugCopy2source.get(eTarget);
            if (eSource != null || eCopied != null) continue;
            System.err.println("No source for " + eTarget.eClass().getName() + "@" + Integer.toString(System.identityHashCode(eTarget)) + ":" + eTarget + " / " + eTarget.eContainer().eClass().getName() + "@" + Integer.toString(System.identityHashCode(eTarget.eContainer())));
        }
    }

    protected void transform(@NonNull RelationModel mIn, @NonNull List<@NonNull EObject> mOuts) throws IOException {
        try {
            RelationModel mOut = (RelationModel)mIn.accept(this.createVisitor);
            assert (mOut != null);
            mOuts.add((EObject)mOut);
            mOut.accept(this.updateVisitor);
        }
        catch (WrappedException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw e;
        }
    }

    protected static abstract class AbstractCreateVisitor<@NonNull C extends AbstractQVTr2QVTr>
    extends AbstractExtendingQVTrelationVisitor<Element, C> {
        public AbstractCreateVisitor(@NonNull C context) {
            super(context);
        }

        public <T extends Element> @Nullable T create(@Nullable T source) {
            if (source == null) {
                return null;
            }
            @Nullable Element target = (Element)source.accept((Visitor)this);
            return (T)target;
        }

        public <T extends Element> void createAll(Iterable<T> sources, List<? super T> targets) {
            for (Element source : sources) {
                Element target = (Element)source.accept((Visitor)this);
                if (target == null) continue;
                targets.add(target);
            }
        }

        public @Nullable Element visiting(@NonNull Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + ((Object)((Object)this)).getClass().getSimpleName());
        }

        public @Nullable Element visitComment(@NonNull Comment cIn) {
            Comment cOut = PivotFactory.eINSTANCE.createComment();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)cIn, (Element)cOut);
            cOut.setBody(cIn.getBody());
            this.createAll(cIn.getOwnedComments(), cOut.getOwnedComments());
            return cOut;
        }

        public @NonNull DomainPattern visitDomainPattern(@NonNull DomainPattern pIn) {
            DomainPattern pOut = QVTrelationFactory.eINSTANCE.createDomainPattern();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)pIn, (Element)pOut);
            this.createAll((Iterable)pIn.getPredicate(), (List)pOut.getPredicate());
            this.createAll(pIn.getOwnedComments(), pOut.getOwnedComments());
            return pOut;
        }

        public @NonNull Function visitFunction(@NonNull Function fIn) {
            Function fOut = QVTbaseFactory.eINSTANCE.createFunction();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)fIn, (Element)fOut);
            ((AbstractQVTr2QVTr)((Object)this.context)).pushScope((NamedElement)fOut);
            fOut.setName(fIn.getName());
            fOut.setIsRequired(fIn.isIsRequired());
            fOut.setIsStatic(fIn.isIsStatic());
            fOut.setIsTransient(fIn.isIsTransient());
            fOut.setIsTypeof(fIn.isIsTypeof());
            fOut.setImplementationClass(fIn.getImplementationClass());
            this.createAll(fIn.getOwnedParameters(), fOut.getOwnedParameters());
            this.createAll(fIn.getOwnedComments(), fOut.getOwnedComments());
            ((AbstractQVTr2QVTr)((Object)this.context)).popScope();
            return fOut;
        }

        public @NonNull FunctionParameter visitFunctionParameter(@NonNull FunctionParameter fpIn) {
            FunctionParameter fpOut = QVTbaseFactory.eINSTANCE.createFunctionParameter();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)fpIn, (Element)fpOut);
            fpOut.setName(fpIn.getName());
            fpOut.setIsRequired(fpIn.isIsRequired());
            fpOut.setIsTypeof(fpIn.isIsTypeof());
            this.createAll(fpIn.getOwnedComments(), fpOut.getOwnedComments());
            return fpOut;
        }

        public @Nullable Element visitImport(@NonNull Import iIn) {
            Import iOut = ((AbstractQVTr2QVTr)((Object)this.context)).createImport(iIn);
            this.createAll(iIn.getOwnedComments(), iOut.getOwnedComments());
            return iOut;
        }

        public Element visitKey(@NonNull Key kIn) {
            Key kOut = QVTrelationFactory.eINSTANCE.createKey();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)kIn, (Element)kOut);
            this.createAll(kIn.getOwnedComments(), kOut.getOwnedComments());
            return kOut;
        }

        public @Nullable Element visitPackage(@NonNull Package pIn) {
            if ("http://www.eclipse.org/ocl/2015/Orphanage".equals(pIn.getURI())) {
                return null;
            }
            Package pOut = ((AbstractQVTr2QVTr)((Object)this.context)).createPackage(pIn);
            this.createAll(pIn.getOwnedClasses(), pOut.getOwnedClasses());
            this.createAll(pIn.getOwnedPackages(), pOut.getOwnedPackages());
            this.createAll(pIn.getOwnedComments(), pOut.getOwnedComments());
            return pOut;
        }

        public @NonNull ParameterVariable visitParameterVariable(@NonNull ParameterVariable vIn) {
            ParameterVariable vOut = PivotFactory.eINSTANCE.createParameterVariable();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)vIn, (Element)vOut);
            vOut.setName(vIn.getName());
            this.createAll(vIn.getOwnedComments(), vOut.getOwnedComments());
            return vOut;
        }

        public @NonNull Pattern visitPattern(@NonNull Pattern pIn) {
            Pattern pOut = QVTbaseFactory.eINSTANCE.createPattern();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)pIn, (Element)pOut);
            this.createAll((Iterable)pIn.getPredicate(), (List)pOut.getPredicate());
            this.createAll(pIn.getOwnedComments(), pOut.getOwnedComments());
            return pOut;
        }

        public @Nullable Element visitPredicate(@NonNull Predicate pIn) {
            Predicate pOut = QVTbaseFactory.eINSTANCE.createPredicate();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)pIn, (Element)pOut);
            this.createAll(pIn.getOwnedComments(), pOut.getOwnedComments());
            return pOut;
        }

        public @NonNull Relation visitRelation(@NonNull Relation rIn) {
            Relation rOut = QVTrelationFactory.eINSTANCE.createRelation();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)rIn, (Element)rOut);
            ((AbstractQVTr2QVTr)((Object)this.context)).pushScope((NamedElement)rOut);
            rOut.setName(rIn.getName());
            rOut.setIsAbstract(rIn.isIsAbstract());
            rOut.setIsTopLevel(rIn.isIsTopLevel());
            this.createAll((Iterable)rIn.getVariable(), (List)rOut.getVariable());
            this.createAll((Iterable)rIn.getDomain(), (List)rOut.getDomain());
            rOut.setWhen(this.create(rIn.getWhen()));
            rOut.setWhere(this.create(rIn.getWhere()));
            this.createAll(rIn.getOwnedComments(), rOut.getOwnedComments());
            ((AbstractQVTr2QVTr)((Object)this.context)).popScope();
            return rOut;
        }

        public @NonNull RelationDomain visitRelationDomain(@NonNull RelationDomain dIn) {
            RelationDomain dOut = QVTrelationFactory.eINSTANCE.createRelationDomain();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)dIn, (Element)dOut);
            dOut.setIsCheckable(dIn.isIsCheckable());
            dOut.setIsEnforceable(dIn.isIsEnforceable());
            this.createAll((Iterable)dIn.getPattern(), (List)dOut.getPattern());
            this.createAll((Iterable)dIn.getDefaultAssignment(), (List)dOut.getDefaultAssignment());
            this.createAll(dIn.getOwnedComments(), dOut.getOwnedComments());
            return dOut;
        }

        public Element visitRelationDomainAssignment(@NonNull RelationDomainAssignment aIn) {
            RelationDomainAssignment aOut = QVTrelationFactory.eINSTANCE.createRelationDomainAssignment();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)aIn, (Element)aOut);
            return aOut;
        }

        public @NonNull RelationModel visitRelationModel(@NonNull RelationModel mIn) {
            RelationModel mOut = QVTrelationFactory.eINSTANCE.createRelationModel();
            ((AbstractQVTr2QVTr)((Object)this.context)).pushScope((NamedElement)mOut);
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)mIn, (Element)mOut);
            this.createAll(mIn.getOwnedImports(), mOut.getOwnedImports());
            this.createAll(mIn.getOwnedPackages(), mOut.getOwnedPackages());
            this.createAll(mIn.getOwnedComments(), mOut.getOwnedComments());
            ((AbstractQVTr2QVTr)((Object)this.context)).popScope();
            return mOut;
        }

        public @NonNull RelationalTransformation visitRelationalTransformation(@NonNull RelationalTransformation tIn) {
            RelationalTransformation tOut = QVTrelationFactory.eINSTANCE.createRelationalTransformation();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)tIn, (Element)tOut);
            tOut.setName(tIn.getName());
            tOut.setOwnedContext(this.create(tIn.getOwnedContext()));
            this.createAll((Iterable)tIn.getOwnedKey(), (List)tOut.getOwnedKey());
            this.createAll(tIn.getOwnedOperations(), tOut.getOwnedOperations());
            this.createAll((Iterable)tIn.getModelParameter(), (List)tOut.getModelParameter());
            this.createAll((Iterable)tIn.getRule(), (List)tOut.getRule());
            this.createAll(tIn.getOwnedComments(), tOut.getOwnedComments());
            return tOut;
        }

        public @NonNull SharedVariable visitSharedVariable(@NonNull SharedVariable vIn) {
            SharedVariable vOut = QVTrelationFactory.eINSTANCE.createSharedVariable();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)vIn, (Element)vOut);
            vOut.setName(vIn.getName());
            this.createAll(vIn.getOwnedComments(), vOut.getOwnedComments());
            return vOut;
        }

        public @NonNull TemplateVariable visitTemplateVariable(@NonNull TemplateVariable vIn) {
            TemplateVariable vOut = QVTrelationFactory.eINSTANCE.createTemplateVariable();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)vIn, (Element)vOut);
            vOut.setName(vIn.getName());
            this.createAll(vIn.getOwnedComments(), vOut.getOwnedComments());
            return vOut;
        }

        public @NonNull TypedModel visitTypedModel(@NonNull TypedModel tmIn) {
            TypedModel tmOut = QVTbaseFactory.eINSTANCE.createTypedModel();
            ((AbstractQVTr2QVTr)((Object)this.context)).addTrace((Element)tmIn, (Element)tmOut);
            String name = tmIn.getName();
            tmOut.setName(name);
            tmOut.getUsedPackage().addAll((Collection)tmIn.getUsedPackage());
            tmOut.setIsPrimitive(tmIn.isIsPrimitive());
            tmOut.setIsTrace(tmIn.isIsTrace());
            this.createAll(tmIn.getOwnedComments(), tmOut.getOwnedComments());
            return tmOut;
        }
    }

    protected static abstract class AbstractUpdateVisitor<@NonNull C extends AbstractQVTr2QVTr>
    extends AbstractExtendingQVTrelationVisitor<Object, C> {
        public AbstractUpdateVisitor(@NonNull C context) {
            super(context);
        }

        protected void checkOut(@NonNull Element pOut) {
            Resource eResource = pOut.eResource();
            assert (eResource != null);
            TreeIterator tit = pOut.eAllContents();
            while (tit.hasNext()) {
                VariableDeclaration variable;
                Resource vResource;
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof VariableExp) || (vResource = (variable = ((VariableExp)eObject).getReferredVariable()).eResource()) == eResource) continue;
                System.err.println(variable + " : " + NameUtil.debugFullName((Object)variable) + " not in output resource.");
                vResource = variable.eResource();
            }
        }

        protected <T extends Element> @Nullable T copy(@Nullable T eIn) {
            if (eIn == null) {
                return null;
            }
            assert (this.context != null);
            ExpressionCopier copier = new ExpressionCopier((AbstractQVTr2QVTr)((Object)this.context));
            Element eOut = (Element)copier.copy((EObject)eIn);
            copier.copyReferences();
            ((AbstractQVTr2QVTr)((Object)this.context)).addDebugCopies((Map<EObject, EObject>)((Object)copier));
            return (T)eOut;
        }

        protected <T extends Element> void copyAll(List<T> sources, List<T> targets) {
            for (Element source : sources) {
                @Nullable Element target = this.copy(source);
                assert (target != null);
                targets.add(target);
            }
        }

        public @Nullable OCLExpression createCastCopy(@Nullable OCLExpression eIn, @Nullable Type toType) {
            StandardLibrary standardLibrary;
            if (eIn == null || toType == null) {
                return null;
            }
            OCLExpression eOut = this.copy(eIn);
            if (eOut == null) {
                return null;
            }
            Type eType = eOut.getType();
            if (eType.conformsTo(standardLibrary = ((AbstractQVTr2QVTr)((Object)this.context)).getEnvironmentFactory().getStandardLibrary(), toType)) {
                return eOut;
            }
            assert (toType.conformsTo(standardLibrary, eType));
            return ((AbstractQVTr2QVTr)((Object)this.context)).createOperationCallExp(eOut, "oclAsType", new OCLExpression[]{((AbstractQVTr2QVTr)((Object)this.context)).createTypeExp(toType)});
        }

        protected void doOverrides(@NonNull Relation rIn, @NonNull Relation rOut) {
            this.updateAllReferences((List)rIn.getOverrides(), (List)rOut.getOverrides());
        }

        protected <T extends Element> void updateAllChildren(List<T> targets) {
            for (Element target : targets) {
                target.accept((Visitor)this);
            }
        }

        protected <T extends Element> void updateAllReferences(List<T> sources, List<T> targets) {
            for (Element source : sources) {
                targets.add(((AbstractQVTr2QVTr)((Object)this.context)).equivalentTarget(source));
            }
        }

        protected void updateChild(@Nullable Element target) {
            if (target != null) {
                target.accept((Visitor)this);
            }
        }

        public @Nullable Object visiting(@NonNull Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + ((Object)((Object)this)).getClass().getSimpleName());
        }

        public @Nullable Object visitDomainPattern(@NonNull DomainPattern pOut) {
            DomainPattern pIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(pOut);
            pOut.setTemplateExpression(this.copy(pIn.getTemplateExpression()));
            this.updateAllChildren((List)pOut.getPredicate());
            this.updateAllReferences((List)pIn.getBindsTo(), (List)pOut.getBindsTo());
            return null;
        }

        public @Nullable Element visitFunction(@NonNull Function fOut) {
            ((AbstractQVTr2QVTr)((Object)this.context)).pushScope((NamedElement)fOut);
            Function fIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(fOut);
            fOut.setQueryExpression(this.copy(fIn.getQueryExpression()));
            fOut.setType(fIn.getType());
            this.updateAllChildren(fOut.getOwnedParameters());
            ((AbstractQVTr2QVTr)((Object)this.context)).popScope();
            return null;
        }

        public @Nullable Object visitFunctionParameter(@NonNull FunctionParameter fpOut) {
            FunctionParameter fpIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(fpOut);
            fpOut.setType(fpIn.getType());
            fpOut.setTypeValue(fpIn.getTypeValue());
            return null;
        }

        public @Nullable Object visitKey(@NonNull Key kOut) {
            Key kIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(kOut);
            kOut.setIdentifies(((AbstractQVTr2QVTr)((Object)this.context)).equivalentTarget(kIn.getIdentifies()));
            this.updateAllReferences((List)kIn.getPart(), (List)kOut.getPart());
            this.updateAllReferences((List)kIn.getOppositePart(), (List)kOut.getOppositePart());
            return null;
        }

        public @Nullable Object visitPackage(@NonNull Package pOut) {
            this.updateAllChildren(pOut.getOwnedClasses());
            this.updateAllChildren(pOut.getOwnedPackages());
            return null;
        }

        public @Nullable Object visitParameter(@NonNull Parameter pOut) {
            Parameter pIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(pOut);
            pOut.setName(pIn.getName());
            pOut.setIsRequired(pIn.isIsRequired());
            Type tVar = pIn.getType();
            pOut.setType(tVar);
            pOut.setTypeValue(pIn.getTypeValue());
            return pIn;
        }

        public @Nullable Object visitPattern(@NonNull Pattern pOut) {
            Pattern pIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(pOut);
            this.updateAllChildren((List)pOut.getPredicate());
            this.updateAllReferences((List)pIn.getBindsTo(), (List)pOut.getBindsTo());
            return null;
        }

        public @Nullable Object visitPredicate(@NonNull Predicate pOut) {
            Predicate pIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(pOut);
            pOut.setConditionExpression(this.copy(pIn.getConditionExpression()));
            this.checkOut((Element)pOut);
            return null;
        }

        public @NonNull Relation visitRelation(@NonNull Relation rOut) {
            ((AbstractQVTr2QVTr)((Object)this.context)).pushScope((NamedElement)rOut);
            Relation rIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(rOut);
            this.updateAllChildren((List)rOut.getVariable());
            this.updateAllChildren((List)rOut.getDomain());
            this.updateChild((Element)rOut.getWhen());
            this.updateChild((Element)rOut.getWhere());
            this.doOverrides(rIn, rOut);
            ((AbstractQVTr2QVTr)((Object)this.context)).popScope();
            return rIn;
        }

        public @Nullable Object visitRelationDomain(@NonNull RelationDomain dOut) {
            RelationDomain dIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(dOut);
            TypedModel tmOut = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentTarget(QVTrelationUtil.getTypedModel((Domain)dIn));
            dOut.setTypedModel(tmOut);
            this.updateAllChildren((List)dOut.getPattern());
            this.updateAllReferences((List)dIn.getRootVariable(), (List)dOut.getRootVariable());
            this.updateAllChildren((List)dOut.getDefaultAssignment());
            return null;
        }

        public Element visitRelationDomainAssignment(@NonNull RelationDomainAssignment aOut) {
            RelationDomainAssignment aIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(aOut);
            aOut.setVariable(((AbstractQVTr2QVTr)((Object)this.context)).equivalentTarget(aIn.getVariable()));
            aOut.setValueExp(this.copy(aIn.getValueExp()));
            return null;
        }

        public @NonNull RelationModel visitRelationModel(@NonNull RelationModel mOut) {
            RelationModel mIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(mOut);
            ((AbstractQVTr2QVTr)((Object)this.context)).pushScope((NamedElement)mOut);
            this.updateAllChildren(mOut.getOwnedPackages());
            ((AbstractQVTr2QVTr)((Object)this.context)).popScope();
            return mIn;
        }

        public @NonNull RelationalTransformation visitRelationalTransformation(@NonNull RelationalTransformation tOut) {
            RelationalTransformation tIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(tOut);
            this.updateChild((Element)tOut.getOwnedContext());
            this.updateAllChildren((List)tOut.getOwnedKey());
            this.updateAllChildren(tOut.getOwnedOperations());
            this.updateAllChildren((List)tOut.getModelParameter());
            this.updateAllChildren((List)tOut.getRule());
            this.updateAllReferences(tIn.getSuperClasses(), tOut.getSuperClasses());
            return tIn;
        }

        public @Nullable Object visitTypedModel(@NonNull TypedModel tmOut) {
            TypedModel tmIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(tmOut);
            this.updateAllReferences((List)tmIn.getDependsOn(), (List)tmOut.getDependsOn());
            return null;
        }

        public @Nullable Object visitVariable(@NonNull Variable vOut) {
            Variable vIn = ((AbstractQVTr2QVTr)((Object)this.context)).equivalentSource(vOut);
            vOut.setName(vIn.getName());
            vOut.setIsImplicit(vIn.isIsImplicit());
            vOut.setIsRequired(vIn.isIsRequired());
            Type tIn = vIn.getType();
            Type tVar = tIn != null ? ((AbstractQVTr2QVTr)((Object)this.context)).equivalentTarget(tIn) : null;
            vOut.setType(tVar);
            Type tvIn = vIn.getTypeValue();
            vOut.setTypeValue(tvIn != null ? ((AbstractQVTr2QVTr)((Object)this.context)).equivalentTarget(tvIn) : null);
            vOut.setOwnedInit(this.createCastCopy(vIn.getOwnedInit(), tVar));
            return vIn;
        }
    }

    protected static class ExpressionCopier
    extends EcoreUtil.Copier {
        private final @NonNull AbstractQVTr2QVTr context;

        public ExpressionCopier(@NonNull AbstractQVTr2QVTr context) {
            this.context = context;
        }

        public EObject get(Object oIn) {
            EObject eOut = (EObject)super.get(oIn);
            if (eOut == null) {
                eOut = this.context.equivalentTarget((Element)oIn);
            }
            return eOut;
        }
    }
}

