/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.debugger;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.m2m.internal.qvt.oml.common.util.StringLineNumberProvider;

class MarkedTransformation {
    private final HashMap<Object, LineMarker> myLineRecs = new LinkedHashMap<Object, LineMarker>();
    private final String myCleanText;
    private static final String LINE_MARKER_PREFIX = "--!@#";
    private static final String BREAKPOINT = "breakpoint";
    private static final String BREAKPOINT_FAIL = "fail";
    private static final String MARKER_NAME_START_MESSAGE = "A line marker name cannot start with a digit: line {0}:{1}";
    private static final String NO_NAME_FOUND_MESSAGE = "No name found. Line marker ignored: line {0}:{1}";
    private static final String DUPLICATE_MARKER_NAME_MESSAGE = "Duplicate marker name \"{0}\": line {1}:{2}";

    public MarkedTransformation(String markedData) {
        this.myCleanText = this.parseAndFilterMarkedFile(markedData);
    }

    public String parseAndFilterMarkedFile(String markedData) {
        String cleanData = "";
        StringLineNumberProvider lnp = new StringLineNumberProvider(markedData);
        String[] lines = new String[lnp.getLineCount()];
        int prevEnd = 0;
        int i = 0;
        while (i < lnp.getLineCount()) {
            lines[i] = markedData.substring(prevEnd, lnp.getLineEnd(i + 1) + 1);
            prevEnd = lnp.getLineEnd(i + 1) + 1;
            ++i;
        }
        int lineCounter = 0;
        int absoluteLine = 0;
        while (absoluteLine < lines.length) {
            String line = lines[absoluteLine];
            ++lineCounter;
            boolean actualFlag = true;
            if (line.startsWith(LINE_MARKER_PREFIX)) {
                int nameLen = 0;
                boolean breakpoint = false;
                boolean fail = false;
                int failOfs = 0;
                int bpOfs = 0;
                int state = 0;
                int i2 = LINE_MARKER_PREFIX.length();
                while (i2 < line.length() && state != -1) {
                    switch (state) {
                        case 0: {
                            if (Character.isWhitespace(line.charAt(i2))) {
                                if (nameLen == 0) {
                                    state = -1;
                                    break;
                                }
                                state = 1;
                                break;
                            }
                            if (Character.isDigit(line.charAt(i2)) && nameLen == 0) {
                                System.err.println(MessageFormat.format(MARKER_NAME_START_MESSAGE, new Integer(absoluteLine), line.trim()));
                                state = -1;
                                break;
                            }
                            ++nameLen;
                            break;
                        }
                        case 1: {
                            if (Character.isWhitespace(line.charAt(i2))) {
                                if (bpOfs <= 0) break;
                                breakpoint = bpOfs == BREAKPOINT.length();
                                state = breakpoint ? 2 : -1;
                                break;
                            }
                            if (line.charAt(i2) == BREAKPOINT.charAt(bpOfs)) {
                                ++bpOfs;
                                break;
                            }
                            state = -1;
                            break;
                        }
                        case 2: {
                            if (Character.isWhitespace(line.charAt(i2))) {
                                if (failOfs <= 0) break;
                                fail = failOfs == BREAKPOINT_FAIL.length();
                                state = -1;
                                break;
                            }
                            if (line.charAt(i2) == BREAKPOINT_FAIL.charAt(failOfs)) {
                                ++failOfs;
                                break;
                            }
                            state = -1;
                            break;
                        }
                    }
                    ++i2;
                }
                if (nameLen == 0) {
                    System.err.println(MessageFormat.format(NO_NAME_FOUND_MESSAGE, new Integer(absoluteLine), line.trim()));
                } else {
                    String name = line.substring(LINE_MARKER_PREFIX.length(), LINE_MARKER_PREFIX.length() + nameLen);
                    if (this.myLineRecs.containsKey(name)) {
                        throw new RuntimeException(MessageFormat.format(DUPLICATE_MARKER_NAME_MESSAGE, name, new Integer(absoluteLine), line.trim()));
                    }
                    LineMarker marker = new LineMarker(lineCounter, absoluteLine, name, breakpoint, fail);
                    this.myLineRecs.put(name, marker);
                    this.myLineRecs.put(new Integer(lineCounter), marker);
                    actualFlag = false;
                    --lineCounter;
                }
            }
            if (actualFlag) {
                cleanData = cleanData.concat(line);
            }
            ++absoluteLine;
        }
        return cleanData;
    }

    public LineMarker getLineMarker(String name) {
        return this.myLineRecs.get(name);
    }

    public LineMarker getLineMarker(int lineNumber) {
        return this.myLineRecs.get(new Integer(lineNumber));
    }

    public String getCleanText() {
        return this.myCleanText;
    }

    public Collection<LineMarker> getBreakpointLineMarkers() {
        LinkedHashSet<LineMarker> result = new LinkedHashSet<LineMarker>();
        for (LineMarker rec : this.myLineRecs.values()) {
            if (!rec.breakpoint) continue;
            result.add(rec);
        }
        return result;
    }

    public class LineMarker {
        public final int lineNumber;
        public final int absoluteLine;
        public final String name;
        public final boolean breakpoint;
        public final boolean fail;

        public LineMarker(int lineNumber, int absoluteLine, String name, boolean breakpoint, boolean fail) {
            this.name = name;
            this.lineNumber = lineNumber;
            this.absoluteLine = absoluteLine;
            this.breakpoint = breakpoint;
            this.fail = fail;
        }

        public String toString() {
            return MessageFormat.format("line {4}({0}): \"{1} {2} {3}\"", new Integer(this.lineNumber), this.name, this.breakpoint ? MarkedTransformation.BREAKPOINT : "", this.fail ? MarkedTransformation.BREAKPOINT_FAIL : "", new Integer(this.absoluteLine));
        }
    }
}

