/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.completion;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.m2m.internal.tests.qvt.oml.ui.completion.CompletionTest;
import org.eclipse.m2m.internal.tests.qvt.oml.ui.completion.DetachedCompletionTest;
import org.eclipse.m2m.tests.qvt.oml.util.TestUtil;

public class CompletionTests {
    private static final Set<String> ourDetachedTests = new HashSet<String>(Arrays.asList("bugzilla1978", "mixedImportItems"));

    public static Test suite() {
        TestSuite suite = new TestSuite("QVT Operational code completion");
        try {
            TestSuite generalSuite = new TestSuite("general");
            TestSuite detachedSuite = new TestSuite("detached");
            CompletionTests.loadTestCases(generalSuite, detachedSuite, TestUtil.getPluginRelativeFile((String)"org.eclipse.m2m.tests.qvt.oml.ui", (String)"completionTestData"));
            suite.addTest((Test)generalSuite);
            suite.addTest((Test)detachedSuite);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return suite;
    }

    private static void loadTestCases(TestSuite generalSuite, TestSuite detachedSuite, File folder) {
        File[] contents = folder.listFiles();
        int i = 0;
        while (i < contents.length) {
            if (CompletionTests.isCompletionTestFolder(contents[i])) {
                String testName = contents[i].getName();
                if (ourDetachedTests.contains(testName)) {
                    detachedSuite.addTest((Test)new DetachedCompletionTest(testName));
                } else {
                    generalSuite.addTest((Test)new CompletionTest(testName));
                }
            }
            ++i;
        }
    }

    private static boolean isCompletionTestFolder(File file) {
        if (file.isDirectory()) {
            List<String> list = Arrays.asList(file.list());
            return list.contains("t.aqvto");
        }
        return false;
    }
}

