/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers;

import java.util.Collections;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.ViewerFilteringAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.BasicSessionActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.FormHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.sections.ActivityExplorerSection;
import org.eclipse.amalgam.explorer.activity.ui.internal.Couple;
import org.eclipse.amalgam.explorer.activity.ui.internal.DelegatedViewerFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractActivityExplorerViewer
implements IPropertyListener {
    protected BasicSessionActivityExplorerPage page;
    protected TreeViewer viewer;
    private DelegatedViewerFilter viewerFilter;
    private ViewerFilteringAction sectionActionDrivingFilter;

    public AbstractActivityExplorerViewer(BasicSessionActivityExplorerPage page_p) {
        this.page = page_p;
        this.page.addPropertyListener(this);
    }

    protected abstract String getViewerSectionTitle();

    protected abstract Object getInput();

    protected abstract ILabelProvider getLabelProvider();

    protected abstract IContentProvider getContentProvider();

    public Action getResetSectionFilter() {
        Action resetSectionFilter = new Action(){

            public void run() {
                AbstractActivityExplorerViewer.this.viewerFilter.setDelegatedFilter(null);
                AbstractActivityExplorerViewer.this.uncheckSectionFilterAction();
                this.getViewer().refresh();
            }

            private StructuredViewer getViewer() {
                return AbstractActivityExplorerViewer.this.viewer;
            }
        };
        resetSectionFilter.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        resetSectionFilter.setToolTipText(Messages.BasicSessionActivityExplorerPage_2);
        return resetSectionFilter;
    }

    public void setViewerFilter(ViewerFilteringAction action_p) {
        ViewerFilter filter_p;
        ViewerFilter viewerFilter = filter_p = action_p != null ? this.getViewerFilter(action_p.getSection()) : null;
        if (filter_p == null) {
            this.getResetSectionFilter().run();
            return;
        }
        this.viewerFilter.setDelegatedFilter(filter_p);
        Control control = this.viewer.getControl();
        try {
            control.setRedraw(false);
            this.viewer.collapseAll();
            this.viewer.refresh();
            this.viewer.expandAll();
            this.uncheckSectionFilterAction();
            this.sectionActionDrivingFilter = action_p;
        }
        finally {
            control.setRedraw(true);
        }
    }

    protected ViewerFilter getViewerFilter(ActivityExplorerSection section) {
        return null;
    }

    public Couple<TreeViewer, Section> createViewer(Composite viewerContainer_p, IManagedForm managedForm_p) {
        Couple<Section, Composite> section = FormHelper.createSectionWithDescription(managedForm_p.getToolkit(), viewerContainer_p, this.getViewerSectionTitle(), null);
        FormHelper.createSectionToolbar(section.getKey(), Collections.singletonList(this.getResetSectionFilter()));
        section.getKey().setLayoutData((Object)new GridData(1808));
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filteredTree = new FilteredTree(section.getValue(), 2052, patternFilter, true);
        managedForm_p.getToolkit().adapt((Composite)filteredTree);
        TreeViewer treeViewer = filteredTree.getViewer();
        this.addListenersOnViewer(treeViewer);
        this.viewerFilter = new DelegatedViewerFilter();
        treeViewer.addFilter((ViewerFilter)this.viewerFilter);
        treeViewer.setContentProvider(this.getContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        treeViewer.setAutoExpandLevel(2);
        this.viewer = treeViewer;
        treeViewer.setInput(this.getInput());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                AbstractActivityExplorerViewer.this.page.getEditorSite().getSelectionProvider().setSelection(event_p.getSelection());
            }
        });
        this.initMenuToViewer(treeViewer);
        return new Couple<TreeViewer, Section>(treeViewer, section.getKey());
    }

    private void uncheckSectionFilterAction() {
        if (this.sectionActionDrivingFilter != null) {
            this.sectionActionDrivingFilter.setChecked(false);
            this.sectionActionDrivingFilter = null;
        }
    }

    protected abstract void addListenersOnViewer(TreeViewer var1);

    public void refresh() {
        if (this.page != null && this.page.isActive() && this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    public void dispose() {
        this.viewer.getControl().dispose();
    }

    protected MenuManager initMenuToViewer(TreeViewer treeViewer_p) {
        MenuManager contextMenuManager = new MenuManager("viewerPopup");
        Control control = treeViewer_p.getControl();
        this.declareViewerActions(contextMenuManager, treeViewer_p);
        Menu contextMenu = contextMenuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        this.page.getEditorSite().registerContextMenu(contextMenuManager, (ISelectionProvider)treeViewer_p);
        return contextMenuManager;
    }

    protected abstract void declareViewerActions(MenuManager var1, TreeViewer var2);

    public void propertyChanged(Object source, int propId) {
        if (389 == propId) {
            this.refresh();
        }
        if (257 == propId) {
            this.refresh();
        }
    }
}

