/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.CompareUIPapyrusMessages;

public class AddEquivalencesBetweenPapyrusRenames {
    private static final String UML_EXTENSION = ".uml";
    private final Comparison comparison;
    private final Monitor monitor;
    private final Multimap<String, ResourceLocationChange> changesByTrimmedURI = LinkedHashMultimap.create((int)10, (int)4);

    public AddEquivalencesBetweenPapyrusRenames(Comparison comparison, Monitor monitor) {
        this.comparison = (Comparison)Preconditions.checkNotNull((Object)comparison);
        this.monitor = (Monitor)Preconditions.checkNotNull((Object)monitor);
    }

    public void run() {
        this.monitor.subTask(CompareUIPapyrusMessages.getString("AddEquivalencesBetweenPapyrusRenames.TaskLabel"));
        this.indexLocationChanges();
        for (ResourceLocationChange resourceLocationChange : this.changesByTrimmedURI.values()) {
            String baseLocation = resourceLocationChange.getBaseLocation();
            if (!baseLocation.endsWith(UML_EXTENSION)) continue;
            this.addEquivalences(resourceLocationChange);
        }
    }

    private void indexLocationChanges() {
        for (MatchResource matchResource : this.comparison.getMatchedResources()) {
            for (ResourceLocationChange change : matchResource.getLocationChanges()) {
                this.changesByTrimmedURI.put((Object)this.getIndexKey(change), (Object)change);
            }
        }
    }

    private void addEquivalences(ResourceLocationChange umlLocationChange) {
        for (ResourceLocationChange relatedChange : this.changesByTrimmedURI.get((Object)this.getIndexKey(umlLocationChange))) {
            if (relatedChange == umlLocationChange || relatedChange.getSource() != umlLocationChange.getSource()) continue;
            umlLocationChange.getRequires().add((Object)relatedChange);
            relatedChange.getRequires().add((Object)umlLocationChange);
        }
    }

    private String getIndexKey(ResourceLocationChange change) {
        String uri = change.getBaseLocation();
        int dot = uri.lastIndexOf(".");
        if (dot >= 0) {
            return uri.substring(0, dot);
        }
        return uri;
    }
}

