/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.papyrus.internal;

import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.papyrus.internal.AbstractPapyrusDiagramDiffHandler;
import org.eclipse.emf.compare.diagram.papyrus.internal.DiffIndexer;
import org.eclipse.emf.compare.diagram.papyrus.internal.FeatureInstance;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class PapyrusDiagram2WayDiffHandler
extends AbstractPapyrusDiagramDiffHandler {
    private final DiffIndexer indexer;

    public PapyrusDiagram2WayDiffHandler(DiffIndexer indexer) {
        this.indexer = indexer;
    }

    public void handle(Diff diff) {
        ReferenceChange refChange;
        if (diff instanceof ReferenceChange && diff.getKind() == DifferenceKind.CHANGE && !this.isContainedInAddOrDelete(refChange = (ReferenceChange)diff)) {
            this.handleActualReferenceChange(refChange);
        }
    }

    private void handleActualReferenceChange(ReferenceChange refChange) {
        if (this.isConnectorReferenceChange(refChange)) {
            Match match = refChange.getMatch();
            Connector left = (Connector)match.getLeft();
            if (left == null) {
                return;
            }
            EObject leftElement = left.getElement();
            if (leftElement instanceof Association) {
                Association assoc = (Association)leftElement;
                for (Property memberEnd : assoc.getMemberEnds()) {
                    this.indexer.putEquivalentDiff(memberEnd, (Diff)refChange);
                }
            } else if (leftElement instanceof Transition) {
                if (refChange.getReference() == NotationPackage.Literals.EDGE__SOURCE) {
                    this.indexer.putEquivalentDiff(new FeatureInstance(leftElement, (EStructuralFeature)UMLPackage.Literals.TRANSITION__SOURCE), (Diff)refChange);
                } else if (refChange.getReference() == NotationPackage.Literals.EDGE__TARGET) {
                    this.indexer.putEquivalentDiff(new FeatureInstance(leftElement, (EStructuralFeature)UMLPackage.Literals.TRANSITION__TARGET), (Diff)refChange);
                }
            }
        } else if (this.isPropertyTypeChange(refChange)) {
            this.indexer.putEquivalentDiff(refChange.getMatch().getLeft(), (Diff)refChange);
        } else if (this.isTransitionReferenceChange(refChange)) {
            this.indexer.putEquivalentDiff(new FeatureInstance(refChange.getMatch().getLeft(), (EStructuralFeature)refChange.getReference()), (Diff)refChange);
        }
    }
}

