/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.CompareUIPapyrusMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddEquivalencesBetweenPapyrusResourceLocationChanges {
    private static final String UML_EXTENSION = ".uml";
    private static final String NOTATION_EXTENSION = ".notation";
    private static final String DI_EXTENSION = ".di";
    private final Comparison comparison;
    private final Monitor monitor;
    private final Multimap<String, ResourceAttachmentChange> moveChangesByTrimmedURI = LinkedHashMultimap.create((int)10, (int)4);
    private final Multimap<String, ResourceAttachmentChange> changesByTrimmedURI = LinkedHashMultimap.create((int)10, (int)4);

    public AddEquivalencesBetweenPapyrusResourceLocationChanges(Comparison comparison, Monitor monitor) {
        this.comparison = (Comparison)Preconditions.checkNotNull((Object)comparison);
        this.monitor = (Monitor)Preconditions.checkNotNull((Object)monitor);
    }

    public void run() {
        String resourceURI;
        this.monitor.subTask(CompareUIPapyrusMessages.getString("AddEquivalencesBetweenPapyrusRenames.TaskLabel"));
        this.indexAttachmentChanges();
        for (ResourceAttachmentChange resourceAttachmentChange : this.moveChangesByTrimmedURI.values()) {
            resourceURI = resourceAttachmentChange.getResourceURI();
            if (!resourceURI.endsWith(UML_EXTENSION)) continue;
            this.addEquivalences(resourceAttachmentChange, this.moveChangesByTrimmedURI);
        }
        for (ResourceAttachmentChange resourceAttachmentChange : this.changesByTrimmedURI.values()) {
            resourceURI = resourceAttachmentChange.getResourceURI();
            if (!resourceURI.endsWith(UML_EXTENSION)) continue;
            this.addEquivalences(resourceAttachmentChange, this.moveChangesByTrimmedURI);
            this.addEquivalences(resourceAttachmentChange, this.changesByTrimmedURI);
        }
    }

    private void indexAttachmentChanges() {
        Predicate<Diff> isKindNotNull = new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input != null;
            }
        };
        for (Diff change : Iterables.filter((Iterable)this.comparison.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)isKindNotNull))) {
            ResourceAttachmentChange attachmentChange = (ResourceAttachmentChange)change;
            switch (attachmentChange.getKind()) {
                case ADD: 
                case DELETE: {
                    this.changesByTrimmedURI.put((Object)this.getIndexKey(attachmentChange), (Object)attachmentChange);
                    break;
                }
                case MOVE: {
                    this.moveChangesByTrimmedURI.put((Object)this.getIndexKey(attachmentChange), (Object)attachmentChange);
                    break;
                }
            }
        }
    }

    private void addEquivalences(ResourceAttachmentChange umlAttachmentChange, Multimap<String, ResourceAttachmentChange> attachmentChangeByKey) {
        for (ResourceAttachmentChange relatedChange : attachmentChangeByKey.get((Object)this.getIndexKey(umlAttachmentChange))) {
            if (relatedChange == umlAttachmentChange || relatedChange.getSource() != umlAttachmentChange.getSource()) continue;
            umlAttachmentChange.getRequires().add((Object)relatedChange);
            relatedChange.getRequires().add((Object)umlAttachmentChange);
        }
    }

    private String getIndexKey(ResourceAttachmentChange change) {
        String uri = change.getResourceURI();
        int dot = uri.lastIndexOf(".");
        if (dot >= 0) {
            return uri.substring(0, dot);
        }
        return uri;
    }
}

