/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tooltip;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.provider.ITooltipLabelProvider;
import org.eclipse.emf.compare.tooltip.AbstractTooltipProvider;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeTooltipProvider
extends AbstractTooltipProvider<ReferenceChange>
implements ITooltipLabelProvider {
    public ReferenceChangeTooltipProvider(ComposedAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.labelProvider = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
    }

    @Override
    public String getTooltip(MergeMode mode) throws IllegalArgumentException {
        String tooltip;
        ReferenceChange diff = (ReferenceChange)this.target;
        boolean isFromLeft = this.isFromLeft(diff);
        boolean isContainment = diff.getReference().isContainment();
        switch (diff.getKind()) {
            case DELETE: {
                if (isContainment) {
                    tooltip = this.setDeleteContainmentTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setDeleteNonContainmentTooltip(mode, diff, isFromLeft);
                break;
            }
            case ADD: {
                if (isContainment) {
                    tooltip = this.setAddContainmentTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setAddNonContainmentTooltip(mode, diff, isFromLeft);
                break;
            }
            case MOVE: {
                if (isContainment) {
                    Match valueMatch = diff.getMatch().getComparison().getMatch(diff.getValue());
                    EObject left = valueMatch.getLeft();
                    EObject right = valueMatch.getRight();
                    EObject ancestor = valueMatch.getOrigin();
                    if (this.isContainerMove(isFromLeft, ancestor, right, left)) {
                        tooltip = this.setMoveContainerTooltip(mode, diff, isFromLeft, left, right, ancestor);
                        break;
                    }
                    tooltip = this.setMovePositionTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setMovePositionTooltip(mode, diff, isFromLeft);
                break;
            }
            case CHANGE: {
                if (this.isUnset(diff)) {
                    tooltip = this.setUnsetTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setSetTooltip(mode, diff, isFromLeft);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return tooltip;
    }

    private boolean isUnset(ReferenceChange diff) {
        boolean isUnset = false;
        Match match = diff.getMatch();
        EObject container = diff.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
        if (container == null) {
            isUnset = true;
        } else if (!ReferenceUtil.safeEIsSet((EObject)container, (EStructuralFeature)diff.getReference())) {
            isUnset = true;
        }
        return isUnset;
    }

    private boolean isContainerMove(boolean isFromLeft, EObject origin, EObject right, EObject left) {
        boolean isContainerMove = false;
        if (isFromLeft) {
            if (!(left == null || origin == null || this.getLabelFromObject(left.eContainer()).equals(this.getLabelFromObject(origin.eContainer())) && left.eContainingFeature() == origin.eContainingFeature())) {
                isContainerMove = true;
            }
        } else if (!(right == null || origin == null || this.getLabelFromObject(right.eContainer()).equals(this.getLabelFromObject(origin.eContainer())) && right.eContainingFeature() == origin.eContainingFeature())) {
            isContainerMove = true;
        }
        return isContainerMove;
    }

    private String setMoveContainerTooltip(MergeMode mode, ReferenceChange diff, boolean isFromLeft, EObject left, EObject right, EObject ancestor) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String leftContainerValue = "";
        if (left.eContainer() != null) {
            leftContainerValue = this.getLabelFromObject(left.eContainer());
        }
        String rightContainerValue = "";
        if (right.eContainer() != null) {
            rightContainerValue = this.getLabelFromObject(right.eContainer());
        }
        String ancestorContainerValue = diff.getMatch().getComparison().isThreeWay() && ancestor != null ? this.getLabelFromObject(ancestor.eContainer()) : rightContainerValue;
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.move.container.left.leftToRight", value, leftContainerValue, rightContainerValue) : EMFCompareEditMessages.getString("ContextualTooltip.move.container.right.leftToRight", value, leftContainerValue, rightContainerValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.move.container.left.rightToLeft", value, rightContainerValue, leftContainerValue) : EMFCompareEditMessages.getString("ContextualTooltip.move.container.right.rightToLeft", value, rightContainerValue, leftContainerValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.move.container.left.accept", value, leftContainerValue);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.move.container.right.accept", value, rightContainerValue, leftContainerValue);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.move.container.left.reject", value, ancestorContainerValue, leftContainerValue);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.move.container.right.reject", value, leftContainerValue);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    private String setDeleteContainmentTooltip(MergeMode mode, ReferenceChange diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String containerValue = this.getLabel((EObject)diff.getMatch());
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.left.leftToRight", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.right.leftToRight", value, containerValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.left.rightToLeft", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.right.rightToLeft", value, containerValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.left.accept", value, containerValue);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.right.accept", value, containerValue);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.left.reject", value, containerValue);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.containment.right.reject", value, containerValue);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    private String setAddContainmentTooltip(MergeMode mode, ReferenceChange diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String containerValue = this.getLabel((EObject)diff.getMatch());
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.add.containment.left.leftToRight", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.add.containment.right.leftToRight", value, containerValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.add.containment.left.rightToLeft", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.add.containment.right.rightToLeft", value, containerValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.add.containment.left.accept", value, containerValue);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.add.containment.right.accept", value, containerValue);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.add.containment.left.reject", value, containerValue);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.add.containment.right.reject", value, containerValue);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }
}

