/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DefaultImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyGraphUpdater;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyRemoteResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ModelResourceListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceDependencyProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceDependencyRemoteResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolutionContext
implements IResolutionContext {
    private final EventBus eventBus;
    private final IGraph<URI> graph;
    private final DependencyGraphUpdater<URI> graphUpdater;
    private final ResourceComputationScheduler<URI> scheduler;
    private final ModelResourceListener modelResourceListener;
    private IResourceDependencyProvider dependencyProvider;
    private IResourceDependencyLocalResolver localResolver;
    private IResourceDependencyRemoteResolver remoteResolver;
    private IImplicitDependencies implicitDependencies;

    public DefaultResolutionContext(EventBus eventBus, IGraph<URI> graph, DependencyGraphUpdater<URI> graphUpdater, ResourceComputationScheduler<URI> scheduler, ModelResourceListener modelResourceListener) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.graph = (IGraph)Preconditions.checkNotNull(graph);
        this.graphUpdater = (DependencyGraphUpdater)Preconditions.checkNotNull(graphUpdater);
        this.scheduler = (ResourceComputationScheduler)Preconditions.checkNotNull(scheduler);
        this.modelResourceListener = (ModelResourceListener)Preconditions.checkNotNull((Object)modelResourceListener);
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public IGraph<URI> getGraph() {
        return this.graph;
    }

    @Override
    public DependencyGraphUpdater<URI> getGraphUpdater() {
        return this.graphUpdater;
    }

    @Override
    public ResourceComputationScheduler<URI> getScheduler() {
        return this.scheduler;
    }

    @Override
    public ModelResourceListener getModelResourceListener() {
        return this.modelResourceListener;
    }

    @Override
    public synchronized IResourceDependencyProvider getDependencyProvider() {
        if (this.dependencyProvider == null) {
            this.dependencyProvider = new ResourceDependencyProvider(this);
        }
        return this.dependencyProvider;
    }

    @Override
    public synchronized IResourceDependencyLocalResolver getLocalResolver() {
        if (this.localResolver == null) {
            this.localResolver = new ResourceDependencyLocalResolver(this);
        }
        return this.localResolver;
    }

    @Override
    public synchronized IResourceDependencyRemoteResolver getRemoteResolver() {
        if (this.remoteResolver == null) {
            this.remoteResolver = new ResourceDependencyRemoteResolver(this);
        }
        return this.remoteResolver;
    }

    @Override
    public synchronized IImplicitDependencies getImplicitDependencies() {
        if (this.implicitDependencies == null) {
            this.implicitDependencies = new DefaultImplicitDependencies();
        }
        return this.implicitDependencies;
    }

    @Override
    public void initialize() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.modelResourceListener);
        this.eventBus.register(this.graphUpdater);
        this.scheduler.initialize();
    }

    @Override
    public void dispose() {
        this.scheduler.dispose();
        this.eventBus.unregister(this.graphUpdater);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.modelResourceListener);
    }
}

