/*******************************************************************************
 * Copyright (c) 2015 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.compare.diagram.papyrus.internal;

import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.ecore.EObject;

/**
 * Instance of a feature for an EObject, designed to be used as a key in a Map.
 * 
 * @author <a href="mailto:laurent.delaigue@obeo.fr">Laurent Delaigue</a>
 */
class SidedEObject {
	/** The EObject. */
	private final EObject eObject;

	/** The side. */
	private final DifferenceSource side;

	/**
	 * Constructor.
	 * 
	 * @param eObject
	 *            The EObject
	 * @param side
	 *            The side
	 */
	SidedEObject(EObject eObject, DifferenceSource side) {
		super();
		this.eObject = eObject;
		this.side = side;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		// CHECKSTYLE:OFF Code generated by JDT
		result = prime * result + ((eObject == null) ? 0 : eObject.hashCode());
		result = prime * result + ((side == null) ? 0 : side.hashCode());
		// CHECKSTYLE:ON
		return result;
	}

	// CHECKSTYLE:OFF Code generated by JDT
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		SidedEObject other = (SidedEObject)obj;
		if (eObject != other.eObject) {
			return false;
		}
		if (side != other.side) {
			return false;
		}
		return true;
		// CHECKSTYLE:ON
	}

	@Override
	public String toString() {
		if (eObject == null) {
			return "<null>-" + side; //$NON-NLS-1$
		}
		return eObject.eClass().getName() + '-' + side.getName();
	}
}
