/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.papyrus.internal;

import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.papyrus.internal.AbstractPapyrusDiagramDiffHandler;
import org.eclipse.emf.compare.diagram.papyrus.internal.DiffIndexer;
import org.eclipse.emf.compare.diagram.papyrus.internal.SidedEObject;
import org.eclipse.emf.compare.diagram.papyrus.internal.SidedFeatureInstance;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class PapyrusDiagram3WayDiffHandler
extends AbstractPapyrusDiagramDiffHandler {
    private final DiffIndexer indexer;

    public PapyrusDiagram3WayDiffHandler(DiffIndexer indexer) {
        this.indexer = indexer;
    }

    @Override
    public void handle(Diff diff) {
        ReferenceChange refChange;
        if (diff instanceof ReferenceChange && diff.getKind() == DifferenceKind.CHANGE && !this.isContainedInAddOrDelete(refChange = (ReferenceChange)diff)) {
            this.handleActualReferenceChange(refChange);
        }
    }

    private void handleActualReferenceChange(ReferenceChange refChange) {
        if (this.isConnectorReferenceChange(refChange)) {
            Connector connectorOnDiffSide = (Connector)this.getMatchObjectOnSameSideAs((Diff)refChange);
            if (connectorOnDiffSide == null) {
                return;
            }
            EObject element = connectorOnDiffSide.getElement();
            if (element instanceof Association) {
                Association assoc = (Association)element;
                for (Property memberEnd : assoc.getMemberEnds()) {
                    this.indexer.putEquivalentDiff(new SidedEObject((EObject)memberEnd, refChange.getSource()), (Diff)refChange);
                }
            } else if (element instanceof Transition) {
                if (refChange.getReference() == NotationPackage.Literals.EDGE__SOURCE) {
                    this.indexer.putEquivalentDiff(new SidedFeatureInstance(element, (EStructuralFeature)UMLPackage.Literals.TRANSITION__SOURCE, refChange.getSource()), (Diff)refChange);
                } else if (refChange.getReference() == NotationPackage.Literals.EDGE__TARGET) {
                    this.indexer.putEquivalentDiff(new SidedFeatureInstance(element, (EStructuralFeature)UMLPackage.Literals.TRANSITION__TARGET, refChange.getSource()), (Diff)refChange);
                }
            }
        } else if (this.isPropertyTypeChange(refChange)) {
            this.indexer.putEquivalentDiff(new SidedEObject(this.getMatchObjectOnSameSideAs((Diff)refChange), refChange.getSource()), (Diff)refChange);
        } else if (this.isTransitionReferenceChange(refChange)) {
            this.indexer.putEquivalentDiff(new SidedFeatureInstance(this.getMatchObjectOnSameSideAs((Diff)refChange), (EStructuralFeature)refChange.getReference(), refChange.getSource()), (Diff)refChange);
        }
    }

    protected EObject getMatchObjectOnSameSideAs(Diff diff) {
        Match match = diff.getMatch();
        switch (diff.getSource()) {
            case LEFT: {
                return match.getLeft();
            }
            case RIGHT: {
                return match.getRight();
            }
        }
        throw new IllegalStateException("The diff should be part of a 3-way comparison and have a non-null source.");
    }
}

