/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration;

import com.google.common.base.Function;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.uml2.papyrus.internal.UMLPapyrusCompareMessages;
import org.eclipse.emf.compare.uml2.papyrus.internal.UMLPapyrusComparePlugin;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.DelegatingInvocationHandler;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.MissingProfileSupplier;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.ModelSetWrapper;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.ProfileMigrationDiagnostic;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.UMLLabelProviderService;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.StereotypeApplicationRepairSnippet;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class StereotypeApplicationRepair
extends StereotypeApplicationRepairSnippet {
    private static final String FIELD_LABEL_PROVIDER_SERVICE = "labelProviderService";
    private static final String FIELD_ADAPTER = "adapter";
    private static final String FIELD_DYNAMIC_PROFILE_SUPPLIER = "dynamicProfileSupplier";
    private LabelProviderService fLabelProviderService;
    private Resource fResource;
    private Object fProfileSupplier;

    public StereotypeApplicationRepair(Resource resource) {
        this.fResource = resource;
        this.fLabelProviderService = this.setLabelProviderService(this.createLabelProviderService());
        this.fProfileSupplier = this.setProfileSupplier(this.createProfileSupplier());
    }

    public void dispose(ModelSet modelsManager) {
        try {
            LabelProviderService s = (LabelProviderService)this.getSuperField(FIELD_LABEL_PROVIDER_SERVICE);
            if (s != null) {
                s.disposeService();
            }
        }
        catch (ServiceException ex) {
            UMLPapyrusComparePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.uml2.papyrus", "Unable to dispose Label Provider Service", (Throwable)ex));
        }
        super.dispose(modelsManager);
    }

    protected <T> T setSuperField(String fieldName, T fieldValue) {
        try {
            Field superField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            superField.setAccessible(true);
            superField.set((Object)this, fieldValue);
            return fieldValue;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object getSuperField(String fieldName) {
        try {
            Field superField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            superField.setAccessible(true);
            return superField.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setAdapter(ModelSet resourceSet) {
        Object adapterObject = this.getSuperField(FIELD_ADAPTER);
        if (adapterObject instanceof Adapter.Internal) {
            ((Adapter.Internal)adapterObject).setTarget((Notifier)resourceSet);
        }
    }

    private LabelProviderService setLabelProviderService(LabelProviderService labelProviderService) {
        return this.setSuperField(FIELD_LABEL_PROVIDER_SERVICE, labelProviderService);
    }

    protected Object setProfileSupplier(Object profileSupplier) {
        return this.setSuperField(FIELD_DYNAMIC_PROFILE_SUPPLIER, profileSupplier);
    }

    protected LabelProviderService createLabelProviderService() {
        UMLLabelProviderService umlLabelProviderService = new UMLLabelProviderService();
        try {
            umlLabelProviderService.startService();
        }
        catch (ServiceException ex) {
            UMLPapyrusComparePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.uml2.papyrus", "Unable to start UML Label Provider Service", (Throwable)ex));
        }
        return umlLabelProviderService;
    }

    protected Object createProfileSupplier() {
        MissingProfileSupplier missingProfileSupplier = new MissingProfileSupplier(StereotypeApplicationRepair.getRootElement(this.fResource));
        try {
            Field superProfileSupplier = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(FIELD_DYNAMIC_PROFILE_SUPPLIER);
            Class<?> superProfileSupplierType = superProfileSupplier.getType();
            if (superProfileSupplierType.isInstance(missingProfileSupplier)) {
                return missingProfileSupplier;
            }
            return this.createProfileSupplierProxy(missingProfileSupplier, superProfileSupplierType);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return missingProfileSupplier;
        }
    }

    protected Object createProfileSupplierProxy(Function<EPackage, Profile> profileSupplier, Class<?> profileSupplierType) {
        return Proxy.newProxyInstance(StereotypeApplicationRepairSnippet.class.getClassLoader(), new Class[]{profileSupplierType}, (InvocationHandler)new DelegatingInvocationHandler(profileSupplier));
    }

    public Resource getResource() {
        return this.fResource;
    }

    protected ModelSet createModelSetWrapper(ResourceSet resourceSet) {
        ModelSetWrapper modelSet = new ModelSetWrapper(resourceSet);
        modelSet.setReadOnly(this.fResource, Boolean.FALSE);
        return modelSet;
    }

    protected boolean isFieldMissing() {
        return this.fResource == null || this.fLabelProviderService == null || this.fProfileSupplier == null;
    }

    public ZombieStereotypesDescriptor repair() {
        if (this.isFieldMissing()) {
            UMLPapyrusComparePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.uml2.papyrus", "Unable to analyze and repair resource " + this.fResource + " due to missing field: {resource=" + this.fResource + ", labelProviderService=" + this.fLabelProviderService + ", profileSupplier=" + this.fProfileSupplier + "}"));
            return null;
        }
        try {
            ResourceSet resourceSet = this.fResource.getResourceSet();
            ModelSet modelSet = this.createModelSetWrapper(resourceSet);
            this.setAdapter(modelSet);
            modelSet.getResources().add((Object)this.fResource);
            ZombieStereotypesDescriptor stereotypesDescriptor = this.getZombieStereotypes(this.fResource);
            resourceSet.getResources().add((Object)this.fResource);
            return stereotypesDescriptor;
        }
        catch (Exception e) {
            this.fResource.getErrors().add((Object)new ProfileMigrationDiagnostic(UMLPapyrusCompareMessages.getString("profile.migration.exception", e, this.fResource)));
            UMLPapyrusComparePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.uml2.papyrus", "Exception occurred during profile migration", (Throwable)e));
            return null;
        }
    }

    protected static Element getRootElement(Resource resource) {
        return (Element)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
    }
}

