/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.executionSpecification;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.ExecutionSpecificationChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.executionSpecification.data.ExecutionSpecificationInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddBehaviorExecutionSpecificationTest
extends AbstractUMLTest {
    private ExecutionSpecificationInputData input = new ExecutionSpecificationInputData();

    @BeforeClass
    public static void setupClass() {
        AddBehaviorExecutionSpecificationTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddBehaviorExecutionSpecificationTest.resetRegistries();
    }

    @Test
    public void testA20UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA21UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA20UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA21UseCase3way() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)14L, (long)differences.size());
        Predicate addActionExecSpecDescription = null;
        Predicate addCoveredInStartDescription = null;
        Predicate addExecutionInStartDescription = null;
        Predicate addCoveredInFinishDescription = null;
        Predicate addExecutionInFinishDescription = null;
        Predicate addCoveredByInLifeline1Description1 = null;
        Predicate addCoveredByInLifeline1Description2 = null;
        Predicate addCoveredByInLifeline1Description3 = null;
        Predicate addFinishInActionExecSpecDescription = null;
        Predicate addStartInActionExecSpecDescription = null;
        Predicate addStartDescription = null;
        Predicate addFinishDescription = null;
        Predicate addCoveredInActionExecSpecDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addActionExecSpecDescription = EMFComparePredicates.removed((String)"model.interaction0.BehaviorExecSpec0");
            addStartDescription = EMFComparePredicates.removed((String)"model.interaction0.BehaviorExecSpec0Start0");
            addFinishDescription = EMFComparePredicates.removed((String)"model.interaction0.BehaviorExecSpec0Finish0");
            addCoveredInStartDescription = EMFComparePredicates.removedFromReference((String)"model.interaction0.BehaviorExecSpec0Start0", (String)"covered", (String)"model.interaction0.Lifeline2");
            addExecutionInStartDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0Start0", (String)"execution", (String)"model.interaction0.BehaviorExecSpec0", null);
            addCoveredInFinishDescription = EMFComparePredicates.removedFromReference((String)"model.interaction0.BehaviorExecSpec0Finish0", (String)"covered", (String)"model.interaction0.Lifeline2");
            addExecutionInFinishDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0Finish0", (String)"execution", (String)"model.interaction0.BehaviorExecSpec0", null);
            addFinishInActionExecSpecDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0", (String)"finish", (String)"model.interaction0.BehaviorExecSpec0Finish0", null);
            addStartInActionExecSpecDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0", (String)"start", (String)"model.interaction0.BehaviorExecSpec0Start0", null);
            addCoveredByInLifeline1Description1 = EMFComparePredicates.removedFromReference((String)"model.interaction0.Lifeline2", (String)"coveredBy", (String)"model.interaction0.BehaviorExecSpec0Start0");
            addCoveredByInLifeline1Description2 = EMFComparePredicates.removedFromReference((String)"model.interaction0.Lifeline2", (String)"coveredBy", (String)"model.interaction0.BehaviorExecSpec0Finish0");
            addCoveredByInLifeline1Description3 = EMFComparePredicates.removedFromReference((String)"model.interaction0.Lifeline2", (String)"coveredBy", (String)"model.interaction0.BehaviorExecSpec0");
            addCoveredInActionExecSpecDescription = EMFComparePredicates.removedFromReference((String)"model.interaction0.BehaviorExecSpec0", (String)"covered", (String)"model.interaction0.Lifeline2");
        } else {
            addActionExecSpecDescription = EMFComparePredicates.added((String)"model.interaction0.BehaviorExecSpec0");
            addStartDescription = EMFComparePredicates.added((String)"model.interaction0.BehaviorExecSpec0Start0");
            addFinishDescription = EMFComparePredicates.added((String)"model.interaction0.BehaviorExecSpec0Finish0");
            addCoveredInStartDescription = EMFComparePredicates.addedToReference((String)"model.interaction0.BehaviorExecSpec0Start0", (String)"covered", (String)"model.interaction0.Lifeline2");
            addExecutionInStartDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0Start0", (String)"execution", null, (String)"model.interaction0.BehaviorExecSpec0");
            addCoveredInFinishDescription = EMFComparePredicates.addedToReference((String)"model.interaction0.BehaviorExecSpec0Finish0", (String)"covered", (String)"model.interaction0.Lifeline2");
            addExecutionInFinishDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0Finish0", (String)"execution", null, (String)"model.interaction0.BehaviorExecSpec0");
            addFinishInActionExecSpecDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0", (String)"finish", null, (String)"model.interaction0.BehaviorExecSpec0Finish0");
            addStartInActionExecSpecDescription = EMFComparePredicates.changedReference((String)"model.interaction0.BehaviorExecSpec0", (String)"start", null, (String)"model.interaction0.BehaviorExecSpec0Start0");
            addCoveredByInLifeline1Description1 = EMFComparePredicates.addedToReference((String)"model.interaction0.Lifeline2", (String)"coveredBy", (String)"model.interaction0.BehaviorExecSpec0Start0");
            addCoveredByInLifeline1Description2 = EMFComparePredicates.addedToReference((String)"model.interaction0.Lifeline2", (String)"coveredBy", (String)"model.interaction0.BehaviorExecSpec0Finish0");
            addCoveredByInLifeline1Description3 = EMFComparePredicates.addedToReference((String)"model.interaction0.Lifeline2", (String)"coveredBy", (String)"model.interaction0.BehaviorExecSpec0");
            addCoveredInActionExecSpecDescription = EMFComparePredicates.addedToReference((String)"model.interaction0.BehaviorExecSpec0", (String)"covered", (String)"model.interaction0.Lifeline2");
        }
        Diff addActionExecSpec = (Diff)Iterators.find(differences.iterator(), (Predicate)addActionExecSpecDescription);
        Diff addCoveredInStart = (Diff)Iterators.find(differences.iterator(), (Predicate)addCoveredInStartDescription);
        Diff addExecutionInStart = (Diff)Iterators.find(differences.iterator(), (Predicate)addExecutionInStartDescription);
        Diff addCoveredInFinish = (Diff)Iterators.find(differences.iterator(), (Predicate)addCoveredInFinishDescription);
        Diff addExecutionInFinish = (Diff)Iterators.find(differences.iterator(), (Predicate)addExecutionInFinishDescription);
        Diff addFinishInActionExecSpec = (Diff)Iterators.find(differences.iterator(), (Predicate)addFinishInActionExecSpecDescription);
        Diff addStartInActionExecSpec = (Diff)Iterators.find(differences.iterator(), (Predicate)addStartInActionExecSpecDescription);
        Diff addCoveredByInLifeline1_1 = (Diff)Iterators.find(differences.iterator(), (Predicate)addCoveredByInLifeline1Description1);
        Diff addCoveredByInLifeline1_2 = (Diff)Iterators.find(differences.iterator(), (Predicate)addCoveredByInLifeline1Description2);
        Diff addCoveredByInLifeline1_3 = (Diff)Iterators.find(differences.iterator(), (Predicate)addCoveredByInLifeline1Description3);
        Diff addStart = (Diff)Iterators.find(differences.iterator(), (Predicate)addStartDescription);
        Diff addFinish = (Diff)Iterators.find(differences.iterator(), (Predicate)addFinishDescription);
        Diff addCoveredInActionExecSpec = (Diff)Iterators.find(differences.iterator(), (Predicate)addCoveredInActionExecSpecDescription);
        Assert.assertNotNull((Object)addActionExecSpec);
        Assert.assertNotNull((Object)addCoveredInStart);
        Assert.assertNotNull((Object)addExecutionInStart);
        Assert.assertNotNull((Object)addCoveredInFinish);
        Assert.assertNotNull((Object)addExecutionInFinish);
        Assert.assertNotNull((Object)addFinishInActionExecSpec);
        Assert.assertNotNull((Object)addStartInActionExecSpec);
        Assert.assertNotNull((Object)addCoveredByInLifeline1_1);
        Assert.assertNotNull((Object)addCoveredByInLifeline1_2);
        Assert.assertNotNull((Object)addCoveredByInLifeline1_3);
        Assert.assertNotNull((Object)addStart);
        Assert.assertNotNull((Object)addFinish);
        Assert.assertNotNull((Object)addCoveredInActionExecSpec);
        Assert.assertEquals((long)1L, (long)AddBehaviorExecutionSpecificationTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(ExecutionSpecificationChange.class)));
        Diff addUMLMessage = null;
        addUMLMessage = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ExecutionSpecificationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ExecutionSpecificationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLMessage);
        Assert.assertEquals((long)13L, (long)addUMLMessage.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addFinishInActionExecSpec));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addStartInActionExecSpec));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addCoveredInFinish));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addCoveredInStart));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addCoveredInActionExecSpec));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addCoveredByInLifeline1_1));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addCoveredByInLifeline1_2));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addStart));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addFinish));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addActionExecSpec));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addExecutionInStart));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addExecutionInFinish));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addCoveredByInLifeline1_3));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addActionExecSpec.getRequires().size());
            Assert.assertEquals((long)1L, (long)addCoveredInStart.getRequires().size());
            Assert.assertTrue((boolean)addCoveredInStart.getRequires().contains((Object)addStart));
            Assert.assertEquals((long)2L, (long)addExecutionInStart.getRequires().size());
            Assert.assertTrue((boolean)addExecutionInStart.getRequires().contains((Object)addStart));
            Assert.assertTrue((boolean)addExecutionInStart.getRequires().contains((Object)addActionExecSpec));
            Assert.assertEquals((long)1L, (long)addCoveredInFinish.getRequires().size());
            Assert.assertTrue((boolean)addCoveredInFinish.getRequires().contains((Object)addFinish));
            Assert.assertEquals((long)2L, (long)addExecutionInFinish.getRequires().size());
            Assert.assertTrue((boolean)addExecutionInFinish.getRequires().contains((Object)addFinish));
            Assert.assertTrue((boolean)addExecutionInFinish.getRequires().contains((Object)addActionExecSpec));
            Assert.assertEquals((long)2L, (long)addFinishInActionExecSpec.getRequires().size());
            Assert.assertTrue((boolean)addFinishInActionExecSpec.getRequires().contains((Object)addActionExecSpec));
            Assert.assertTrue((boolean)addFinishInActionExecSpec.getRequires().contains((Object)addFinish));
            Assert.assertEquals((long)2L, (long)addStartInActionExecSpec.getRequires().size());
            Assert.assertTrue((boolean)addStartInActionExecSpec.getRequires().contains((Object)addActionExecSpec));
            Assert.assertTrue((boolean)addStartInActionExecSpec.getRequires().contains((Object)addStart));
            Assert.assertEquals((long)1L, (long)addCoveredByInLifeline1_1.getRequires().size());
            Assert.assertTrue((boolean)addCoveredByInLifeline1_1.getRequires().contains((Object)addStart));
            Assert.assertEquals((long)1L, (long)addCoveredByInLifeline1_2.getRequires().size());
            Assert.assertTrue((boolean)addCoveredByInLifeline1_2.getRequires().contains((Object)addFinish));
            Assert.assertEquals((long)1L, (long)addCoveredByInLifeline1_3.getRequires().size());
            Assert.assertTrue((boolean)addCoveredByInLifeline1_3.getRequires().contains((Object)addActionExecSpec));
            Assert.assertEquals((long)0L, (long)addStart.getRequires().size());
            Assert.assertEquals((long)0L, (long)addFinish.getRequires().size());
            Assert.assertEquals((long)1L, (long)addCoveredInActionExecSpec.getRequires().size());
            Assert.assertTrue((boolean)addCoveredInActionExecSpec.getRequires().contains((Object)addActionExecSpec));
        } else {
            Assert.assertEquals((long)6L, (long)addActionExecSpec.getRequires().size());
            Assert.assertTrue((boolean)addActionExecSpec.getRequires().contains((Object)addFinishInActionExecSpec));
            Assert.assertTrue((boolean)addActionExecSpec.getRequires().contains((Object)addStartInActionExecSpec));
            Assert.assertTrue((boolean)addActionExecSpec.getRequires().contains((Object)addCoveredInActionExecSpec));
            Assert.assertTrue((boolean)addActionExecSpec.getRequires().contains((Object)addExecutionInFinish));
            Assert.assertTrue((boolean)addActionExecSpec.getRequires().contains((Object)addExecutionInStart));
            Assert.assertTrue((boolean)addActionExecSpec.getRequires().contains((Object)addCoveredByInLifeline1_3));
            Assert.assertEquals((long)0L, (long)addCoveredInStart.getRequires().size());
            Assert.assertEquals((long)0L, (long)addExecutionInStart.getRequires().size());
            Assert.assertEquals((long)0L, (long)addCoveredInFinish.getRequires().size());
            Assert.assertEquals((long)0L, (long)addExecutionInFinish.getRequires().size());
            Assert.assertEquals((long)0L, (long)addFinishInActionExecSpec.getRequires().size());
            Assert.assertEquals((long)0L, (long)addStartInActionExecSpec.getRequires().size());
            Assert.assertEquals((long)0L, (long)addCoveredByInLifeline1_1.getRequires().size());
            Assert.assertEquals((long)0L, (long)addCoveredByInLifeline1_2.getRequires().size());
            Assert.assertEquals((long)0L, (long)addCoveredByInLifeline1_3.getRequires().size());
            Assert.assertEquals((long)4L, (long)addStart.getRequires().size());
            Assert.assertTrue((boolean)addStart.getRequires().contains((Object)addStartInActionExecSpec));
            Assert.assertTrue((boolean)addStart.getRequires().contains((Object)addCoveredByInLifeline1_1));
            Assert.assertTrue((boolean)addStart.getRequires().contains((Object)addCoveredInStart));
            Assert.assertTrue((boolean)addStart.getRequires().contains((Object)addExecutionInStart));
            Assert.assertEquals((long)4L, (long)addFinish.getRequires().size());
            Assert.assertTrue((boolean)addFinish.getRequires().contains((Object)addFinishInActionExecSpec));
            Assert.assertTrue((boolean)addFinish.getRequires().contains((Object)addCoveredByInLifeline1_2));
            Assert.assertTrue((boolean)addFinish.getRequires().contains((Object)addCoveredInFinish));
            Assert.assertTrue((boolean)addFinish.getRequires().contains((Object)addExecutionInFinish));
            Assert.assertEquals((long)0L, (long)addCoveredInActionExecSpec.getRequires().size());
        }
        Assert.assertEquals((long)3L, (long)comparison.getEquivalences().size());
        Assert.assertNotNull((Object)addCoveredInStart.getEquivalence());
        Assert.assertEquals((long)2L, (long)addCoveredInStart.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addCoveredInStart.getEquivalence().getDifferences().contains((Object)addCoveredInStart));
        Assert.assertTrue((boolean)addCoveredInStart.getEquivalence().getDifferences().contains((Object)addCoveredByInLifeline1_1));
        Assert.assertNotNull((Object)addCoveredInFinish.getEquivalence());
        Assert.assertEquals((long)2L, (long)addCoveredInFinish.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addCoveredInFinish.getEquivalence().getDifferences().contains((Object)addCoveredInFinish));
        Assert.assertTrue((boolean)addCoveredInFinish.getEquivalence().getDifferences().contains((Object)addCoveredByInLifeline1_2));
        Assert.assertNotNull((Object)addCoveredInActionExecSpec.getEquivalence());
        Assert.assertEquals((long)2L, (long)addCoveredInActionExecSpec.getEquivalence().getDifferences().size());
        Assert.assertTrue((boolean)addCoveredInActionExecSpec.getEquivalence().getDifferences().contains((Object)addCoveredInActionExecSpec));
        Assert.assertTrue((boolean)addCoveredInActionExecSpec.getEquivalence().getDifferences().contains((Object)addCoveredByInLifeline1_3));
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

