/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.timeConstraint;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.IntervalConstraintChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.timeConstraint.data.TimeConstraintInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddTimeConstraintTest
extends AbstractUMLTest {
    private TimeConstraintInputData input = new TimeConstraintInputData();

    @BeforeClass
    public static void setupClass() {
        AddTimeConstraintTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddTimeConstraintTest.resetRegistries();
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)10L, (long)differences.size());
        Predicate addTimeConstraintDescription = null;
        Predicate addTimeIntervalDescription = null;
        Predicate addTimeExpressionMinDescription = null;
        Predicate addTimeExpressionMaxDescription = null;
        Predicate addMinValueDescription = null;
        Predicate addMaxValueDescription = null;
        Predicate addConstrainedElementInTimeConstraintDescription = null;
        Predicate addMinInTimeIntervalDescription = null;
        Predicate addMaxInTimeIntervalDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addTimeConstraintDescription = EMFComparePredicates.removed((String)"model.interaction0.TimeConstraint0");
            addTimeIntervalDescription = EMFComparePredicates.removed((String)"model.interaction0.TimeConstraint0.TimeInterval");
            addTimeExpressionMinDescription = EMFComparePredicates.removed((String)"model.TimeIntervalMin0");
            addTimeExpressionMaxDescription = EMFComparePredicates.removed((String)"model.TimeIntervalMax0");
            addMinValueDescription = EMFComparePredicates.removed((String)"model.TimeIntervalMin0.min");
            addMaxValueDescription = EMFComparePredicates.removed((String)"model.TimeIntervalMax0.max");
            addConstrainedElementInTimeConstraintDescription = EMFComparePredicates.removedFromReference((String)"model.interaction0.TimeConstraint0", (String)"constrainedElement", (String)"model.interaction0.Message0Send0");
            addMinInTimeIntervalDescription = EMFComparePredicates.changedReference((String)"model.interaction0.TimeConstraint0.TimeInterval", (String)"min", (String)"model.TimeIntervalMin0", null);
            addMaxInTimeIntervalDescription = EMFComparePredicates.changedReference((String)"model.interaction0.TimeConstraint0.TimeInterval", (String)"max", (String)"model.TimeIntervalMax0", null);
        } else {
            addTimeConstraintDescription = EMFComparePredicates.added((String)"model.interaction0.TimeConstraint0");
            addTimeIntervalDescription = EMFComparePredicates.added((String)"model.interaction0.TimeConstraint0.TimeInterval");
            addTimeExpressionMinDescription = EMFComparePredicates.added((String)"model.TimeIntervalMin0");
            addTimeExpressionMaxDescription = EMFComparePredicates.added((String)"model.TimeIntervalMax0");
            addMinValueDescription = EMFComparePredicates.added((String)"model.TimeIntervalMin0.min");
            addMaxValueDescription = EMFComparePredicates.added((String)"model.TimeIntervalMax0.max");
            addConstrainedElementInTimeConstraintDescription = EMFComparePredicates.addedToReference((String)"model.interaction0.TimeConstraint0", (String)"constrainedElement", (String)"model.interaction0.Message0Send0");
            addMinInTimeIntervalDescription = EMFComparePredicates.changedReference((String)"model.interaction0.TimeConstraint0.TimeInterval", (String)"min", null, (String)"model.TimeIntervalMin0");
            addMaxInTimeIntervalDescription = EMFComparePredicates.changedReference((String)"model.interaction0.TimeConstraint0.TimeInterval", (String)"max", null, (String)"model.TimeIntervalMax0");
        }
        Diff addTimeConstraint = (Diff)Iterators.find(differences.iterator(), (Predicate)addTimeConstraintDescription);
        Diff addTimeInterval = (Diff)Iterators.find(differences.iterator(), (Predicate)addTimeIntervalDescription);
        Diff addTimeExpressionMin = (Diff)Iterators.find(differences.iterator(), (Predicate)addTimeExpressionMinDescription);
        Diff addTimeExpressionMax = (Diff)Iterators.find(differences.iterator(), (Predicate)addTimeExpressionMaxDescription);
        Diff addMinValue = (Diff)Iterators.find(differences.iterator(), (Predicate)addMinValueDescription);
        Diff addMaxValue = (Diff)Iterators.find(differences.iterator(), (Predicate)addMaxValueDescription);
        Diff addConstrainedElementInTimeConstraint = (Diff)Iterators.find(differences.iterator(), (Predicate)addConstrainedElementInTimeConstraintDescription);
        Diff addMinInTimeInterval = (Diff)Iterators.find(differences.iterator(), (Predicate)addMinInTimeIntervalDescription);
        Diff addMaxInTimeInterval = (Diff)Iterators.find(differences.iterator(), (Predicate)addMaxInTimeIntervalDescription);
        Assert.assertNotNull((Object)addTimeConstraint);
        Assert.assertNotNull((Object)addTimeInterval);
        Assert.assertNotNull((Object)addTimeExpressionMin);
        Assert.assertNotNull((Object)addTimeExpressionMax);
        Assert.assertNotNull((Object)addMinValue);
        Assert.assertNotNull((Object)addMaxValue);
        Assert.assertNotNull((Object)addConstrainedElementInTimeConstraint);
        Assert.assertNotNull((Object)addMinInTimeInterval);
        Assert.assertNotNull((Object)addMaxInTimeInterval);
        Assert.assertEquals((long)1L, (long)AddTimeConstraintTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(IntervalConstraintChange.class)));
        Diff addUMLMessage = null;
        addUMLMessage = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IntervalConstraintChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IntervalConstraintChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLMessage);
        Assert.assertEquals((long)9L, (long)addUMLMessage.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addConstrainedElementInTimeConstraint));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addTimeInterval));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addMinInTimeInterval));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addMaxInTimeInterval));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addMinValue));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addMaxValue));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addTimeExpressionMin));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addTimeExpressionMax));
        Assert.assertTrue((boolean)addUMLMessage.getRefinedBy().contains((Object)addTimeConstraint));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addTimeConstraint.getRequires().size());
            Assert.assertEquals((long)1L, (long)addTimeInterval.getRequires().size());
            Assert.assertTrue((boolean)addTimeInterval.getRequires().contains((Object)addTimeConstraint));
            Assert.assertEquals((long)0L, (long)addTimeExpressionMin.getRequires().size());
            Assert.assertEquals((long)0L, (long)addTimeExpressionMax.getRequires().size());
            Assert.assertEquals((long)1L, (long)addMinValue.getRequires().size());
            Assert.assertTrue((boolean)addMinValue.getRequires().contains((Object)addTimeExpressionMin));
            Assert.assertEquals((long)1L, (long)addMaxValue.getRequires().size());
            Assert.assertTrue((boolean)addMaxValue.getRequires().contains((Object)addTimeExpressionMax));
            Assert.assertEquals((long)1L, (long)addConstrainedElementInTimeConstraint.getRequires().size());
            Assert.assertTrue((boolean)addTimeInterval.getRequires().contains((Object)addTimeConstraint));
            Assert.assertEquals((long)2L, (long)addMinInTimeInterval.getRequires().size());
            Assert.assertTrue((boolean)addMinInTimeInterval.getRequires().contains((Object)addTimeInterval));
            Assert.assertTrue((boolean)addMinInTimeInterval.getRequires().contains((Object)addTimeExpressionMin));
            Assert.assertEquals((long)2L, (long)addMaxInTimeInterval.getRequires().size());
            Assert.assertTrue((boolean)addMaxInTimeInterval.getRequires().contains((Object)addTimeInterval));
            Assert.assertTrue((boolean)addMaxInTimeInterval.getRequires().contains((Object)addTimeExpressionMax));
        } else {
            Assert.assertEquals((long)2L, (long)addTimeConstraint.getRequires().size());
            Assert.assertTrue((boolean)addTimeConstraint.getRequires().contains((Object)addConstrainedElementInTimeConstraint));
            Assert.assertTrue((boolean)addTimeConstraint.getRequires().contains((Object)addTimeInterval));
            Assert.assertEquals((long)2L, (long)addTimeInterval.getRequires().size());
            Assert.assertTrue((boolean)addTimeInterval.getRequires().contains((Object)addMinInTimeInterval));
            Assert.assertTrue((boolean)addTimeInterval.getRequires().contains((Object)addMaxInTimeInterval));
            Assert.assertEquals((long)2L, (long)addTimeExpressionMin.getRequires().size());
            Assert.assertTrue((boolean)addTimeExpressionMin.getRequires().contains((Object)addMinValue));
            Assert.assertTrue((boolean)addTimeExpressionMin.getRequires().contains((Object)addMinInTimeInterval));
            Assert.assertEquals((long)2L, (long)addTimeExpressionMax.getRequires().size());
            Assert.assertTrue((boolean)addTimeExpressionMax.getRequires().contains((Object)addMaxValue));
            Assert.assertTrue((boolean)addTimeExpressionMax.getRequires().contains((Object)addMaxInTimeInterval));
            Assert.assertEquals((long)0L, (long)addMinValue.getRequires().size());
            Assert.assertEquals((long)0L, (long)addMaxValue.getRequires().size());
            Assert.assertEquals((long)0L, (long)addConstrainedElementInTimeConstraint.getRequires().size());
            Assert.assertEquals((long)0L, (long)addMinInTimeInterval.getRequires().size());
            Assert.assertEquals((long)0L, (long)addMaxInTimeInterval.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

