/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.egit.fixture;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.DisconnectProviderOperation;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;

public class GitTestRepository {
    private final List<Runnable> disposers;
    Repository repository;
    String workdirPrefix;

    public GitTestRepository(File gitDir) throws IOException {
        FileRepository tmpRepository = new FileRepository(gitDir);
        tmpRepository.create();
        tmpRepository.close();
        this.repository = RepositoryCache.INSTANCE.lookupRepository(gitDir);
        try {
            this.workdirPrefix = this.repository.getWorkTree().getCanonicalPath();
        }
        catch (IOException err) {
            this.workdirPrefix = this.repository.getWorkTree().getAbsolutePath();
        }
        this.workdirPrefix = this.workdirPrefix.replace('\\', '/');
        if (!this.workdirPrefix.endsWith("/")) {
            this.workdirPrefix = String.valueOf(this.workdirPrefix) + "/";
        }
        this.disposers = new ArrayList<Runnable>();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public File createFile(IProject project, String name) throws IOException {
        String path = project.getLocation().append(name).toOSString();
        int lastSeparator = path.lastIndexOf(File.separator);
        FileUtils.mkdirs((File)new File(path.substring(0, lastSeparator)), (boolean)true);
        File file = new File(path);
        if (!file.exists()) {
            FileUtils.createNewFile((File)file);
        }
        return file;
    }

    public IFile getIFile(IProject project, File file) throws CoreException {
        String relativePath = this.getRepoRelativePath(file.getAbsolutePath());
        int index = relativePath.indexOf(project.getName());
        if (index >= 0) {
            relativePath = relativePath.substring(index + project.getName().length());
        }
        IFile iFile = project.getFile(relativePath);
        iFile.refreshLocal(0, null);
        return iFile;
    }

    public void appendFileContent(File file, byte[] content) throws IOException {
        this.appendFileContent(file, new String(content, "UTF-8"), true);
    }

    public void appendFileContent(File file, String content) throws IOException {
        this.appendFileContent(file, content, true);
    }

    public void appendFileContent(File file, byte[] content, boolean append) throws IOException {
        this.appendFileContent(file, new String(content, "UTF-8"), append);
    }

    public void appendFileContent(File file, String content, boolean append) throws IOException {
        try (Writer fw = null;){
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");
            fw.append(content);
        }
    }

    public RevCommit addAllAndCommit(String commitMessage) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.repository);){
            git.add().addFilepattern(".").call();
            return this.commit(commitMessage);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RevCommit addAllAndAmend(String message) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.repository);){
            git.add().addFilepattern(".").call();
            return git.commit().setAmend(true).setMessage(message).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RevCommit addAndCommit(TestProject testProject, String commitMessage, File ... files) throws Exception {
        this.addToIndex(testProject, files);
        return this.commit(commitMessage);
    }

    public RevCommit addAndCommit(IProject project, String commitMessage, File ... files) throws Exception {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.track(file);
            this.addToIndex(project, file);
            ++n2;
        }
        return this.commit(commitMessage);
    }

    public void addToIndex(IProject project, File file) throws Exception {
        IFile iFile = this.getIFile(project, file);
        this.addToIndex((IResource)iFile);
    }

    public void addToIndex(IResource resource) throws CoreException, IOException, NoFilepatternException, GitAPIException {
        String repoPath = this.getRepoRelativePath(resource.getLocation().toString());
        Throwable throwable = null;
        Object var4_5 = null;
        try (Git git = new Git(this.repository);){
            git.add().addFilepattern(repoPath).call();
            git.add().addFilepattern(repoPath).setUpdate(true).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RevCommit appendContentAndCommit(IProject project, File file, byte[] content, String commitMessage) throws Exception {
        return this.appendContentAndCommit(project, file, new String(content, "UTF-8"), commitMessage);
    }

    public RevCommit appendContentAndCommit(IProject project, File file, String content, String commitMessage) throws Exception {
        this.appendFileContent(file, content);
        this.track(file);
        this.addToIndex(project, file);
        return this.commit(commitMessage);
    }

    public void ignore(File ... files) throws Exception {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            paths.add(new Path(file.getPath()));
            ++n2;
        }
        new IgnoreOperation(paths).execute((IProgressMonitor)new NullProgressMonitor());
    }

    public void addToIndex(TestProject testProject, File ... files) throws Exception {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addToIndex((IResource)testProject.getIFile(testProject.getProject(), file));
            ++n2;
        }
    }

    public void removeFromIndex(TestProject testProject, File ... files) throws Exception {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.removeFromIndex(new IResource[]{testProject.getIFile(testProject.getProject(), file)});
            ++n2;
        }
    }

    public void addToIndex(IResource ... resources) throws CoreException, IOException, NoFilepatternException, GitAPIException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.repository);){
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String repoPath = this.getRepoRelativePath(resource.getLocation().toString());
                git.add().addFilepattern(repoPath).call();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void removeFromIndex(IResource ... resources) throws CoreException, IOException, NoFilepatternException, GitAPIException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.repository);){
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String repoPath = this.getRepoRelativePath(resource.getLocation().toString());
                git.rm().addFilepattern(repoPath).call();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RevCommit commit(String message) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.repository);){
            CommitCommand commitCommand = git.commit();
            commitCommand.setAuthor("J. Git", "j.git@egit.org");
            commitCommand.setCommitter(commitCommand.getAuthor());
            commitCommand.setMessage(message);
            return commitCommand.call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void connect(IProject project) throws CoreException {
        ConnectProviderOperation op = new ConnectProviderOperation(project, this.repository.getDirectory());
        op.execute(null);
    }

    public void createBranch(String refName, String newRefName) throws IOException {
        RefUpdate updateRef = this.repository.updateRef(newRefName);
        Ref startRef = this.repository.findRef(refName);
        ObjectId startAt = this.repository.resolve(refName);
        String startBranch = startRef != null ? refName : startAt.name();
        startBranch = Repository.shortenRefName((String)startBranch);
        updateRef.setNewObjectId((AnyObjectId)startAt);
        updateRef.setRefLogMessage("branch: Created from " + startBranch, false);
        updateRef.update();
    }

    public void reset(String refName, ResetCommand.ResetType type) throws CoreException {
        new ResetOperation(this.repository, refName, type).execute(null);
    }

    public void checkoutBranch(String refName) throws CoreException {
        new BranchOperation(this.repository, refName).execute(null);
    }

    public void mergeLogical(String refName) throws CoreException {
        new MergeOperation(this.repository, refName).execute(null);
    }

    public void mergeLogicalWithNewCommit(String refName) throws CoreException {
        MergeOperation mergeOperation = new MergeOperation(this.repository, refName);
        mergeOperation.setCommit(true);
        mergeOperation.execute(null);
    }

    public void mergeTextual(String refName) throws CoreException {
        new MergeOperation(this.repository, refName, MergeStrategy.RECURSIVE.getName()).execute(null);
    }

    public void rebaseLogical(String refName) throws CoreException, IOException {
        new RebaseOperation(this.repository, this.repository.findRef(refName)).execute(null);
    }

    public void createAndCheckoutBranch(String refName, String newRefName) throws Exception {
        this.createBranch(refName, newRefName);
        this.checkoutBranch(newRefName);
    }

    public void untrack(File file) throws IOException {
        String repoPath = this.getRepoRelativePath(new Path(file.getPath()).toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                git.rm().addFilepattern(repoPath).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void disconnect(IProject project) throws CoreException {
        Set<IProject> projects = Collections.singleton(project.getProject());
        DisconnectProviderOperation disconnect = new DisconnectProviderOperation(projects);
        disconnect.execute(null);
    }

    public Status status() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Git git = new Git(this.repository);){
            return git.status().call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void track(File file) throws IOException, NoFilepatternException, GitAPIException {
        String repoPath = this.getRepoRelativePath(new Path(file.getPath()).toString());
        Throwable throwable = null;
        Object var4_5 = null;
        try (Git git = new Git(this.repository);){
            git.add().addFilepattern(repoPath).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RevCommit findCommit(String revstr) throws Exception {
        try (RevWalk walk = null;){
            walk = new RevWalk(this.repository);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)this.repository.resolve(revstr));
            return revCommit;
        }
    }

    public void dispose() {
        for (Runnable disposer : this.disposers) {
            disposer.run();
        }
        this.disposers.clear();
    }

    public Subscriber createSubscriberForResolution(String sourceRef, String targetRef, boolean includeLocal) throws IOException {
        GitSynchronizeData data = new GitSynchronizeData(this.repository, sourceRef, targetRef, includeLocal);
        GitSynchronizeDataSet dataSet = new GitSynchronizeDataSet(data);
        final GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(dataSet);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        this.disposers.add(new Runnable(){

            @Override
            public void run() {
                subscriber.dispose();
            }
        });
        return subscriber;
    }

    public Subscriber createSubscriberForComparison(String sourceRef, String targetRef, IFile comparedFile, boolean includeLocal) throws IOException {
        GitSynchronizeData data = new GitSynchronizeData(this.repository, sourceRef, targetRef, includeLocal);
        GitSynchronizeDataSet dataSet = new GitSynchronizeDataSet(data);
        final GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(dataSet);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        ResourceMapping[] mappings = GitTestRepository.getResourceMappings(comparedFile, ResourceMappingContext.LOCAL_CONTEXT);
        GitSubscriberResourceMappingContext remoteContext = new GitSubscriberResourceMappingContext(subscriber, dataSet);
        final SubscriberScopeManager manager = new SubscriberScopeManager(subscriber.getName(), mappings, (Subscriber)subscriber, (RemoteResourceMappingContext)remoteContext, true);
        final GitSubscriberMergeContext context = new GitSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager, dataSet);
        this.disposers.add(new Runnable(){

            @Override
            public void run() {
                manager.dispose();
                context.dispose();
                subscriber.dispose();
            }
        });
        return context.getSubscriber();
    }

    public Subscriber createSubscriberForComparisonWithRemoteMappings(String sourceRef, String targetRef, IFile comparedFile) throws IOException {
        GitSynchronizeData data = new GitSynchronizeData(this.repository, sourceRef, targetRef, false);
        GitSynchronizeDataSet dataSet = new GitSynchronizeDataSet(data);
        final GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(dataSet);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        GitSubscriberResourceMappingContext remoteContext = new GitSubscriberResourceMappingContext(subscriber, dataSet);
        ResourceMapping[] mappings = GitTestRepository.getResourceMappings(comparedFile, (ResourceMappingContext)remoteContext);
        final SubscriberScopeManager manager = new SubscriberScopeManager(subscriber.getName(), mappings, (Subscriber)subscriber, (RemoteResourceMappingContext)remoteContext, true);
        final GitSubscriberMergeContext context = new GitSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager, dataSet);
        this.disposers.add(new Runnable(){

            @Override
            public void run() {
                manager.dispose();
                context.dispose();
                subscriber.dispose();
            }
        });
        return context.getSubscriber();
    }

    public String getRepoRelativePath(File file) {
        return this.getRepoRelativePath(new Path(file.getPath()).toString());
    }

    public String getRepoRelativePath(String path) {
        int pfxLen = this.workdirPrefix.length();
        int pLen = path.length();
        if (pLen > pfxLen) {
            return path.substring(pfxLen);
        }
        if (path.length() == pfxLen - 1) {
            return "";
        }
        return null;
    }

    private static ResourceMapping[] getResourceMappings(IFile file, ResourceMappingContext context) {
        IModelProviderDescriptor[] modelDescriptors = ModelProvider.getModelProviderDescriptors();
        LinkedHashSet<ResourceMapping> mappings = new LinkedHashSet<ResourceMapping>();
        IModelProviderDescriptor[] iModelProviderDescriptorArray = modelDescriptors;
        int n = modelDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor candidate = iModelProviderDescriptorArray[n2];
            try {
                IResource[] resources = candidate.getMatchingResources(new IResource[]{file});
                if (resources.length > 0) {
                    ResourceMapping[] modelMappings;
                    ModelProvider model = candidate.getModelProvider();
                    ResourceMapping[] resourceMappingArray = modelMappings = model.getMappings((IResource)file, context, null);
                    int n3 = modelMappings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ResourceMapping mapping = resourceMappingArray[n4];
                        mappings.add(mapping);
                        ++n4;
                    }
                }
            }
            catch (CoreException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }
}

