/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.Navigatable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.mockito.Mockito;

final class TestContext {
    private int counter = 0;
    private Tree swtTree;
    private Object root;
    private Map<Integer, Object> elementRetriever;
    private Map<Object, List<Object>> elementChildren;
    private Map<Object, Object> elementParent;
    private WrappableTreeViewer viewer;
    private final Shell currentShell;
    private Object[] currentSelection;

    public TestContext(Shell shell) {
        this.currentShell = shell;
        this.elementRetriever = new HashMap<Integer, Object>();
        this.elementChildren = new HashMap<Object, List<Object>>();
        this.elementParent = new HashMap<Object, Object>();
    }

    private Integer increment() {
        return new Integer(this.counter++);
    }

    public Tree getTree() {
        return this.swtTree;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getElement(int id) {
        return this.elementRetriever.get(id);
    }

    public int getNumberOfNodes() {
        return this.counter - 1;
    }

    public void dispose() {
        if (this.swtTree != null) {
            this.swtTree.dispose();
            this.swtTree = null;
        }
        this.elementRetriever.clear();
    }

    public TestNavigatable buildTree(int depth, int numberOfChildren) {
        return this.buildTree(depth, numberOfChildren, true);
    }

    public TestNavigatable buildTree(int depth, int numberOfChildren, boolean useStrings) {
        if (this.swtTree == null) {
            this.swtTree = new Tree((Composite)this.currentShell, 0);
            this.viewer = new WrappableTreeViewer(this.swtTree);
            this.viewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        TestContext.this.currentSelection = ((IStructuredSelection)event.getSelection()).toArray();
                    }
                }
            });
            this.root = this.swtTree;
            this.elementChildren.put(this.root, this.createSubNodes(this.root, numberOfChildren, depth, useStrings));
            AdapterFactory adapterFactory = (AdapterFactory)Mockito.mock(AdapterFactory.class);
            EMFCompareStructureMergeViewerContentProvider navigatableContentProvider = new EMFCompareStructureMergeViewerContentProvider(adapterFactory, (AbstractTreeViewer)this.viewer);
            ITreeContentProvider viewerContentProvider = this.createElementContentProvider();
            this.viewer.setContentProvider((IContentProvider)viewerContentProvider);
            this.viewer.setInput(this.root);
            List<Object> rootChildren = this.elementChildren.get(this.root);
            if (!rootChildren.isEmpty()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(rootChildren.get(0)));
            }
            return new TestNavigatable(this.viewer, navigatableContentProvider);
        }
        throw new AssertionError((Object)"The tree can only be built once");
    }

    private ITreeContentProvider createElementContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)TestContext.this.elementChildren.get(inputElement)).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((List)TestContext.this.elementChildren.get(parentElement)).toArray();
            }

            public Object getParent(Object element) {
                return TestContext.this.elementParent.get(element);
            }

            public boolean hasChildren(Object element) {
                return !((List)TestContext.this.elementChildren.get(element)).isEmpty();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewers, Object oldInput, Object newInput) {
            }
        };
    }

    private List<Object> createSubNodes(Object parent, int numberOfChild, int depth, boolean useStrings) {
        ArrayList children = Lists.newArrayList();
        if (depth > 0) {
            int childIndex = 0;
            while (childIndex < numberOfChild) {
                Integer increment = this.increment();
                String name = String.valueOf(increment);
                String data = null;
                if (useStrings) {
                    data = name;
                } else {
                    Adapter adapter = (Adapter)Mockito.mock(Adapter.class);
                    TreeNode notifier = (TreeNode)Mockito.mock(TreeNode.class);
                    Diff diff = (Diff)Mockito.mock(Diff.class);
                    Mockito.when((Object)adapter.getTarget()).thenReturn((Object)notifier);
                    Mockito.when((Object)notifier.getData()).thenReturn((Object)diff);
                    data = adapter;
                }
                this.elementParent.put(data, parent);
                children.add(data);
                this.elementRetriever.put(increment, data);
                this.elementChildren.put(data, this.createSubNodes(data, numberOfChild, depth - 1, useStrings));
                ++childIndex;
            }
        }
        return children;
    }

    public Object[] getCurrentSelection() {
        return this.currentSelection;
    }

    public class TestNavigatable
    extends Navigatable {
        public TestNavigatable(WrappableTreeViewer viewer, EMFCompareStructureMergeViewerContentProvider contentProvider) {
            super(viewer, contentProvider);
            this.uiSyncCallbackType = EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_CURRENT_THREAD;
        }

        public Object getNextItem(Object start) {
            return super.getNextItem(start);
        }

        public Object getPreviousItem(Object start) {
            return super.getPreviousItem(start);
        }
    }
}

