/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public final class MatchUtil {
    private MatchUtil() {
    }

    public static EObject getOriginObject(Comparison comparison, EObject object) {
        EObject result = null;
        Match match = comparison.getMatch(object);
        if (match != null) {
            result = comparison.isThreeWay() ? match.getOrigin() : (object == match.getLeft() ? match.getRight() : match.getLeft());
        }
        return result;
    }

    public static boolean matchingIndices(Match match, EStructuralFeature feature, Object value1, Object value2) {
        int rightIndex;
        int leftIndex;
        boolean matching = false;
        matching = feature.isMany() ? (leftIndex = MatchUtil.computeIndex(match, feature, value1, DifferenceSource.LEFT)) == (rightIndex = MatchUtil.computeIndex(match, feature, value2, DifferenceSource.RIGHT)) : true;
        return matching;
    }

    public static int computeIndex(Match match, EStructuralFeature feature, Object value, DifferenceSource side) {
        Comparison comparison = match.getComparison();
        int result = -1;
        EObject matchedObject = MatchUtil.getMatchedObject(match, side);
        if (matchedObject != null) {
            IEqualityHelper equalityHelper = comparison.getEqualityHelper();
            boolean hasOrigin = match.getOrigin() != null;
            List sideValues = (List)ReferenceUtil.safeEGet(matchedObject, feature);
            for (Object sideObject : sideValues) {
                if (equalityHelper.matchingValues(sideObject, value)) break;
                if (hasOrigin && MatchUtil.hasDiff(match, feature, sideObject) || MatchUtil.hasDeleteDiff(match, feature, sideObject)) continue;
                ++result;
            }
        }
        return result;
    }

    public static boolean hasDeleteDiff(Match match, EStructuralFeature feature, Object value) {
        Match valueMatch;
        Comparison comparison = match.getComparison();
        Object expectedValue = value instanceof EObject && comparison.isThreeWay() ? ((valueMatch = comparison.getMatch((EObject)value)) != null ? valueMatch.getOrigin() : value) : value;
        return Iterables.any(match.getDifferences(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.DELETE), EMFComparePredicates.onFeature(feature.getName()), EMFComparePredicates.valueIs(expectedValue)}));
    }

    public static boolean hasDiff(Match match, EStructuralFeature feature, Object value) {
        return Iterables.any(match.getDifferences(), (Predicate)Predicates.and(EMFComparePredicates.onFeature(feature.getName()), EMFComparePredicates.valueIs(value)));
    }

    public static EObject getOriginValue(Comparison comparison, ReferenceChange difference) {
        Object originValue;
        EObject originContainer;
        EReference reference = difference.getReference();
        if (!reference.isContainment() && !reference.isMany() && difference.getKind().equals((Object)DifferenceKind.CHANGE) && (originContainer = MatchUtil.getOriginContainer(comparison, difference)) != null && (originValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)reference)) instanceof EObject) {
            return (EObject)originValue;
        }
        return null;
    }

    public static EObject getOriginContainer(Comparison comparison, Diff difference) {
        EObject diffContainer = comparison.isThreeWay() ? difference.getMatch().getOrigin() : (MatchUtil.getContainer(comparison, difference) == difference.getMatch().getLeft() ? difference.getMatch().getRight() : difference.getMatch().getLeft());
        return diffContainer;
    }

    public static EObject getContainer(Comparison comparison, Diff difference) {
        EObject result = null;
        Match match = difference.getMatch();
        DifferenceSource source = difference.getSource();
        DifferenceKind kind = difference.getKind();
        switch (kind) {
            case DELETE: {
                if (comparison.isThreeWay()) {
                    result = match.getOrigin();
                    break;
                }
                result = match.getRight();
                break;
            }
            case ADD: 
            case MOVE: {
                if (source == DifferenceSource.LEFT) {
                    result = match.getLeft();
                    break;
                }
                result = match.getRight();
                break;
            }
            case CHANGE: {
                Object value = MatchUtil.getValue(difference);
                EStructuralFeature feature = MatchUtil.getStructuralFeature(difference);
                if (value == null || feature == null) {
                    throw new IllegalArgumentException();
                }
                if (source == DifferenceSource.LEFT) {
                    EObject left = match.getLeft();
                    if (MatchUtil.featureContains(left, feature, value)) {
                        result = left;
                        break;
                    }
                    if (comparison.isThreeWay()) {
                        result = match.getOrigin();
                        break;
                    }
                    result = match.getRight();
                    break;
                }
                EObject right = match.getRight();
                result = MatchUtil.featureContains(right, feature, value) ? right : (comparison.isThreeWay() ? match.getOrigin() : match.getLeft());
            }
        }
        return result;
    }

    public static boolean featureContains(EObject eObject, EStructuralFeature feature, Object value) {
        boolean contains = false;
        if (eObject != null && feature != null) {
            Object featureValue = ReferenceUtil.safeEGet(eObject, feature);
            if (feature.isMany()) {
                URI valueURI = null;
                Iterator i = featureValue instanceof InternalEList ? ((InternalEList)featureValue).basicIterator() : ((List)featureValue).iterator();
                while (i.hasNext()) {
                    Object element = i.next();
                    if (element == value) {
                        contains = true;
                    } else if (element != null && element.equals(value)) {
                        contains = true;
                    } else {
                        URI proxyURI = MatchUtil.getProxyURI(element);
                        if (proxyURI == null) continue;
                        if (valueURI == null && value instanceof EObject) {
                            valueURI = EcoreUtil.getURI((EObject)((EObject)value));
                        }
                        if (!proxyURI.equals(valueURI)) continue;
                        contains = true;
                    }
                    break;
                }
            } else if (featureValue == value) {
                contains = true;
            } else if (featureValue != null && featureValue.equals(value)) {
                contains = true;
            } else {
                URI proxyURI = MatchUtil.getProxyURI(featureValue);
                if (proxyURI != null && value instanceof EObject && proxyURI.equals(EcoreUtil.getURI((EObject)((EObject)value)))) {
                    contains = true;
                }
            }
        }
        return contains;
    }

    private static URI getProxyURI(Object object) {
        if (object instanceof InternalEObject) {
            return ((InternalEObject)object).eProxyURI();
        }
        return null;
    }

    public static Object getValue(Diff input) {
        if (input instanceof AttributeChange) {
            return ((AttributeChange)input).getValue();
        }
        if (input instanceof ReferenceChange) {
            return ((ReferenceChange)input).getValue();
        }
        return null;
    }

    public static EStructuralFeature getStructuralFeature(Diff input) {
        if (input instanceof AttributeChange) {
            return ((AttributeChange)input).getAttribute();
        }
        if (input instanceof ReferenceChange) {
            return ((ReferenceChange)input).getReference();
        }
        return null;
    }

    public static EObject getMatchedObject(Match m, DifferenceSource side) {
        if (side == null) {
            return m.getOrigin();
        }
        switch (side) {
            case LEFT: {
                return m.getLeft();
            }
            case RIGHT: {
                return m.getRight();
            }
        }
        throw new IllegalArgumentException("Value " + (Object)((Object)side) + " is not a valid DifferenceSource.");
    }

    public static Iterable<Diff> findAddOrDeleteContainmentDiffs(Match match) {
        EObject container = match.eContainer();
        if (container instanceof Match) {
            return Iterables.filter(((Match)container).getDifferences(), (Predicate)Predicates.and(EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE, EMFComparePredicates.ofKind(DifferenceKind.ADD, DifferenceKind.DELETE)));
        }
        return null;
    }
}

