/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.DisconnectProviderOperation;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class InternalGitTestSupport {
    private static final String GIT_BRANCH_PREFIX = "refs/heads/";
    private static final String METADATA_FOLDER = ".metadata";
    private static final int BUFFER_SIZE = 4096;
    protected Repository repository;
    protected IProject[] projects;
    protected ArrayList<Runnable> disposers;
    private IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

        public String queryOverwrite(String file) {
            return "ALL";
        }
    };

    protected static String normalizeBranch(String branch) {
        if (branch.startsWith(GIT_BRANCH_PREFIX)) {
            return branch;
        }
        return GIT_BRANCH_PREFIX + branch;
    }

    protected void createRepositoryFromPath(Class<?> clazz, String path) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        root.delete(true, (IProgressMonitor)new NullProgressMonitor());
        IPath location = root.getLocation();
        this.extractArchive(clazz, path, root);
        this.importProjects(new File(location.toString()));
        this.connectRepository(new File(location.toString()));
        IProject[] iProjectArray = this.projects = root.getProjects();
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.connect(project);
            ++n2;
        }
    }

    private void connect(IProject project) throws CoreException, InterruptedException {
        ConnectProviderOperation op = new ConnectProviderOperation(project, this.repository.getDirectory());
        op.execute(null);
    }

    private void connectRepository(File file) throws IOException {
        File gitDir = this.findGitDir(file);
        this.repository = Activator.getDefault().getRepositoryCache().lookupRepository(gitDir);
        this.disposers = new ArrayList();
    }

    private File findGitDir(File file) {
        File[] listFiles = file.listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File findGitDir;
                File child = fileArray[n2];
                if (child.isDirectory() && child.getName().equals(".git")) {
                    return child;
                }
                if (child.isDirectory() && (findGitDir = this.findGitDir(child)) != null) {
                    return findGitDir;
                }
                ++n2;
            }
        }
        return null;
    }

    private void importProjects(File file) throws InvocationTargetException, InterruptedException, CoreException {
        File[] listFiles = file.listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory() && !child.getName().equals(METADATA_FOLDER) && !child.getName().equals(".git")) {
                    this.importProjects(child);
                } else if (child.getName().equals(".project")) {
                    this.importProject(child);
                }
                ++n2;
            }
        }
    }

    private void importProject(File file) throws InvocationTargetException, InterruptedException, CoreException {
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(file.getAbsolutePath()));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        project.create(description, (IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        ImportOperation importOperation = new ImportOperation(project.getFullPath(), (Object)file.getParentFile(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, this.overwriteQuery);
        importOperation.setCreateContainerStructure(false);
        importOperation.run((IProgressMonitor)new NullProgressMonitor());
    }

    private void extractArchive(Class<?> clazz, String path, IWorkspaceRoot root) throws IOException {
        InputStream resourceAsStream = clazz.getResourceAsStream(path);
        ZipInputStream zipIn = new ZipInputStream(resourceAsStream);
        ZipEntry entry = null;
        while ((entry = zipIn.getNextEntry()) != null) {
            String filePath = root.getLocation() + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    protected void setup() throws CoreException, IOException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] unknownProjects = workspaceRoot.getProjects();
        if (unknownProjects != null && unknownProjects.length > 0) {
            IProject[] iProjectArray = unknownProjects;
            int n = unknownProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                iProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
        }
        Activator.getDefault().getRepositoryCache().clear();
        File file = new File(workspaceRoot.getLocation().toOSString());
        File[] listFiles = file.listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n3 = 0;
            while (n3 < n) {
                File child = fileArray[n3];
                if (!child.getName().equals(METADATA_FOLDER)) {
                    FileUtils.delete((File)child, (int)3);
                }
                ++n3;
            }
        }
    }

    protected void tearDown() throws CoreException, IOException {
        File file;
        File[] listFiles;
        if (this.repository != null) {
            this.repository.close();
            this.repository = null;
        }
        if (this.disposers != null) {
            for (Runnable disposer : this.disposers) {
                disposer.run();
            }
            this.disposers.clear();
        }
        Activator.getDefault().getRepositoryCache().clear();
        if (this.projects != null) {
            new DisconnectProviderOperation(Arrays.asList(this.projects)).execute(null);
            IProject[] iProjectArray = this.projects;
            int n = this.projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                iProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
        }
        if ((listFiles = (file = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString())).listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n3 = 0;
            while (n3 < n) {
                File child = fileArray[n3];
                if (!child.getName().equals(METADATA_FOLDER)) {
                    FileUtils.delete((File)child, (int)3);
                }
                ++n3;
            }
        }
    }
}

