/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.extensions.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.CoordinatesChangeItemProvider;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.DiagramChangeItemProvider;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.EdgeChangeItemProvider;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.HideItemProvider;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.NodeChangeItemProvider;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.ShowItemProvider;
import org.eclipse.emf.compare.diagram.internal.extensions.provider.SizeChangeItemProvider;
import org.eclipse.emf.compare.diagram.internal.extensions.util.ExtensionsAdapterFactory;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class ExtensionsItemProviderAdapterFactory
extends ExtensionsAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Disposable disposable = new Disposable();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected SizeChangeItemProvider sizeChangeItemProvider;

    public ExtensionsItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
        this.supportedTypes.add(IItemColorProvider.class);
        this.supportedTypes.add(IItemFontProvider.class);
    }

    public Adapter createShowAdapter() {
        return new ShowItemProvider((AdapterFactory)this);
    }

    public Adapter createHideAdapter() {
        return new HideItemProvider((AdapterFactory)this);
    }

    public Adapter createNodeChangeAdapter() {
        return new NodeChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createCoordinatesChangeAdapter() {
        return new CoordinatesChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createSizeChangeAdapter() {
        if (this.sizeChangeItemProvider == null) {
            this.sizeChangeItemProvider = new SizeChangeItemProvider((AdapterFactory)this);
        }
        return this.sizeChangeItemProvider;
    }

    public Adapter createEdgeChangeAdapter() {
        return new EdgeChangeItemProvider((AdapterFactory)this);
    }

    public Adapter createDiagramChangeAdapter() {
        return new DiagramChangeItemProvider((AdapterFactory)this);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected void associate(Adapter adapter, Notifier target) {
        super.associate(adapter, target);
        if (adapter != null) {
            this.disposable.add((Object)adapter);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        this.disposable.dispose();
    }
}

