/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOFeatureDeltaImpl
implements CDOFeatureDelta {
    public static final int NO_INDEX = -1;
    private CDOFeature feature;

    protected CDOFeatureDeltaImpl(CDOFeature feature) {
        this.feature = feature;
    }

    public CDOFeatureDeltaImpl(ExtendedDataInput in, CDOClass cdoClass) throws IOException {
        int featureID = in.readInt();
        this.feature = cdoClass.getAllFeatures()[featureID];
    }

    @Override
    public CDOFeature getFeature() {
        return this.feature;
    }

    public abstract void adjustReferences(Map<CDOIDTemp, CDOID> var1);

    public void write(ExtendedDataOutput out, CDOClass cdoClass, CDOIDProvider idProvider) throws IOException {
        out.writeInt(this.getType().ordinal());
        out.writeInt(cdoClass.getFeatureID(this.feature));
    }

    public static CDOFeatureDeltaImpl read(ExtendedDataInput in, CDOClass cdoClass) throws IOException {
        int typeOrdinal = in.readInt();
        CDOFeatureDelta.Type type = CDOFeatureDelta.Type.values()[typeOrdinal];
        switch (type) {
            case ADD: {
                return new CDOAddFeatureDeltaImpl(in, cdoClass);
            }
            case SET: {
                return new CDOSetFeatureDeltaImpl(in, cdoClass);
            }
            case LIST: {
                return new CDOListFeatureDeltaImpl(in, cdoClass);
            }
            case MOVE: {
                return new CDOMoveFeatureDeltaImpl(in, cdoClass);
            }
            case CLEAR: {
                return new CDOClearFeatureDeltaImpl(in, cdoClass);
            }
            case REMOVE: {
                return new CDORemoveFeatureDeltaImpl(in, cdoClass);
            }
            case CONTAINER: {
                return new CDOContainerFeatureDeltaImpl(in, cdoClass);
            }
            case UNSET: {
                return new CDOUnsetFeatureDeltaImpl(in, cdoClass);
            }
        }
        throw new UnsupportedOperationException("Invalid type " + typeOrdinal);
    }
}

