/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.id;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.id.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalTempImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaRangeImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.CDOIDLibraryDescriptorImpl;
import org.eclipse.emf.cdo.spi.common.id.CDOIDLongImpl;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class CDOIDUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CDOIDUtil.class);

    private CDOIDUtil() {
    }

    public static boolean isNull(CDOID id) {
        return id == null || id.isNull();
    }

    public static long getLong(CDOID id) {
        if (id == null) {
            return 0L;
        }
        switch (id.getType()) {
            case NULL: {
                return 0L;
            }
            case OBJECT: {
                if (id instanceof CDOIDLongImpl) {
                    return ((CDOIDLongImpl)id).getLongValue();
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.0"), id.getClass().getName()));
            }
            case META: {
                return ((CDOIDMeta)id).getLongValue();
            }
            case TEMP_OBJECT: 
            case TEMP_META: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.1"));
            }
            case EXTERNAL_OBJECT: 
            case EXTERNAL_TEMP_OBJECT: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.2"));
            }
        }
        throw new ImplementationError(MessageFormat.format(Messages.getString("CDOIDUtil.3"), id.getClass().getName()));
    }

    public static CDOIDTemp createTempMeta(int value) {
        return new CDOIDTempMetaImpl(value);
    }

    public static CDOIDTemp createTempObject(int value) {
        return new CDOIDTempObjectImpl(value);
    }

    public static CDOIDExternal createExternal(String uri) {
        return new CDOIDExternalImpl(uri);
    }

    public static CDOIDExternal createExternalTemp(String uri) {
        return new CDOIDExternalTempImpl(uri);
    }

    public static CDOID createLong(long value) {
        if (value == 0L) {
            return CDOID.NULL;
        }
        return new CDOIDLongImpl(value);
    }

    public static CDOID read(String uriFragment, CDOIDObjectFactory factory) {
        Object type;
        byte ordinal = Byte.valueOf(uriFragment.substring(0, 1));
        if (TRACER.isEnabled()) {
            try {
                type = CDOID.Type.values()[ordinal].toString();
                TRACER.format("Reading CDOID of type {0} ({1})", new Object[]{ordinal, type});
            }
            catch (RuntimeException ex) {
                TRACER.trace((Throwable)ex);
            }
        }
        type = CDOID.Type.values()[ordinal];
        String fragment = uriFragment.substring(2);
        switch (CDOIDUtil.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type()[((Enum)type).ordinal()]) {
            case 1: {
                return CDOID.NULL;
            }
            case 5: {
                return new CDOIDTempObjectImpl(Integer.valueOf(fragment));
            }
            case 7: {
                return new CDOIDTempMetaImpl(Integer.valueOf(fragment));
            }
            case 6: {
                return new CDOIDMetaImpl(Long.valueOf(fragment));
            }
            case 3: {
                return new CDOIDExternalImpl(fragment);
            }
            case 4: {
                return new CDOIDExternalTempImpl(fragment);
            }
            case 2: {
                CDOIDObject id = factory.createCDOIDObject(fragment);
                ((AbstractCDOID)((Object)id)).read(fragment);
                return id;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.5"), uriFragment));
    }

    public static void write(StringBuilder builder, CDOID id) {
        if (id == null) {
            id = CDOID.NULL;
        }
        CDOID.Type type = id.getType();
        int ordinal = type.ordinal();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing CDOID of type {0} ({1})", new Object[]{ordinal, type});
        }
        builder.append(ordinal);
        switch (type) {
            case NULL: 
            case OBJECT: 
            case TEMP_OBJECT: 
            case META: 
            case TEMP_META: {
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
        builder.append("/" + id.toURIFragment());
    }

    public static CDOIDMeta createMeta(long value) {
        return new CDOIDMetaImpl(value);
    }

    public static CDOIDMetaRange createMetaRange(CDOID lowerBound, int count) {
        return new CDOIDMetaRangeImpl(lowerBound, count);
    }

    public static CDOIDLibraryDescriptor readLibraryDescriptor(ExtendedDataInput in) throws IOException {
        return new CDOIDLibraryDescriptorImpl(in);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOID id, int version) {
        return new CDOIDAndVersionImpl(id, version);
    }

    public static boolean equals(CDOID id1, CDOID id2) {
        if (id1 == null) {
            id1 = CDOID.NULL;
        }
        if (id2 == null) {
            id2 = CDOID.NULL;
        }
        return ObjectUtil.equals((Object)id1, (Object)id2);
    }
}

