/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.id;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOIDLibraryDescriptorImpl
implements CDOIDLibraryDescriptor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDOIDLibraryDescriptorImpl.class);
    private String factoryName;
    private String[] libraryNames;

    public CDOIDLibraryDescriptorImpl(String factoryName, String[] libraryNames) {
        this.factoryName = factoryName;
        this.libraryNames = libraryNames == null ? new String[]{} : libraryNames;
    }

    public CDOIDLibraryDescriptorImpl(ExtendedDataInput in) throws IOException {
        this.factoryName = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read factory name: {0}", new Object[]{this.factoryName});
        }
        int size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} library names", new Object[]{size});
        }
        this.libraryNames = new String[size];
        int i = 0;
        while (i < size) {
            this.libraryNames[i] = in.readString();
            if (TRACER.isEnabled()) {
                TRACER.format("Read library name: {0}", new Object[]{this.libraryNames[i]});
            }
            ++i;
        }
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String[] getLibraryNames() {
        return this.libraryNames;
    }

    public void write(ExtendedDataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing factory name: {0}", new Object[]{this.factoryName});
        }
        out.writeString(this.factoryName);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} library names", new Object[]{this.libraryNames.length});
        }
        out.writeInt(this.libraryNames.length);
        String[] stringArray = this.libraryNames;
        int n = this.libraryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String libraryName = stringArray[n2];
            if (TRACER.isEnabled()) {
                TRACER.format("Writing library name: {0}", new Object[]{libraryName});
            }
            out.writeString(libraryName);
            ++n2;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[");
        builder.append(this.factoryName);
        if (this.libraryNames.length != 0) {
            builder.append(" -> ");
            int i = 0;
            while (i < this.libraryNames.length) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(this.libraryNames[i]);
                ++i;
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

