/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.internal.db.ServerInfo;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.net4j.util.ImplementationError;

public final class ClassServerInfo
extends ServerInfo {
    public static final int CDO_OBJECT_CLASS_DBID = -1;
    public static final int CDO_RESOURCE_CLASS_DBID = -2;
    private IClassMapping classMapping;

    private ClassServerInfo(int id) {
        super(id);
    }

    public static ClassServerInfo setDBID(CDOClass cdoClass, int id) {
        ClassServerInfo serverInfo = new ClassServerInfo(id);
        ((InternalCDOClass)cdoClass).setServerInfo((Object)serverInfo);
        return serverInfo;
    }

    public static IClassMapping getClassMapping(CDOClass cdoClass) {
        ClassServerInfo serverInfo = ClassServerInfo.getServerInfo(cdoClass);
        return serverInfo == null ? null : serverInfo.classMapping;
    }

    public static void setClassMapping(CDOClass cdoClass, IClassMapping classMapping) {
        ClassServerInfo serverInfo = ClassServerInfo.getServerInfo(cdoClass);
        if (serverInfo == null) {
            throw new ImplementationError("No serverInfo for class " + cdoClass);
        }
        serverInfo.classMapping = classMapping;
    }

    protected static ClassServerInfo getServerInfo(CDOClass cdoClass) {
        ClassServerInfo serverInfo = (ClassServerInfo)cdoClass.getServerInfo();
        if (serverInfo == null) {
            if (cdoClass.isRoot()) {
                serverInfo = ClassServerInfo.setDBID(cdoClass, -1);
            } else if (cdoClass.isResource()) {
                serverInfo = ClassServerInfo.setDBID(cdoClass, -2);
            }
        }
        return serverInfo;
    }
}

