/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HibernateStoreFactory
implements IStoreFactory {
    public String getStoreType() {
        return "hibernate";
    }

    public IHibernateStore createStore(Element storeConfig) {
        IHibernateMappingProvider mappingProvider = this.getMappingProvider(storeConfig);
        return HibernateUtil.getInstance().createStore(mappingProvider);
    }

    private IHibernateMappingProvider getMappingProvider(Element storeConfig) {
        NodeList mappingProviderConfigs = storeConfig.getElementsByTagName("mappingProvider");
        if (mappingProviderConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one mapping provider must be configured for Hibernate store");
        }
        Element mappingProviderConfig = (Element)mappingProviderConfigs.item(0);
        String mappingProviderType = mappingProviderConfig.getAttribute("type");
        IHibernateMappingProvider.Factory factory = HibernateUtil.getInstance().createMappingProviderFactory(mappingProviderType);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown mapping provider type: " + mappingProviderType);
        }
        IHibernateMappingProvider mappingProvider = factory.create(mappingProviderConfig);
        if (mappingProvider == null) {
            throw new IllegalArgumentException("No mapping provider created: " + mappingProviderType);
        }
        return mappingProvider;
    }
}

