/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTimeStampContext;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.internal.cdo.session.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOTimeStampContextImpl;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSyncRevisionsRequest
extends CDOClientRequest<Collection<CDOTimeStampContext>> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, AbstractSyncRevisionsRequest.class);
    protected Map<CDOID, CDOIDAndVersion> idAndVersions;
    protected int referenceChunk;

    public AbstractSyncRevisionsRequest(CDOClientProtocol protocol, short signalID, Map<CDOID, CDOIDAndVersion> idAndVersions, int referenceChunk) {
        super(protocol, signalID);
        this.idAndVersions = idAndVersions;
        this.referenceChunk = referenceChunk;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Synchronization " + this.idAndVersions.size() + " objects");
        }
        out.writeInt(this.referenceChunk);
        out.writeInt(this.idAndVersions.size());
        for (CDOIDAndVersion idAndVersion : this.idAndVersions.values()) {
            out.writeCDOIDAndVersion(idAndVersion);
        }
    }

    @Override
    protected Collection<CDOTimeStampContext> confirming(CDODataInput in) throws IOException {
        long revised;
        CDORevisionManagerImpl revisionManager = (CDORevisionManagerImpl)this.getSession().getRevisionManager();
        TreeMap<Long, CDOTimeStampContext> mapofContext = new TreeMap<Long, CDOTimeStampContext>();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDORevision revision = in.readCDORevision();
            revised = in.readLong();
            CDOIDAndVersion idAndVersion = this.idAndVersions.get(revision.getID());
            if (idAndVersion == null) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("SyncRevisionsRequest.2"), revision.getID()));
            }
            Set<CDOIDAndVersion> dirtyObjects = this.getMap(mapofContext, revised).getDirtyObjects();
            dirtyObjects.add(CDOIDUtil.createIDAndVersion((CDOID)idAndVersion.getID(), (int)idAndVersion.getVersion()));
            revisionManager.addCachedRevision((InternalCDORevision)revision);
            ++i;
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Synchronization received  " + size + " dirty objects");
        }
        size = in.readInt();
        i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            revised = in.readLong();
            Collection<CDOID> detachedObjects = this.getMap(mapofContext, revised).getDetachedObjects();
            detachedObjects.add(id);
            ++i;
        }
        for (CDOTimeStampContext timestampContext : mapofContext.values()) {
            Set<CDOIDAndVersion> dirtyObjects = timestampContext.getDirtyObjects();
            Collection<CDOID> detachedObjects = timestampContext.getDetachedObjects();
            dirtyObjects = Collections.unmodifiableSet(dirtyObjects);
            detachedObjects = Collections.unmodifiableCollection(detachedObjects);
            ((CDOTimeStampContextImpl)timestampContext).setDirtyObjects(dirtyObjects);
            ((CDOTimeStampContextImpl)timestampContext).setDetachedObjects(detachedObjects);
        }
        return Collections.unmodifiableCollection(mapofContext.values());
    }

    private CDOTimeStampContext getMap(Map<Long, CDOTimeStampContext> mapOfContext, long timestamp) {
        CDOTimeStampContext result = mapOfContext.get(timestamp);
        if (result == null) {
            result = new CDOTimeStampContextImpl(timestamp);
            mapOfContext.put(timestamp, result);
        }
        return result;
    }
}

