/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.Address;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.AddressList;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.DistrictUKAddress;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.ExtensionPackage;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.FirstAddressHolder;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.InternationalPrice;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.UKAddress;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.USAddress;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension.USState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionValidator
extends EObjectValidator {
    public static final ExtensionValidator INSTANCE = new ExtensionValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.teneo.samples.emf.schemaconstructs.extension";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final EValidator.PatternMatcher[][] UK_POSTCODE__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"[A-Z]{2}\\d\\s\\d[A-Z]{2}")}};

    protected EPackage getEPackage() {
        return ExtensionPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAddress((Address)value, diagnostics, context);
            }
            case 1: {
                return this.validateAddressList((AddressList)value, diagnostics, context);
            }
            case 2: {
                return this.validateDistrictUKAddress((DistrictUKAddress)value, diagnostics, context);
            }
            case 3: {
                return this.validateFirstAddressHolder((FirstAddressHolder)value, diagnostics, context);
            }
            case 4: {
                return this.validateInternationalPrice((InternationalPrice)value, diagnostics, context);
            }
            case 5: {
                return this.validateUKAddress((UKAddress)value, diagnostics, context);
            }
            case 6: {
                return this.validateUSAddress((USAddress)value, diagnostics, context);
            }
            case 7: {
                return this.validateUSState((USState)((Object)value), diagnostics, context);
            }
            case 8: {
                return this.validatePostcode((String)value, diagnostics, context);
            }
            case 9: {
                return this.validateUKPostcode((String)value, diagnostics, context);
            }
            case 10: {
                return this.validateUSStateObject((USState)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAddress(Address address, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(address, diagnostics, context);
    }

    public boolean validateAddressList(AddressList addressList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(addressList, diagnostics, context);
    }

    public boolean validateDistrictUKAddress(DistrictUKAddress districtUKAddress, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(districtUKAddress, diagnostics, context);
    }

    public boolean validateFirstAddressHolder(FirstAddressHolder firstAddressHolder, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(firstAddressHolder, diagnostics, context);
    }

    public boolean validateInternationalPrice(InternationalPrice internationalPrice, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(internationalPrice, diagnostics, context);
    }

    public boolean validateUKAddress(UKAddress ukAddress, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(ukAddress, diagnostics, context);
    }

    public boolean validateUSAddress(USAddress usAddress, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(usAddress, diagnostics, context);
    }

    public boolean validateUSState(USState usState, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePostcode(String postcode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validatePostcode_MinLength(postcode, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validatePostcode_MaxLength(postcode, diagnostics, context);
        }
        return result;
    }

    public boolean validatePostcode_MinLength(String postcode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = postcode.length();
        boolean bl = result = length >= 7;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(ExtensionPackage.Literals.POSTCODE, postcode, length, 7, diagnostics, context);
        }
        return result;
    }

    public boolean validatePostcode_MaxLength(String postcode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = postcode.length();
        boolean bl = result = length <= 7;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ExtensionPackage.Literals.POSTCODE, postcode, length, 7, diagnostics, context);
        }
        return result;
    }

    public boolean validateUKPostcode(String ukPostcode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validatePostcode_MinLength(ukPostcode, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validatePostcode_MaxLength(ukPostcode, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUKPostcode_Pattern(ukPostcode, diagnostics, context);
        }
        return result;
    }

    public boolean validateUKPostcode_Pattern(String ukPostcode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(ExtensionPackage.Literals.UK_POSTCODE, ukPostcode, UK_POSTCODE__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateUSStateObject(USState usStateObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }
}

