/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrInstance;
import agg.attribute.AttrVariableTuple;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.LoneTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.util.XMLHelper;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class VarTuple
extends LoneTuple
implements AttrVariableTuple {
    static final long serialVersionUID = 1133219076552845488L;
    protected final int FIXED_VALUE = -1;
    private Vector<Integer> signaturOrder;

    public VarTuple(AttrTupleManager manager, ContextView context, ValueTuple parent) {
        super(manager, context, parent);
        this.getContextView().setAllowVarDeclarations(true);
        this.getContextView().setAllowComplexExpr(true);
        if (this.parent != null) {
            int i;
            if (this.getSize() == 0 && this.parent.getSize() > 0) {
                i = 0;
                while (i < this.parent.getSize()) {
                    VarMember m = (VarMember)this.parent.getMemberAt(i);
                    if (m.getDeclaration().getTypeName() != null && m.getName() != null) {
                        this.declare(m.getHandler(), m.getDeclaration().getTypeName(), m.getName());
                        if (m.isSet()) {
                            ((VarMember)this.getMemberAt(m.getName())).setExpr(m.getExpr());
                            ((VarMember)this.getMemberAt(m.getName())).setExprAsText(m.getExprAsText());
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.getSize()) {
                VarMember var = (VarMember)this.getMemberAt(i);
                VarMember varp = (VarMember)this.parent.getMemberAt(var.getName());
                if (varp != null) {
                    var.setInputParameter(varp.isInputParameter());
                    var.setMark(varp.getMark());
                    var.setTransient(varp.isTransient());
                }
                ++i;
            }
            this.getContextView().setVariableContext(parent.getContextView().isVariableContext());
        }
        this.errorMsg = "";
    }

    public void updateByParent() {
        if (this.parent != null) {
            int i = 0;
            while (i < this.getSize()) {
                VarMember m = (VarMember)this.getMemberAt(i);
                if (this.parent.getMemberAt(m.getName()) == null) {
                    this.getTupleType().deleteMemberAt(m.getName());
                } else {
                    VarMember pm = (VarMember)this.parent.getMemberAt(m.getName());
                    m.setInputParameter(pm.isInputParameter());
                    if (!m.isIn) {
                        while (m.getReferenceCount() > 0) {
                            m.undoUnification();
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void propagateValueFromParent() {
        if (this.parent != null) {
            int i = 0;
            while (i < this.parent.getSize()) {
                VarMember pm = (VarMember)this.parent.getMemberAt(i);
                if (pm.isSet()) {
                    VarMember m = (VarMember)this.getMemberAt(pm.getName());
                    m.setExpr(pm.getExpr());
                    if (!m.isTransient) {
                        m.setTransient(pm.isTransient());
                    }
                }
                ++i;
            }
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.getSize()) {
            this.deleteMemberAt(i);
            ++i;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.type != null) {
            this.type.dispose();
        }
        if (this.getContextView() != null) {
            this.resetContextView(null);
        }
    }

    @Override
    protected void finalize() {
        super.finalize();
    }

    public void makeCopyOf(VarTuple tuple) {
        int i = 0;
        while (i < tuple.getSize()) {
            VarMember m = (VarMember)tuple.getMemberAt(i);
            if (m.getDeclaration().getTypeName() != null && m.getName() != null) {
                this.declare(m.getHandler(), m.getDeclaration().getTypeName(), m.getName());
                VarMember var = (VarMember)this.getMemberAt(i);
                if (m.isSet()) {
                    if (m.getExprAsText().indexOf("@") != -1) {
                        var.setExpr(m.getExpr());
                    } else {
                        var.setExprAsText(m.getExprAsText());
                    }
                }
                var.setInputParameter(m.isInputParameter());
                var.setMark(m.getMark());
                var.setTransient(m.isTransient());
            }
            ++i;
        }
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    protected ValueMember newMember(DeclMember decl) {
        if (decl == null) {
            Thread.dumpStack();
        }
        if (decl != null) {
            return new VarMember(this, decl);
        }
        return null;
    }

    @Override
    protected String getLogEntry(int index) {
        return String.valueOf(super.getLogEntry(index)) + (this.getVarMemberAt(index).isInputParameter() ? " In " : " ") + (this.getVarMemberAt(index).isOutputParameter() ? " Out " : " ");
    }

    @Override
    public VarMember getVarMemberAt(int index) {
        return (VarMember)this.getMemberAt(index);
    }

    @Override
    public VarMember getVarMemberAt(String name) {
        return (VarMember)this.getMemberAt(name);
    }

    public boolean isDeclared(String name) {
        return this.getTupleType().containsName(name);
    }

    public boolean isDeclared(String typestr, String name) {
        if (this.getTupleType().containsName(name)) {
            VarMember vm = (VarMember)this.getMemberAt(name);
            return vm.getDeclaration().getTypeName().equals(typestr);
        }
        return false;
    }

    public void declare(AttrHandler handler, String typestr, String name) {
        this.getTupleType().addMember(handler, typestr, name);
    }

    public void deleteLeafDeclaration(String name) {
        DeclTuple decl = this.getTupleType();
        if (decl.getParentInCharge(decl.getIndexForName(name)) != decl) {
            throw new AttrImplException("Can't delete a declaration which was made \nin a parent context.");
        }
        decl.deleteMemberAt(name);
    }

    public boolean isDeclared(Vector<String> varNames) {
        int i = 0;
        while (i < varNames.size()) {
            if (!this.getTupleType().containsName(varNames.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasInputParameter() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            if (this.getVarMemberAt(i).isInputParameter()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean areInputParametersSet() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            VarMember vm = this.getVarMemberAt(i);
            if (vm.isInputParameter() && !vm.isSet()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void unsetInputParameters() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            VarMember vm = this.getVarMemberAt(i);
            if (vm.isInputParameter() && vm.isSet()) {
                while (vm.getReferenceCount() > 0) {
                    vm.undoUnification();
                }
            }
            ++i;
        }
    }

    public void disableInputParameters() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            VarMember vm = this.getVarMemberAt(i);
            if (vm.isInputParameter()) {
                vm.setInputParameter(false);
            }
            ++i;
        }
    }

    public boolean areOutputParametersSet() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            VarMember vm = this.getVarMemberAt(i);
            if (vm.isOutputParameter() && !vm.isSet()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void unsetVariables() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            VarMember vm = this.getVarMemberAt(i);
            if (vm.isSet()) {
                while (vm.getReferenceCount() > 0) {
                    vm.undoUnification();
                }
            }
            ++i;
        }
    }

    public void unsetNotInputVariables() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            VarMember vm = this.getVarMemberAt(i);
            if (!vm.isInputParameter() && vm.isSet()) {
                while (vm.getReferenceCount() > 0) {
                    vm.undoUnification();
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDefinite() {
        int i = 0;
        while (i < this.getSize()) {
            VarMember m = this.getVarMemberAt(i);
            if (!m.isDefinite()) {
                DeclTuple decl = ((ValueTuple)this.getParent()).getTupleType();
                if (m.getReferenceCount() != 0) return false;
                if (decl.getIndexForName(m.getName()) == -1) return false;
                if (decl.getParentInCharge(decl.getIndexForName(m.getName())) != decl) return false;
                decl.deleteMemberAt(m.getName());
                --i;
            }
            ++i;
        }
        return true;
    }

    public Vector<String> getUndefiniteVariables() {
        Vector<String> undefVars = new Vector<String>(2);
        int i = 0;
        while (i < this.getSize()) {
            VarMember m = this.getVarMemberAt(i);
            if (!m.isDefinite()) {
                undefVars.addElement(m.getName());
            }
            ++i;
        }
        return undefVars;
    }

    @Override
    public Vector<String> getVariableNames() {
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < this.getSize()) {
            String varName;
            VarMember v = this.getVarMemberAt(i);
            if (v != null && !names.contains(varName = v.getName())) {
                names.addElement(varName);
            }
            ++i;
        }
        return names;
    }

    @Override
    public boolean compareTo(AttrInstance another) {
        VarTuple vt = (VarTuple)another;
        if (!this.type.compareTo(vt.getTupleType())) {
            return false;
        }
        int length = this.getSize();
        int i = 0;
        while (i < length) {
            VarMember v = this.getVarMemberAt(i);
            VarMember v1 = vt.getVarMemberAt(i);
            if (v.getExpr() != null || v1.getExpr() != null) {
                if (v.getExpr() == null && v1.getExpr() != null) {
                    return false;
                }
                if (v.getExpr() != null && v1.getExpr() == null) {
                    return false;
                }
                if (!v.getExpr().equals(v1.getExpr())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public String toString() {
        String s = "VarTuple  hash: " + this.hashCode() + "  [\n";
        int i = 0;
        while (i < this.getSize()) {
            VarMember v = this.getVarMemberAt(i);
            if (v != null) {
                s = s.concat(String.valueOf(this.getVarMemberAt(i).getName()) + ": " + this.getVarMemberAt(i).toString());
                s = s.concat("\n");
            }
            ++i;
        }
        s = s.concat("\n ]");
        return s;
    }

    public void showVariables() {
        System.out.println("Attr. context variables:  " + this.context.core + "     " + this.context);
        int i = 0;
        while (i < this.getSize()) {
            VarMember v = this.getVarMemberAt(i);
            if (v != null) {
                String val = v.isSet() ? v.getExprAsText() : "";
                System.out.println(String.valueOf(v.getDeclaration().getTypeName()) + " : " + v.getName() + " : " + v + " : " + v.getMark() + " : " + v.isTransient + " = " + val);
            }
            ++i;
        }
        System.out.println("================================");
    }

    public void initSignaturOrder() {
        if (this.signaturOrder == null) {
            this.signaturOrder = new Vector(5);
            int i = 0;
            while (i < this.getSize()) {
                VarMember m = (VarMember)this.getMemberAt(i);
                if (m.isInputParameter()) {
                    this.signaturOrder.add(new Integer(i));
                }
                ++i;
            }
        }
    }

    public void disposeSignaturOrder() {
        if (this.signaturOrder != null) {
            int i = 0;
            while (i < this.signaturOrder.size()) {
                VarMember m = (VarMember)this.getMemberAt(this.signaturOrder.get(i));
                if (m != null) {
                    m.setInputParameter(false);
                    m.setOutputParameter(false);
                }
                ++i;
            }
            this.signaturOrder = null;
        }
    }

    public List<Integer> getSignaturOrder() {
        return this.signaturOrder;
    }

    public void addToSignaturOrder(int indxOfVar) {
        VarMember m;
        if (this.signaturOrder != null && (m = this.getVarMemberAt(indxOfVar)) != null) {
            m.setInputParameter(true);
            int i = this.signaturOrder.indexOf(indxOfVar);
            if (i != -1) {
                this.signaturOrder.remove(i);
            }
            this.signaturOrder.add(new Integer(indxOfVar));
        }
    }

    public void removeFromSignaturOrder(int indxOfVar) {
        VarMember m;
        if (this.signaturOrder != null && (m = this.getVarMemberAt(indxOfVar)) != null) {
            m.setInputParameter(false);
            this.signaturOrder.remove((Object)indxOfVar);
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        int num = this.getSize();
        int i = 0;
        while (i < num) {
            VarMember val = this.getVarMemberAt(i);
            if (val != null && val.getDecl().getTypeName() != null && val.getName() != null && !"".equals(val.getDecl().getTypeName()) && !"".equals(val.getName())) {
                String inout;
                h.openSubTag("Parameter");
                if (val.isSet()) {
                    if (val.getExpr().isConstant()) {
                        h.addAttr("value", val.getExpr().getValue().toString());
                    } else {
                        h.addAttr("expr", val.getExpr().getString());
                    }
                }
                h.addAttr("name", val.getName());
                h.addAttr("type", val.getDecl().getTypeName());
                boolean isin = val.isInputParameter();
                boolean isout = val.isOutputParameter();
                String string = isin && isout ? "inout" : (isin ? "input" : (inout = isout ? "output" : ""));
                if (inout != "") {
                    h.addAttr("PTYPE", inout);
                }
                h.close();
            }
            ++i;
        }
        if (this.signaturOrder != null && !this.signaturOrder.isEmpty()) {
            h.openSubTag("Input");
            String str = this.signaturOrder.toString().replace("[", "").replace("]", "");
            h.addAttr("order", str);
            h.close();
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        Enumeration<Element> en = h.getEnumeration("", null, true, "Parameter");
        while (en.hasMoreElements()) {
            String typestr;
            h.peekElement(en.nextElement());
            String name = h.readAttr("name");
            if (!this.isDeclared(name) && !"".equals(typestr = h.readAttr("type"))) {
                String handlerName = JexHandler.getLabelName();
                AttrHandler handler = this.getAttrManager().getHandler(handlerName);
                this.declare(handler, typestr, name);
                VarMember var = this.getVarMemberAt(name);
                String inout = h.readAttr("PTYPE");
                boolean isin = false;
                boolean isout = false;
                if (inout.equals("inout")) {
                    isout = true;
                    isin = true;
                } else if (inout.equals("input")) {
                    isin = true;
                } else if (inout.equals("output")) {
                    isout = true;
                }
                var.setInputParameter(isin);
                var.setOutputParameter(isout);
                String value = h.readAttr("value");
                if (value != null && !value.equals("")) {
                    if (typestr.equals("String")) {
                        var.setExprAsText("\"" + value + "\"");
                    } else if (typestr.equals("Character") || typestr.equals("char")) {
                        var.setExprAsText("'" + value.charAt(0) + "'");
                    } else {
                        var.setExprAsText(value);
                    }
                    var.checkValidity();
                } else {
                    String expr = h.readAttr("expr");
                    if (expr != null && !expr.equals("")) {
                        var.setExprAsText(expr);
                        var.checkValidity();
                    }
                }
            }
            h.close();
        }
        if (h.readSubTag("Input")) {
            this.signaturOrder = new Vector(5);
            String order = h.readAttr("order");
            String[] array = order.split(", ");
            int i = 0;
            while (i < array.length) {
                this.signaturOrder.add(Integer.valueOf(array[i]));
                ++i;
            }
            h.close();
        }
    }
}

