/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.SymbolTable;
import agg.attribute.parser.javaExpr.ASTIdNotDeclaredException;
import agg.attribute.parser.javaExpr.ASTMemberException;
import agg.attribute.parser.javaExpr.ASTMissingValueException;
import agg.attribute.parser.javaExpr.ASTWrongTypeException;
import agg.attribute.parser.javaExpr.ClassResolver;
import agg.attribute.parser.javaExpr.JJTJexParserState;
import agg.attribute.parser.javaExpr.JexParser;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.ParseError;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.awt.Color;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Jex
implements ActionListener {
    static final long serialVersionUID = 1L;
    public static final int PARSE_ERROR = 0;
    public static final int IS_CONSTANT = 1;
    public static final int IS_VARIABLE = 2;
    public static final int IS_COMPLEX = 3;
    protected TextField typeTF;
    protected static JexParser parser;
    protected PrintStream out;
    protected PrintStream err;
    protected ByteArrayOutputStream redirect;
    protected PrintStream redirectOut;
    protected boolean isOutput = false;
    protected Object variableExpression;
    protected static Object refObj;

    static {
        refObj = new Object();
    }

    public static void main(String[] args) {
        Jex me = new Jex();
        SimpleNode.setClassResolver(new ClassResolver());
        Frame frame = new Frame("Jex-Test");
        me.typeTF = new TextField("", 30);
        me.typeTF.setBackground(Color.WHITE);
        me.typeTF.addActionListener(me);
        frame.add(me.typeTF);
        frame.pack();
        frame.setVisible(true);
    }

    public void fullTest(String line) {
        try {
            this.test_interpret(line, null, null);
        }
        catch (AttrHandlerException ex1) {
            System.out.println(ex1.getMessage());
            ex1.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String line = this.typeTF.getText();
        if (line.compareTo("q") == 0) {
            System.exit(0);
        }
        this.fullTest(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getExprProperty() {
        JJTJexParserState jJTJexParserState = JexParser.jjtree;
        synchronized (jJTJexParserState) {
            SimpleNode node = (SimpleNode)JexParser.jjtree.rootNode();
            int result = 3;
            if (node.isConstantExpr()) {
                result = 1;
            } else if (node.jjtGetNumChildren() == 1) {
                node = (SimpleNode)node.jjtGetChild(0);
                if (node.identifier.equals("PrimaryExpression") && node.jjtGetNumChildren() == 1) {
                    node = (SimpleNode)node.jjtGetChild(0);
                    if (node.identifier.equals("Id")) {
                        result = 2;
                    }
                }
            }
            return result;
        }
    }

    protected void newStdOutStream() {
        FileOutputStream fdOut = new FileOutputStream(FileDescriptor.out);
        System.setOut(new PrintStream(new BufferedOutputStream(fdOut, 128), true));
    }

    protected void newStdErrStream() {
        FileOutputStream fdErr = new FileOutputStream(FileDescriptor.err);
        System.setErr(new PrintStream(new BufferedOutputStream(fdErr, 128), true));
    }

    protected void antiRedirect() {
        this.newStdOutStream();
        this.newStdErrStream();
    }

    protected void swapPrintStream() {
        PrintStream swapOut = System.out;
        PrintStream swapErr = System.err;
        System.setOut(this.out);
        System.setErr(this.err);
        this.out = swapOut;
        this.err = swapErr;
    }

    protected void redirectToString() {
        this.out = System.out;
        this.err = System.err;
        this.redirect = new ByteArrayOutputStream();
        this.redirectOut = new PrintStream(this.redirect);
        System.setOut(this.redirectOut);
        System.setErr(this.redirectOut);
    }

    protected void restoreOutputStream() {
        if (this.redirect != null && this.redirectOut != null) {
            System.setOut(this.out);
            System.setErr(this.err);
            if (this.isOutput) {
                System.out.println(this.redirect.toString());
            }
            this.redirect = null;
            this.redirectOut = null;
        }
    }

    public static String addMessage(Exception ex) {
        String msg = ex.getMessage();
        if (msg == null || msg.equals("null")) {
            return "";
        }
        return "\n  (" + msg + ")";
    }

    public void parseOutputOn() {
        this.isOutput = true;
    }

    public void parseOutputOff() {
        this.isOutput = false;
    }

    public int parse(String text) throws AttrHandlerException {
        try {
            return this.parse_(text);
        }
        catch (Exception ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(String.valueOf(this.redirect.toString()) + Jex.addMessage(ex1));
            }
            throw new AttrHandlerException(Jex.addMessage(ex1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertyText(int code) {
        Jex jex = this;
        synchronized (jex) {
            block8: {
                block7: {
                    block6: {
                        if (code != 1) break block6;
                        return "Constant expression";
                    }
                    if (code != 2) break block7;
                    return "Variable";
                }
                if (code != 3) break block8;
                return "Complex expression";
            }
            return "Parse error";
        }
    }

    protected int parse_(String text) throws ParseError {
        int result = 0;
        String line = String.valueOf(text) + " ";
        byte[] bytes = line.getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        JJTJexParserState jJTJexParserState = JexParser.jjtree;
        synchronized (jJTJexParserState) {
            JexParser.ReInit(stream);
            JexParser.jjtree.reset();
            SimpleNode.top = -1;
            SimpleNode.stack.clear();
            JexParser.CompilationUnit();
            JexParser.jjtree.rootNode().dump("  ");
            result = this.getExprProperty();
            return result;
        }
    }

    public void check(Node ast, Class<?> type, SymbolTable symtab) throws AttrHandlerException {
        try {
            Class<?> resultType;
            boolean assignable;
            SimpleNode.setSymbolTable(symtab);
            try {
                ast.checkContext();
                this.variableExpression = ast;
            }
            catch (ASTIdNotDeclaredException ex1) {
                throw ex1;
            }
            catch (ASTWrongTypeException ex2) {
                throw ex2;
            }
            catch (ASTMemberException ex3) {
                throw ex3;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
            if (type != null && type != Void.TYPE && !(assignable = this.isAssignable(type, resultType = ((SimpleNode)ast).getNodeClass()))) {
                new ASTWrongTypeException();
            }
        }
        catch (Exception ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(this.redirect.toString());
            }
            throw new AttrHandlerException(ex1.getMessage());
        }
    }

    public void check(String text, Class<?> type, SymbolTable symtab) throws AttrHandlerException {
        try {
            this.check_(text, type, symtab);
        }
        catch (Exception ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(this.redirect.toString());
            }
            throw new AttrHandlerException(ex1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check_(String text, Class<?> type, SymbolTable symtab) throws ParseError {
        this.parse_(text);
        SimpleNode.setSymbolTable(symtab);
        JJTJexParserState jJTJexParserState = JexParser.jjtree;
        synchronized (jJTJexParserState) {
            Class<?> resultType;
            try {
                JexParser.jjtree.rootNode().checkContext();
                JexParser.jjtree.rootNode().dump("  ");
            }
            catch (ASTIdNotDeclaredException ex1) {
                throw new ASTIdNotDeclaredException("Variable \"" + ex1.getMessage() + "\" is not declared");
            }
            catch (ASTWrongTypeException ex2) {
                throw new ASTWrongTypeException("Wrong expression type.  Required signature: " + ex2.getExpected() + "   Encountered: " + ex2.getFound());
            }
            catch (ASTMemberException ex3) {
                throw new ASTMemberException("Member Exception:  " + ex3.getMessage());
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception:  " + ex.getMessage());
            }
            if (type != null && type != Void.TYPE && !this.isAssignable(type, resultType = ((SimpleNode)JexParser.jjtree.rootNode()).getNodeClass())) {
                throw new ASTWrongTypeException("Wrong expression type.  Required: " + type.getName() + "  Found: " + resultType.getName());
            }
        }
    }

    protected boolean isAssignable(Class<?> to, Class<?> from) {
        if (to.isPrimitive() || from.isPrimitive()) {
            if (to == Byte.TYPE || to == Short.TYPE || to == Integer.TYPE || to == Long.TYPE) {
                return from == Byte.TYPE || from == Short.TYPE || from == Integer.TYPE || from == Long.TYPE;
            }
            if (to == Float.TYPE || to == Double.TYPE) {
                return from == Float.TYPE || from == Double.TYPE;
            }
            return to == from;
        }
        return to.isAssignableFrom(from) || from.isInstance(refObj);
    }

    protected Object test_interpret(String text, Class<?> type, SymbolTable symtab) throws AttrHandlerException {
        Object result;
        try {
            result = this.interpret_(text, type, symtab);
        }
        catch (ParseError ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(String.valueOf(this.redirect.toString()) + Jex.addMessage(ex1));
            }
            throw new AttrHandlerException(Jex.addMessage(ex1));
        }
        return result;
    }

    public Object interpret(Node ast, Class<?> type, SymbolTable symtab) throws AttrHandlerException {
        try {
            Object result = null;
            this.check(ast, type, symtab);
            try {
                ast.interpret();
                result = ast.getRootResult();
                return result;
            }
            catch (ASTIdNotDeclaredException ex1) {
                throw ex1;
            }
            catch (ASTMissingValueException ex2) {
                if (ast.getString().indexOf("==null") != -1) {
                    result = new Boolean(true);
                    return result;
                }
                throw ex2;
            }
            catch (ASTMemberException ex3) {
                throw ex3;
            }
            catch (Exception ex) {
                throw new AttrHandlerException("AttrHandlerException  : " + ex.getMessage());
            }
        }
        catch (Exception ex1) {
            throw new AttrHandlerException("AttrHandlerException  : " + ex1.getMessage());
        }
    }

    public Object interpret(String text, Class<?> type, SymbolTable symtab) throws AttrHandlerException {
        try {
            return this.interpret_(text, type, symtab);
        }
        catch (Exception ex1) {
            if (this.redirect != null) {
                throw new AttrHandlerException(this.redirect.toString());
            }
            throw new AttrHandlerException(ex1.getMessage());
        }
    }

    public Object interpret_(String text, Class<?> type, SymbolTable symtab) throws ParseError {
        JJTJexParserState jJTJexParserState = JexParser.jjtree;
        synchronized (jJTJexParserState) {
            if (JexParser.jjtree.rootNode() != null) {
                JexParser.jjtree.rootNode().dump("");
            }
            this.check_(text, type, symtab);
            try {
                JexParser.jjtree.rootNode().interpret();
                Object result = JexParser.jjtree.rootNode().getRootResult();
                JexParser.jjtree.rootNode().dump("");
                return result;
            }
            catch (ASTIdNotDeclaredException ex1) {
                throw ex1;
            }
            catch (ASTMissingValueException ex2) {
                throw ex2;
            }
            catch (ASTMemberException ex3) {
                throw ex3;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    public void rewrite(Node ast, Class<?> type, SymbolTable symtab) throws AttrHandlerException {
        this.check(ast, type, symtab);
        ast.rewrite();
        if (ast.getError().length() != 0) {
            throw new AttrHandlerException(ast.getError());
        }
    }

    public Node getAST() {
        return JexParser.jjtree.rootNode();
    }

    public Object getVariableExpression() {
        return this.variableExpression;
    }
}

