/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.editor.impl.TypeReprData;
import agg.util.Pair;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraph;
import java.awt.Point;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.StateEditable;

public class NodeReprData
implements StateEditable {
    protected int typeHashCode;
    protected TypeReprData typeRepresentation;
    protected Vector<String> parents;
    protected Vector<String> children;
    protected boolean elemOfTG;
    protected Hashtable<String, Pair<String, String>> attributes;
    protected Point location;
    protected String nodeHC;
    protected int nodeHashCode;
    protected int key = this.hashCode();
    protected boolean frozen;
    protected boolean frozenAsDefault;

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        state.put(this.key, this);
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        NodeReprData data = (NodeReprData)state.get(this.key);
        state.remove(this.key);
        if (data != null) {
            this.typeHashCode = data.typeHashCode;
            this.typeRepresentation = data.typeRepresentation;
            this.parents = data.parents;
            this.children = data.children;
            this.elemOfTG = data.elemOfTG;
            this.attributes = data.attributes;
            this.location = data.location;
            this.nodeHC = data.nodeHC;
            this.frozen = data.frozen;
            this.frozenAsDefault = data.frozenAsDefault;
        }
    }

    protected NodeReprData(EdNode n) {
        int i;
        if (n.getBasisNode() == null) {
            return;
        }
        this.key = this.hashCode();
        this.nodeHashCode = n.hashCode();
        this.typeHashCode = n.getType().hashCode();
        this.elemOfTG = n.isElementOfTypeGraph();
        this.parents = new Vector(5, 5);
        this.children = new Vector(5, 5);
        this.typeRepresentation = n.isElementOfTypeGraph() ? new TypeReprData(n) : new TypeReprData(n.getType());
        this.nodeHC = n.getContextUsage();
        if (n.getContextUsage().indexOf(String.valueOf(n.hashCode())) == -1) {
            this.nodeHC = String.valueOf(String.valueOf(n.hashCode())) + ":" + n.getContextUsage();
        }
        this.attributes = new Hashtable();
        if (n.getBasisObject().getAttribute() != null) {
            ValueTuple vt = (ValueTuple)n.getBasisObject().getAttribute();
            i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(i);
                if (vm.getName() != null) {
                    Pair<String, String> valPair = new Pair<String, String>(vm.getDeclaration().getTypeName(), "NULL");
                    if (vm.getExpr() != null) {
                        valPair.second = vm.getExprAsText();
                    }
                    this.attributes.put(vm.getName(), valPair);
                }
                ++i;
            }
        }
        this.location = new Point(n.getX(), n.getY());
        if (n.isElementOfTypeGraph()) {
            Type btype = n.getType().getBasisType();
            i = 0;
            while (i < btype.getParents().size()) {
                this.parents.add(btype.getParents().get(i).getName());
                ++i;
            }
            i = 0;
            while (i < btype.getChildren().size()) {
                this.children.add(btype.getChildren().get(i).getName());
                ++i;
            }
        }
        this.frozen = n.getLNode().isFrozen();
        this.frozenAsDefault = n.getLNode().isFrozenByDefault();
    }

    protected TypeReprData getNodeTypeReprData() {
        return this.typeRepresentation;
    }

    protected Vector<String> getParentName() {
        return this.parents;
    }

    protected Vector<String> getChildName() {
        return this.children;
    }

    protected void restoreNodeFromNodeRepr(EdNode n) {
        if (this.elemOfTG != n.isElementOfTypeGraph()) {
            return;
        }
        this.typeRepresentation.restoreTypeFromTypeRepr(n.getType());
        n.setContextUsage(this.nodeHC);
        if (n.isElementOfTypeGraph()) {
            this.restoreParentsAndChildren(n);
            this.restoreMultiplicity(n, this.typeRepresentation);
        }
        if (!this.attributes.isEmpty() && n.getBasisObject().getAttribute() != null) {
            Hashtable<String, Pair<String, String>> attrs = new Hashtable<String, Pair<String, String>>();
            attrs.putAll(this.attributes);
            this.restoreAttributes(attrs, n);
        }
        n.setX(this.location.x);
        n.setY(this.location.y);
        n.getLNode().setFrozen(this.frozen);
        n.getLNode().setFrozenByDefault(this.frozenAsDefault);
    }

    private EdType findNodeType(EdGraph g, int typeHC) {
        Vector<EdType> nodeTypes = g.getTypeSet().getNodeTypes();
        int i = 0;
        while (i < nodeTypes.size()) {
            EdType t = nodeTypes.get(i);
            if (t.hashCode() == typeHC) {
                return t;
            }
            if (t.getContextUsage().indexOf(String.valueOf(this.typeRepresentation.getTypeHashCode())) >= 0) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private void restoreParentsAndChildren(EdNode n) {
        if (n.getBasisNode().getContext().isTypeGraph()) {
            TypeGraph tg = (TypeGraph)n.getBasisNode().getContext();
            Type myType = n.getBasisNode().getType();
            if (this.parents.isEmpty()) {
                int lastTypeGraphCheck = tg.getTypeSet().getLevelOfTypeGraphCheck();
                tg.getTypeSet().setLevelOfTypeGraphCheck(0);
                Vector<Type> pars = myType.getParents();
                int i = 0;
                while (i < pars.size()) {
                    Type parType = pars.get(i);
                    tg.getTypeSet().removeInheritanceRelation(myType, parType);
                    ++i;
                }
                tg.getTypeSet().setLevelOfTypeGraphCheck(lastTypeGraphCheck);
            } else {
                Vector<Type> pars = myType.getParents();
                int i = 0;
                while (i < pars.size()) {
                    Type parType = pars.get(i);
                    if (!this.parents.contains(parType.getName())) {
                        tg.getTypeSet().removeInheritanceRelation(myType, parType);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.parents.size()) {
                    List<Node> vec;
                    String pn = this.parents.get(i);
                    Type t = tg.getTypeSet().getTypeByName(pn);
                    if (t != myType && (vec = tg.getNodes(t)) != null) {
                        int j = 0;
                        while (j < vec.size()) {
                            Node parNode = vec.get(j);
                            if (parNode.getType().getName().equals(pn)) {
                                tg.getTypeSet().addInheritanceRelation(myType, parNode.getType());
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < this.children.size()) {
                List<Node> vec;
                String cn = this.children.get(i);
                Type t = tg.getTypeSet().getTypeByName(cn);
                if (t != myType && (vec = tg.getNodes(t)) != null) {
                    int j = 0;
                    while (j < vec.size()) {
                        Node childNode = vec.get(j);
                        if (childNode.getType().getName().equals(cn)) {
                            tg.getTypeSet().addInheritanceRelation(childNode.getType(), myType);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void restoreMultiplicity(EdNode n, TypeReprData typedata) {
        n.getBasisNode().getType().setSourceMin(typedata.srcMinMultiplicity);
        n.getBasisNode().getType().setSourceMax(typedata.srcMaxMultiplicity);
    }

    private EdType findNodeType(EdGraph g, EdType tmpType) {
        EdType t = tmpType;
        Vector<EdType> nodeTypes = g.getTypeSet().getNodeTypes();
        int i = 0;
        while (i < nodeTypes.size()) {
            EdType ti = nodeTypes.get(i);
            if (ti == t) {
                return t;
            }
            if (ti.getContextUsage().indexOf(String.valueOf(this.typeRepresentation.getTypeHashCode())) >= 0) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    protected EdNode createNodeFromNodeRepr(EdGraph g) {
        EdType type = this.findNodeType(g, this.typeRepresentation.getTypeHashCode());
        if (type == null) {
            type = this.typeRepresentation.createTypeFromTypeRepr();
            type = this.findNodeType(g, type);
        }
        if (type == null) {
            return null;
        }
        if (this.elemOfTG != g.getBasisGraph().isTypeGraph()) {
            return null;
        }
        EdNode n = null;
        try {
            Node basis = g.getBasisGraph().createNode(type.getBasisType());
            n = g.addNode(basis, type);
            n.addContextUsage(this.nodeHC);
            if (n.isElementOfTypeGraph()) {
                this.restoreParentsAndChildren(n);
                this.restoreMultiplicity(n, this.typeRepresentation);
            }
            this.refreshAttributes(n);
            n.setX(this.location.x);
            n.setY(this.location.y);
            n.getLNode().setFrozen(this.frozen);
            n.getLNode().setFrozenByDefault(this.frozenAsDefault);
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        return n;
    }

    private void refreshAttributes(EdNode n) {
        if (!this.attributes.isEmpty()) {
            if (n.getBasisObject().getAttribute() == null) {
                n.getBasisObject().createAttributeInstance();
            }
            Hashtable<String, Pair<String, String>> attrs = new Hashtable<String, Pair<String, String>>();
            attrs.putAll(this.attributes);
            this.restoreAttributes(attrs, n);
        }
    }

    private void restoreAttributes(Hashtable<String, Pair<String, String>> attrs, EdNode n) {
        ValueTuple vt = (ValueTuple)n.getBasisObject().getAttribute();
        int i = 0;
        while (i < vt.getNumberOfEntries()) {
            ValueMember vm = vt.getValueMemberAt(i);
            Pair<String, String> valPair = attrs.get(vm.getName());
            if (valPair != null && !valPair.isEmpty()) {
                String expr = (String)valPair.second;
                if (!n.isElementOfTypeGraph() && expr != null) {
                    if (vm.getExpr() == null) {
                        if (!expr.equals("NULL")) {
                            vm.setExprAsText(expr);
                            vm.checkValidity();
                        }
                    } else if (expr.equals("NULL")) {
                        vm.setExpr(null);
                    } else if (!vm.getExprAsText().equals(expr)) {
                        vm.setExprAsText(expr);
                        vm.checkValidity();
                    }
                }
                attrs.remove(vm.getName());
            }
            ++i;
        }
    }
}

