/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.gui.editor.GraGraEditor;
import agg.gui.editor.GraphEditorMouseAdapter;
import agg.gui.editor.GraphPanel;
import agg.gui.popupmenu.EditPopupMenu;
import agg.gui.popupmenu.EditSelPopupMenu;
import agg.gui.popupmenu.ModePopupMenu;
import agg.gui.saveload.GraphicsExportJPEG;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GraphEditor
extends JPanel {
    private final GraphEditorMouseAdapter mouseAdapter;
    protected final JFrame applFrame;
    int prefW = 500;
    int prefH = 200;
    private final GraGraEditor gragraEditor;
    protected GraphPanel graphPanel;
    private boolean graphAttrsVisible = true;
    private boolean typeGraphAttrsVisible = true;
    private final JLabel title;
    private String titleKind = " ";
    private String graphName;
    private String gragraName;
    private EdGraGra eGra;
    private EdGraph eGraph;
    private EdGraph sourceOfCopy;
    private String msg = "";
    private ModePopupMenu modePopupMenu;
    private EditPopupMenu editPopupMenu;
    private EditSelPopupMenu editSelPopupMenu;
    private boolean doNotShowPopupMenu;
    private boolean isEmpty;
    protected GraphicsExportJPEG exportJPEG;
    private boolean staticNodePositionForGraphLayouter;
    private boolean straightenArcs;
    private final JButton exportJPEGButton;
    private final JPanel buttonPanel;
    private final JPanel titlePanel;

    public GraphEditor() {
        this((GraGraEditor)null);
    }

    public GraphEditor(GraGraEditor anEditor) {
        super(new BorderLayout());
        this.setBackground(Color.white);
        this.setForeground(Color.WHITE);
        this.mouseAdapter = new GraphEditorMouseAdapter(this);
        this.graphName = "";
        this.gragraName = "";
        this.graphPanel = new GraphPanel(this);
        this.graphPanel.getCanvas().addMouseListener(this.mouseAdapter);
        this.title = new JLabel(this.titleKind);
        this.buttonPanel = new JPanel();
        this.exportJPEGButton = this.createExportJPEGButton();
        if (this.exportJPEGButton != null) {
            this.buttonPanel.add(this.exportJPEGButton);
        }
        this.titlePanel = new JPanel(new BorderLayout());
        this.titlePanel.add((Component)this.title, "West");
        this.titlePanel.add((Component)this.buttonPanel, "East");
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.graphPanel, "Center");
        this.gragraEditor = anEditor;
        this.applFrame = this.gragraEditor != null ? anEditor.getParentFrame() : null;
    }

    public JFrame getApplFrame() {
        return this.applFrame;
    }

    public void setCursorOfApplFrame(Cursor cursor) {
        if (this.applFrame != null) {
            this.applFrame.setCursor(cursor);
        }
    }

    public void addButton(JButton btn) {
        this.buttonPanel.removeAll();
        if (btn != null) {
            this.buttonPanel.add(btn);
        }
    }

    public void removeTitlePanel() {
        this.remove(this.titlePanel);
    }

    public void allowToShowPopupMenu(boolean b) {
        this.doNotShowPopupMenu = !b;
    }

    public boolean isPopupMenuAllowed() {
        return !this.doNotShowPopupMenu;
    }

    private JButton createExportJPEGButton() {
        URL url = ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/print.gif");
        if (url != null) {
            ImageIcon image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/print.gif"));
            JButton b = new JButton(image);
            b.setToolTipText("Export Graph JPEG");
            b.setMargin(new Insets(-5, 0, -5, 0));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GraphEditor.this.exportJPEG != null && !GraphEditor.this.exportJPEG.save(GraphEditor.this.graphPanel.getCanvas())) {
                        JOptionPane.showMessageDialog(GraphEditor.this.applFrame, "Cannot export to JPEG.\nThere are problems with the Class \n    com.sun.image.codec.jpeg.JPEGImageEncoder \nand the currently used JAVA 1.6 version.", "Expost failed", 0);
                    }
                }
            });
            b.setEnabled(false);
            return b;
        }
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.prefW, this.prefH);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.prefW = preferredSize.width;
        this.prefH = preferredSize.height;
    }

    public void setTitle(String str) {
        this.graphName = "";
        this.gragraName = "";
        this.title.setText(" " + str);
    }

    public void setTitle(String str1, String str2) {
        if (!str1.equals("") && !str2.equals("")) {
            this.graphName = str1;
            this.gragraName = str2;
            this.title.setText(String.valueOf(this.titleKind) + this.graphName + "  of  " + this.gragraName);
        } else if (!str1.equals("") && str2.equals("")) {
            this.graphName = str1;
            if (!this.gragraName.equals("")) {
                this.title.setText(String.valueOf(this.titleKind) + this.graphName + "  of  " + this.gragraName);
            } else {
                this.title.setText(String.valueOf(this.titleKind) + this.graphName);
            }
        } else if (str1.equals("") && !str2.equals("")) {
            this.gragraName = str2;
            if (!this.graphName.equals("")) {
                this.title.setText(String.valueOf(this.titleKind) + this.graphName + "  of  " + this.gragraName);
            } else {
                this.title.setText(String.valueOf(this.titleKind) + this.gragraName);
            }
        } else if (str1.equals("") && str2.equals("")) {
            this.graphName = str1;
            this.gragraName = str2;
            this.title.setText(this.titleKind);
        }
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public GraphPanel getPanelOfLocationOnScreen(Point p) {
        if (p == null) {
            return null;
        }
        Point p2 = new Point(20, 20);
        p2.x = p.x - this.graphPanel.getLocationOnScreen().x;
        p2.y = p.y - this.graphPanel.getLocationOnScreen().y;
        if (this.graphPanel.contains(p2)) {
            return this.graphPanel;
        }
        return null;
    }

    public EdGraph getGraph() {
        return this.eGraph;
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public GraGraEditor getGraGraEditor() {
        return this.gragraEditor;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String str) {
        this.msg = str;
    }

    public boolean hasGraph() {
        return this.eGraph != null;
    }

    public void setGraph(EdGraph eg) {
        this.eGraph = eg;
        this.titleKind = " ";
        if (this.eGraph == null) {
            this.setTitle("    ");
            this.graphPanel.setGraph(null);
            if (this.exportJPEGButton != null) {
                this.exportJPEGButton.setEnabled(false);
            }
            this.eGra = null;
            this.isEmpty = true;
            return;
        }
        this.isEmpty = false;
        this.eGra = this.eGraph.getGraGra();
        if (this.eGra != null) {
            this.setTitle(this.eGraph.getBasisGraph().getName(), this.eGra.getName());
        } else {
            this.setTitle(this.eGraph.getBasisGraph().getName(), "");
        }
        if (!this.eGraph.isTypeGraph()) {
            this.graphPanel.getCanvas().setAttributeVisible(this.graphAttrsVisible);
            this.eGraph.setStaticNodePosition(this.staticNodePositionForGraphLayouter);
        } else {
            this.graphPanel.getCanvas().setAttributeVisible(this.typeGraphAttrsVisible);
        }
        this.graphPanel.setGraph(this.eGraph, true);
        this.eGraph.setStaticNodePosition(this.staticNodePositionForGraphLayouter);
        this.straightenArcs = this.eGraph.isStraightenArcsEnabled();
        if (this.exportJPEG != null && this.exportJPEGButton != null) {
            this.exportJPEGButton.setEnabled(true);
        }
    }

    public void setGraphAttributeVisible(boolean vis) {
        this.graphAttrsVisible = vis;
        if (this.getGraph() == null || !this.getGraph().isTypeGraph()) {
            this.graphPanel.getCanvas().setAttributeVisible(this.graphAttrsVisible);
            this.graphPanel.updateGraphics();
        }
    }

    public void setTypeGraphAttributeVisible(boolean vis) {
        this.typeGraphAttrsVisible = vis;
        if (this.getGraph() != null && this.getGraph().isTypeGraph()) {
            this.graphPanel.getCanvas().setAttributeVisible(this.typeGraphAttrsVisible);
            this.graphPanel.updateGraphics();
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    public void clear() {
        this.setGraph(null);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasOneSelection() {
        if (this.eGraph == null) {
            return false;
        }
        return this.graphPanel.getGraph().hasOneSelection();
    }

    public boolean hasSelection() {
        return this.eGraph != null && this.eGraph.hasSelection();
    }

    public void updateGraphics() {
        this.graphPanel.updateGraphics();
    }

    public void updateGraphics(boolean graphDimensionCheck) {
        this.graphPanel.updateGraphics(graphDimensionCheck);
    }

    public void setModePopupMenu(ModePopupMenu pm) {
        this.modePopupMenu = pm;
    }

    public void setEditPopupMenu(EditPopupMenu pm) {
        this.editPopupMenu = pm;
    }

    public void setEditSelPopupMenu(EditSelPopupMenu pm) {
        this.editSelPopupMenu = pm;
    }

    public void setEditMode(int mode) {
        switch (mode) {
            case 11: {
                this.drawModeProc();
                break;
            }
            case 12: {
                this.selectModeProc();
                break;
            }
            case 13: {
                this.moveModeProc();
                break;
            }
            case 114: {
                this.attributesModeProc();
                break;
            }
            case 42: {
                this.matchDefModeProc();
                break;
            }
            case 15: {
                this.duplicateModeProc();
                break;
            }
            case 152: {
                this.pasteModeProc();
                break;
            }
            case 115: {
                this.mapModeProc();
                break;
            }
            case 116: {
                this.unmapModeProc();
                break;
            }
            case 1201: {
                this.setParentModeProc();
                break;
            }
            case 1202: {
                this.unsetParentModeProc();
                break;
            }
            case 117: {
                this.mapselModeProc();
                break;
            }
            case 118: {
                this.unmapselModeProc();
                break;
            }
            case 9: {
                this.viewModeProc();
                break;
            }
        }
    }

    public int getMode() {
        return this.graphPanel.getEditMode();
    }

    public void setEditCursor(Cursor cur) {
        this.graphPanel.setEditCursor(cur);
    }

    public void drawModeProc() {
        this.graphPanel.setEditMode(11);
        this.graphPanel.setEditCursor(new Cursor(0));
        this.msg = "Click on the background to get a node / on a source node and a target node to get an edge.";
    }

    private void selectModeProc() {
        if (this.graphPanel.getEditMode() == 12) {
            return;
        }
        this.graphPanel.setEditMode(12);
        this.graphPanel.setEditCursor(new Cursor(12));
        this.msg = "Click on an object to select it.";
    }

    private void moveModeProc() {
        if (this.graphPanel.getEditMode() == 13) {
            return;
        }
        this.graphPanel.setEditMode(13);
        this.graphPanel.setEditCursor(new Cursor(13));
        this.msg = "Press and drag the button when the cursor points to an object.";
    }

    private void attributesModeProc() {
        if (this.graphPanel.getEditMode() == 114) {
            return;
        }
        this.graphPanel.setEditMode(114);
        this.graphPanel.setEditCursor(new Cursor(0));
        this.msg = "Click on an object to activate the attribute editor.";
    }

    private void matchDefModeProc() {
        this.graphPanel.setEditMode(42);
        this.graphPanel.setEditCursor(new Cursor(12));
    }

    private void mapModeProc() {
        this.graphPanel.setEditMode(115);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void unmapModeProc() {
        this.graphPanel.setEditMode(116);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void setParentModeProc() {
        this.graphPanel.setEditMode(1201);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void unsetParentModeProc() {
        this.graphPanel.setEditMode(1202);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void mapselModeProc() {
        if (this.graphPanel.getEditMode() == 117) {
            return;
        }
        this.graphPanel.setEditMode(117);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void unmapselModeProc() {
        if (this.graphPanel.getEditMode() == 118) {
            return;
        }
        this.graphPanel.setEditMode(118);
        this.graphPanel.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void duplicateModeProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.setLastEditMode(this.graphPanel.getEditMode());
        this.graphPanel.setLastEditCursor(this.graphPanel.getEditCursor());
        this.graphPanel.setEditMode(15);
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
        this.msg = "To place a copy click on the background of the panel.";
    }

    private void pasteModeProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.setEditMode(152);
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
        this.msg = "To place a copy click on the background of the panel.";
    }

    private void viewModeProc() {
        this.graphPanel.setEditMode(9);
    }

    public boolean deleteProc() {
        if (this.eGraph == null || this.graphPanel.getEditMode() == 9) {
            return false;
        }
        if (this.hasSelection()) {
            this.graphPanel.deleteSelected();
            this.graphPanel.updateGraphicsAfterDelete();
            return true;
        }
        return false;
    }

    public void copyProc() {
        if (this.eGraph == null || this.graphPanel.getEditMode() == 9) {
            return;
        }
        if (!this.hasSelection()) {
            this.msg = "Copy -> There isn't any object selected.";
            return;
        }
        this.graphPanel.setLastEditMode(this.graphPanel.getEditMode());
        this.msg = "";
        this.setEditMode(15);
    }

    public void selectAllProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.selectAll();
    }

    public void selectNodeTypeProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.selectNodesOfSelectedNodeType();
    }

    public void selectArcTypeProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.selectArcsOfSelectedArcType();
    }

    public void deselectAllProc() {
        if (this.eGraph == null) {
            return;
        }
        this.graphPanel.deselectAll();
    }

    public void setStraightenArcs(boolean b) {
        this.straightenArcs = b;
        if (this.eGraph != null && !this.eGraph.isTypeGraph()) {
            if (b && this.eGraph.isStraightenArcsEnabled()) {
                this.eGraph.setStraightenArcs(false);
            }
            this.eGraph.setStraightenArcs(this.straightenArcs);
        }
    }

    public void straightenArcsProc() {
        if (this.eGraph != null) {
            this.graphPanel.straightenSelectedArcs();
        }
    }

    public void setGraphToCopy(EdGraph g) {
        if (this.eGraph != null) {
            this.eGraph.setGraphToCopy(g);
        }
    }

    public EdGraph getSelectedAsGraph() {
        if (this.eGraph != null) {
            this.sourceOfCopy = this.eGraph;
            return this.eGraph.getSelectedAsGraph();
        }
        return null;
    }

    public void setSourceOfCopy(EdGraph g) {
        this.sourceOfCopy = g;
    }

    public EdGraph getSourceOfCopy() {
        return this.sourceOfCopy;
    }

    public void enableStaticNodePositionForGraphLayouter(boolean enable) {
        this.staticNodePositionForGraphLayouter = enable;
        if (this.eGraph != null && !this.eGraph.isTypeGraph()) {
            this.eGraph.setStaticNodePosition(enable);
        }
    }

    public void showPopupMenu(MouseEvent e) {
        if (e.getSource() == this.graphPanel.getCanvas() && e.getX() > 0 && e.getY() > 0) {
            if (this.editPopupMenu != null) {
                this.editPopupMenu.setEditor(this);
                this.editPopupMenu.setParentFrame(this.applFrame);
            }
            if (this.editSelPopupMenu != null) {
                this.editSelPopupMenu.setEditor(this);
                this.editSelPopupMenu.setParentFrame(this.applFrame);
            }
            if (this.modePopupMenu != null && this.modePopupMenu.invoked(this, this.graphPanel, e.getX(), e.getY())) {
                this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (this.editPopupMenu != null && this.editPopupMenu.invoked(this.graphPanel, e.getX(), e.getY())) {
                this.editPopupMenu.setMapEnabled(false);
                this.editPopupMenu.setUnmapEnabled(true);
                this.editPopupMenu.showMe(e.getComponent(), e.getX(), e.getY());
            } else if (this.editSelPopupMenu != null && this.editSelPopupMenu.invoked(this.graphPanel, e.getX(), e.getY())) {
                this.editSelPopupMenu.setMapEnabled(false);
                this.editSelPopupMenu.setUnmapEnabled(true);
                this.editSelPopupMenu.showMe(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

