/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.gui.AGGAppl;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NACPopupMenu
extends JPopupMenu {
    GraGraTreeView treeView;
    TreePath path;
    EdNAC nac;
    JMenuItem disable;

    public NACPopupMenu(GraGraTreeView tree) {
        super("NAC");
        this.treeView = tree;
        JMenuItem mi = this.add(new JMenuItem("Make due to RHS "));
        mi.setActionCommand("makeFromRHS");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NACPopupMenu.this.makeCopyFromRHS();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Copy           "));
        mi.setActionCommand("copyNAC");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NACPopupMenu.this.copy();
            }
        });
        mi = this.add(new JMenuItem("Convert to GAC"));
        mi.setActionCommand("copyToGAC");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NACPopupMenu.this.convertToGAC();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Delete           Delete"));
        mi.setActionCommand("deleteNAC");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.disable = new JCheckBoxMenuItem("disabled");
        this.disable.setActionCommand("disableNAC");
        this.disable.addActionListener(this.treeView.getActionAdapter());
        this.add(this.disable);
        this.addSeparator();
        mi = this.add(new JMenuItem("Textual Comments"));
        mi.setActionCommand("commentNAC");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        int pl;
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && ((pl = this.treeView.getTree().getPathForLocation(x, y).getPath().length) == 4 || pl == 5)) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)this.path.getLastPathComponent()).getUserObject();
            if (data != null && data.isNAC()) {
                this.nac = data.getNAC();
                if (!this.nac.getMorphism().isEnabled()) {
                    this.disable.setSelected(true);
                } else {
                    this.disable.setSelected(false);
                }
                return true;
            }
        }
        return false;
    }

    void copy() {
        if (this.nac != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            OrdinaryMorphism iso = this.nac.getMorphism().getTarget().isoCopy();
            OrdinaryMorphism ac = new OrdinaryMorphism(this.nac.getMorphism().getSource(), iso.getTarget(), this.nac.getRule().getBasisRule().getRight().getAttrContext());
            if (ac.completeDiagram3(this.nac.getMorphism(), iso)) {
                ac.setName(String.valueOf(this.nac.getName()) + "_clone");
                ac.getImage().setAttrContext(ac.getAttrContext());
                ac.getImage().setKind("NAC");
                EdNAC cn = this.nac.getRule().createNAC(ac);
                this.nac.getRule().getNACs().remove(cn);
                cn.setLayoutByIndex(this.nac, true);
                int indx = this.nac.getRule().getNACs().indexOf(this.nac) + 1;
                if (indx >= 0) {
                    this.nac.getRule().getBasisRule().addNAC(indx, ac);
                    this.nac.getRule().getNACs().add(indx, cn);
                    this.treeView.putNACIntoTree(cn, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + 1);
                }
            }
        }
    }

    void makeCopyFromRHS() {
        if (this.nac != null && this.treeView.getFrame() instanceof AGGAppl) {
            ((AGGAppl)this.treeView.getFrame()).getGraGraEditor().getRuleEditor().doNACDuetoRHS();
        }
    }

    void convertToGAC() {
        if (this.nac != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            OrdinaryMorphism iso = this.nac.getMorphism().getTarget().isoCopy();
            NestedApplCond ac = new NestedApplCond(this.nac.getMorphism().getSource(), iso.getTarget(), this.nac.getRule().getBasisRule().getRight().getAttrContext());
            if (ac.completeDiagram3(this.nac.getMorphism(), iso)) {
                ac.setName(this.nac.getName());
                ac.getImage().setAttrContext(ac.getAttrContext());
                ac.getImage().setKind("AC");
                this.nac.getRule().getBasisRule().addNestedAC(ac);
                EdNestedApplCond cn = this.nac.getRule().createNestedAC(ac);
                cn.setLayoutByIndex(this.nac, true);
                if (this.nac.getRule().getBasisRule().getNestedACsList().size() == 1) {
                    this.treeView.putNestedACIntoTree(cn, (DefaultMutableTreeNode)node.getParent(), 0);
                } else {
                    DefaultMutableTreeNode prev = this.treeView.getTreeNodeOfGrammarElement(this.nac.getRule().getNestedAC(this.nac.getRule().getNestedACs().size() - 2));
                    int indx = this.treeView.getTreeModel().getIndexOfChild(node.getParent(), prev);
                    this.treeView.putNestedACIntoTree(cn, (DefaultMutableTreeNode)node.getParent(), indx + 1);
                }
            }
        }
    }
}

