/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.attribute.AttrContext;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.gui.AGGAppl;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.dialog.FormulaGraphGUI;
import agg.gui.treeview.nodedata.ApplFormulaTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.path.GrammarTreeNode;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraphObject;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NestedACPopupMenu
extends JPopupMenu {
    GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    GraGraTreeNodeData data;
    GraGraTreeNodeData parData;
    GraGraTreeNodeData formula;
    EdNestedApplCond cond;
    EdNestedApplCond parCond;
    EdRule rule;
    int posX;
    int posY;
    private JMenuItem miDisable;
    private JMenuItem miRHS;

    public NestedACPopupMenu(GraGraTreeView tree) {
        super("General Application Condition");
        this.treeView = tree;
        this.miRHS = this.add(new JMenuItem("Make due to RHS"));
        this.miRHS.setEnabled(false);
        this.miRHS.setActionCommand("makeFromRHS");
        this.miRHS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NestedACPopupMenu.this.makeCopyFromRHS();
            }
        });
        this.addSeparator();
        JMenuItem mi = this.add(new JMenuItem("New GAC"));
        mi.setActionCommand("newNestedAC");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = new JMenuItem("Set Formula above GACs");
        this.add(mi);
        mi.setActionCommand("setFormulaAboveACs");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NestedACPopupMenu.this.setFormula();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Copy           "));
        mi.setActionCommand("copyGAC");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NestedACPopupMenu.this.copy();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Convert to NAC"));
        mi.setActionCommand("convertToNAC");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NestedACPopupMenu.this.convertToNAC();
            }
        });
        mi = this.add(new JMenuItem("Convert to PAC"));
        mi.setActionCommand("convertToPAC");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NestedACPopupMenu.this.convertToPAC();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Delete           Delete"));
        mi.setActionCommand("deleteNestedAC");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miDisable = this.add(new JCheckBoxMenuItem("disabled"));
        this.miDisable.setActionCommand("disableNestedAC");
        this.miDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                    NestedACPopupMenu.this.cond.getMorphism().setEnabled(false);
                    if (NestedACPopupMenu.this.rule != null && !((NestedApplCond)NestedACPopupMenu.this.cond.getMorphism()).getVarTagInFormula().isEmpty()) {
                        ((NestedApplCond)NestedACPopupMenu.this.cond.getMorphism()).setVarTagInFormula("");
                        NestedACPopupMenu.this.rule.getBasisRule().setFormula("");
                        if (NestedACPopupMenu.this.formula != null) {
                            NestedACPopupMenu.this.treeView.getTreeModel().removeNodeFromParent(NestedACPopupMenu.this.formula.getTreeNode());
                            NestedACPopupMenu.this.formula = null;
                        }
                    } else if (NestedACPopupMenu.this.parCond != null && !((NestedApplCond)NestedACPopupMenu.this.cond.getMorphism()).getVarTagInFormula().isEmpty()) {
                        ((NestedApplCond)NestedACPopupMenu.this.cond.getMorphism()).setVarTagInFormula("");
                        ((NestedApplCond)NestedACPopupMenu.this.parCond.getMorphism()).setFormula("");
                        if (NestedACPopupMenu.this.formula != null) {
                            NestedACPopupMenu.this.treeView.getTreeModel().removeNodeFromParent(NestedACPopupMenu.this.formula.getTreeNode());
                            NestedACPopupMenu.this.formula = null;
                        }
                    }
                    NestedACPopupMenu.this.data.update();
                } else {
                    NestedACPopupMenu.this.cond.getMorphism().setEnabled(true);
                    NestedACPopupMenu.this.data.update();
                }
                NestedACPopupMenu.this.treeView.getTree().treeDidChange();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Textual Comments"));
        mi.setActionCommand("commentNestedAC");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.data = (GraGraTreeNodeData)this.node.getUserObject();
            if (this.data != null && this.data.isNestedAC()) {
                GrammarTreeNode.expand(this.treeView, this.node, this.path);
                this.parData = (GraGraTreeNodeData)((DefaultMutableTreeNode)this.node.getParent()).getUserObject();
                if (this.parData.isRule()) {
                    this.rule = this.parData.getRule();
                    this.miRHS.setEnabled(true);
                } else if (this.parData.isNestedAC()) {
                    this.parCond = this.parData.getNestedAC();
                    this.miRHS.setEnabled(false);
                }
                GraGraTreeNodeData firstChildData = (GraGraTreeNodeData)((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.node.getParent()).getFirstChild()).getUserObject();
                if (firstChildData.isApplFormula()) {
                    this.formula = firstChildData;
                }
                this.posX = x;
                this.posY = y;
                this.cond = this.data.getNestedAC();
                if (!this.cond.getMorphism().isEnabled()) {
                    this.miDisable.setSelected(true);
                } else {
                    this.miDisable.setSelected(false);
                }
                return true;
            }
        }
        return false;
    }

    void setFormula() {
        block2: {
            String f;
            boolean formulaChanged;
            String ownerName = "application condition : " + this.cond.getMorphism().getName();
            FormulaGraphGUI d = new FormulaGraphGUI(this.treeView.getFrame(), ownerName, " Graph editor of Formula above General Application Conditions ", " An empty graph is the case where all nodes are connected by AND.", true);
            d.setExportJPEG(this.treeView.getGraphicsExportJPEG());
            String oldformula = ((NestedApplCond)this.cond.getMorphism()).getFormulaText();
            List<EdNestedApplCond> allNestedACs = this.cond.getEnabledACs();
            List<NestedApplCond> list = this.makeFrom(allNestedACs);
            d.setVarsAsObjs(allNestedACs, oldformula);
            d.setLocation(this.posX + 20, this.posY + 20);
            while (true) {
                d.setVisible(true);
                if (d.isCanceled()) break block2;
                formulaChanged = d.isChanged();
                f = d.getFormula();
                if (this.cond.getNestedMorphism().setFormula(f, list)) break;
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "The formula definition failed. Please correct.", " Formula failed ", 2);
            }
            if (formulaChanged) {
                this.insertFormulaIntoACTreeNode(f, allNestedACs);
                this.cond.getGraGra().setChanged(true);
            }
        }
    }

    void insertFormulaIntoACTreeNode(String f, List<EdNestedApplCond> allVarsObj) {
        if (f.length() > 0) {
            Object child;
            Object object = child = this.node.getChildCount() > 0 ? this.treeView.getTreeModel().getChild(this.node, 0) : null;
            if (child != null && ((GraGraTreeNodeData)((DefaultMutableTreeNode)child).getUserObject()).isApplFormula()) {
                this.treeView.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)child);
            }
            if (!"true".equals(f)) {
                ApplFormulaTreeNodeData conddata = new ApplFormulaTreeNodeData(f, true, this.cond);
                conddata.setString(f);
                DefaultMutableTreeNode condnode = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condnode);
                this.treeView.getTreeModel().insertNodeInto(condnode, this.node, 0);
            }
        }
    }

    private List<NestedApplCond> makeFrom(List<EdNestedApplCond> list) {
        Vector<NestedApplCond> result = new Vector<NestedApplCond>(list.size(), 0);
        int i = 0;
        while (i < list.size()) {
            result.add(list.get(i).getNestedMorphism());
            ++i;
        }
        return result;
    }

    void copy() {
        if (this.cond != null) {
            AttrContext attrContxt = this.cond.getRule().getBasisRule().getRight().getAttrContext();
            if (this.cond.getParent() != null) {
                attrContxt = this.cond.getMorphism().getImage().getAttrContext();
            }
            NestedApplCond ac = new NestedApplCond(this.cond.getMorphism().getSource(), BaseFactory.theFactory().createGraph(this.cond.getMorphism().getSource().getTypeSet()), attrContxt);
            ac.getImage().setAttrContext(attrContxt);
            Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
            Enumeration<GraphObject> gos = this.cond.getMorphism().getSource().getElements();
            while (gos.hasMoreElements()) {
                GraphObject go = gos.nextElement();
                table.put(go, go);
            }
            BaseFactory.theFactory().copyGraph(this.cond.getBasisGraph(), ac.getImage(), table);
            BaseFactory.theFactory().copyMorph(this.cond.getMorphism(), ac, table);
            BaseFactory.theFactory().copyNestedAC(this.cond.getNestedMorphism(), ac, table);
            ac.setName(String.valueOf(this.cond.getName()) + "_clone");
            if (this.cond.getParent() == null) {
                EdNestedApplCond cp = this.cond.getRule().createNestedAC(ac);
                this.cond.getRule().getNestedACs().remove(cp);
                int indx = this.cond.getRule().getNestedACs().indexOf(this.cond) + 1;
                if (indx >= 0) {
                    this.cond.getRule().getBasisRule().addNestedAC(indx, ac);
                    this.cond.getRule().getNestedACs().add(indx, cp);
                    cp.setLayoutByIndex(this.cond, true);
                    this.treeView.putNestedACIntoTree(cp, (DefaultMutableTreeNode)this.node.getParent(), ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.node) + 1);
                }
            } else {
                EdNestedApplCond parAC = this.cond.getParent();
                EdNestedApplCond cp = (EdNestedApplCond)parAC.createNestedAC(ac);
                parAC.getNestedACs().remove(cp);
                int indx = parAC.getNestedACs().indexOf(this.cond) + 1;
                if (indx >= 0) {
                    parAC.getNestedMorphism().addNestedAC(indx, ac);
                    parAC.getNestedACs().add(indx, cp);
                    cp.setLayoutByIndex(this.cond, true);
                    this.treeView.putNestedACIntoTree(cp, (DefaultMutableTreeNode)this.node.getParent(), ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.node) + 1);
                }
            }
        }
    }

    void convertToNAC() {
        if (this.cond != null) {
            OrdinaryMorphism iso = this.cond.getMorphism().getTarget().isoCopy();
            OrdinaryMorphism ac = new OrdinaryMorphism(this.cond.getMorphism().getSource(), iso.getTarget(), this.cond.getRule().getBasisRule().getRight().getAttrContext());
            if (ac.completeDiagram3(this.cond.getMorphism(), iso)) {
                DefaultMutableTreeNode child;
                ac.setName(this.cond.getName());
                ac.getImage().setAttrContext(ac.getAttrContext());
                ac.getImage().setKind("NAC");
                this.cond.getRule().getBasisRule().addNAC(ac);
                EdNAC cn = this.cond.getRule().createNAC(ac);
                cn.setLayoutByIndex(this.cond, true);
                DefaultMutableTreeNode rn = this.treeView.getTreeNodeOfGrammarElement(this.cond.getRule());
                int indx = this.cond.getRule().getNestedACs().size() + this.cond.getRule().getNACs().size() - 1;
                if (rn.getChildCount() > 0 && (child = (DefaultMutableTreeNode)rn.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
                    ++indx;
                }
                this.treeView.putNACIntoTree(cn, rn, indx);
            }
        }
    }

    void convertToPAC() {
        if (this.cond != null) {
            OrdinaryMorphism iso = this.cond.getMorphism().getTarget().isoCopy();
            OrdinaryMorphism ac = new OrdinaryMorphism(this.cond.getMorphism().getSource(), iso.getTarget(), this.cond.getRule().getBasisRule().getRight().getAttrContext());
            if (ac.completeDiagram3(this.cond.getMorphism(), iso)) {
                DefaultMutableTreeNode child;
                ac.setName(this.cond.getName());
                ac.getImage().setAttrContext(ac.getAttrContext());
                ac.getImage().setKind("PAC");
                this.cond.getRule().getBasisRule().addPAC(ac);
                EdPAC cn = this.cond.getRule().createPAC(ac);
                cn.setLayoutByIndex(this.cond, true);
                DefaultMutableTreeNode rn = this.treeView.getTreeNodeOfGrammarElement(this.cond.getRule());
                int indx = this.cond.getRule().getNestedACs().size() + this.cond.getRule().getNACs().size() + this.cond.getRule().getPACs().size() - 1;
                if (rn.getChildCount() > 0 && (child = (DefaultMutableTreeNode)rn.getFirstChild()) != null && ((GraGraTreeNodeData)child.getUserObject()).isApplFormula()) {
                    ++indx;
                }
                this.treeView.putPACIntoTree(cn, rn, indx);
            }
        }
    }

    void makeCopyFromRHS() {
        if (this.parCond == null && this.treeView.getFrame() instanceof AGGAppl) {
            ((AGGAppl)this.treeView.getFrame()).getGraGraEditor().getRuleEditor().doGACDuetoRHS();
        }
    }
}

