/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdPAC;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PACPopupMenu
extends JPopupMenu {
    GraGraTreeView treeView;
    TreePath path;
    EdPAC pac;
    JMenuItem disable;

    public PACPopupMenu(GraGraTreeView tree) {
        super("PAC");
        this.treeView = tree;
        JMenuItem mi = this.add(new JMenuItem("Copy           "));
        mi.setActionCommand("copyPAC");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PACPopupMenu.this.copy();
            }
        });
        mi = this.add(new JMenuItem("Convert to GAC"));
        mi.setActionCommand("copyToGAC");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PACPopupMenu.this.convertToGAC();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Delete           Delete"));
        mi.setActionCommand("deletePAC");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.disable = new JCheckBoxMenuItem("disabled");
        this.disable.setActionCommand("disablePAC");
        this.disable.addActionListener(this.treeView.getActionAdapter());
        this.add(this.disable);
        this.addSeparator();
        mi = this.add(new JMenuItem("Textual Comments"));
        mi.setActionCommand("commentPAC");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        int pl;
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && ((pl = this.treeView.getTree().getPathForLocation(x, y).getPath().length) == 4 || pl == 5)) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            GraGraTreeNodeData data = (GraGraTreeNodeData)((DefaultMutableTreeNode)this.path.getLastPathComponent()).getUserObject();
            if (data != null && data.isPAC()) {
                this.pac = data.getPAC();
                if (!this.pac.getMorphism().isEnabled()) {
                    this.disable.setSelected(true);
                } else {
                    this.disable.setSelected(false);
                }
                return true;
            }
        }
        return false;
    }

    void copy() {
        if (this.pac != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            OrdinaryMorphism iso = this.pac.getMorphism().getTarget().isoCopy();
            OrdinaryMorphism ac = new OrdinaryMorphism(this.pac.getMorphism().getSource(), iso.getTarget(), this.pac.getRule().getBasisRule().getRight().getAttrContext());
            if (ac.completeDiagram3(this.pac.getMorphism(), iso)) {
                ac.setName(String.valueOf(this.pac.getName()) + "_clone");
                ac.getImage().setAttrContext(ac.getAttrContext());
                ac.getImage().setKind("PAC");
                EdPAC cp = this.pac.getRule().createPAC(ac);
                this.pac.getRule().getPACs().remove(cp);
                cp.setLayoutByIndex(this.pac, true);
                int indx = this.pac.getRule().getPACs().indexOf(this.pac) + 1;
                if (indx >= 0) {
                    this.pac.getRule().getBasisRule().addPAC(indx, ac);
                    this.pac.getRule().getPACs().add(indx, cp);
                    this.treeView.putPACIntoTree(cp, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + 1);
                }
            }
        }
    }

    void convertToGAC() {
        if (this.pac != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            OrdinaryMorphism iso = this.pac.getMorphism().getTarget().isoCopy();
            NestedApplCond ac = new NestedApplCond(this.pac.getMorphism().getSource(), iso.getTarget(), this.pac.getRule().getBasisRule().getRight().getAttrContext());
            if (ac.completeDiagram3(this.pac.getMorphism(), iso)) {
                ac.setName(this.pac.getName());
                ac.getImage().setAttrContext(ac.getAttrContext());
                ac.getImage().setKind("AC");
                this.pac.getRule().getBasisRule().addNestedAC(ac);
                EdNestedApplCond cn = this.pac.getRule().createNestedAC(ac);
                cn.setLayoutByIndex(this.pac, true);
                if (this.pac.getRule().getBasisRule().getNestedACsList().size() == 1) {
                    this.treeView.putNestedACIntoTree(cn, (DefaultMutableTreeNode)node.getParent(), 0);
                } else {
                    DefaultMutableTreeNode prev = this.treeView.getTreeNodeOfGrammarElement(this.pac.getRule().getNestedAC(this.pac.getRule().getNestedACs().size() - 2));
                    int indx = this.treeView.getTreeModel().getIndexOfChild(node.getParent(), prev);
                    this.treeView.putNestedACIntoTree(cn, (DefaultMutableTreeNode)node.getParent(), indx + 1);
                }
            }
        }
    }
}

