/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.saveload;

import agg.editor.impl.Arrow;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdRule;
import agg.gui.editor.GraphCanvas;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class GraGraPrint
extends JPanel
implements ActionListener,
EditEventListener {
    EdGraGra gragra;
    JPanel gragraPanel;
    JFrame applFrame;
    JDialog dialog;
    JButton preview;
    JButton print;
    JFrame previewFrame;
    JButton previewPrint;
    JButton previewCancel;
    JCheckBox all;
    JCheckBox g;
    Vector<JCheckBox> gragraRuleChecks;
    Vector<JLabel> gragraRuleInfos;
    Vector<JCheckBox> gragraOptionalChecks;
    Vector<Vector<JCheckBox>> optionalChecks;
    JDialog ruleCheck;
    Vector<Boolean> optional;
    boolean cancelled = false;
    int W = 468;
    int H = 648;
    static final int offset = 10;
    Dimension pageable = new Dimension(612, 792);
    Dimension imageable = new Dimension(468, 648);
    double scale = 1.0;
    PageFormat pageFormat;
    Font font = new Font("Dialog", 0, 12);
    String fontName = "Dialog";
    int fontStyle = 0;
    int fontSize = 12;

    public GraGraPrint(JFrame applFrame) {
        this(applFrame, null);
    }

    public GraGraPrint(JFrame applFrame, EdGraGra gra) {
        super(new BorderLayout(), true);
        this.setBackground(Color.white);
        this.applFrame = applFrame;
        this.gragra = gra;
        this.initialize(this.gragra);
    }

    private void initialize(EdGraGra gra) {
        this.gragraRuleChecks = new Vector();
        this.gragraRuleInfos = new Vector();
        this.gragraOptionalChecks = new Vector();
        this.optionalChecks = new Vector();
        this.previewFrame = new JFrame("Preview");
        this.setSize(150, 150);
        this.setPreferredSize(new Dimension(150, 150));
        JScrollPane jsp = new JScrollPane(22, 32);
        jsp.setViewportView(this);
        this.previewFrame.getContentPane().add("Center", jsp);
        JPanel buttonPanel = new JPanel();
        this.previewPrint = new JButton("Print");
        this.previewCancel = new JButton("Cancel");
        buttonPanel.add(this.previewPrint);
        buttonPanel.add(this.previewCancel);
        this.previewPrint.addActionListener(this);
        this.previewCancel.addActionListener(this);
        this.previewFrame.getContentPane().add("South", buttonPanel);
        this.previewFrame.setSize(150, 150);
        this.previewFrame.setLocation(10, 10);
        this.previewFrame.pack();
        this.dialog = new JDialog(new JFrame(), "Print", true);
        JPanel mainPanel = new JPanel(new GridBagLayout(), true);
        mainPanel.setPreferredSize(new Dimension(300, 300));
        this.dialog.getContentPane().add(mainPanel);
        this.gragraPanel = new JPanel(new BorderLayout());
        this.gragraPanel.add((Component)this.createGraGraCheckBox(gra), "Center");
        JPanel scalePanel = new JPanel(new BorderLayout());
        scalePanel.add((Component)this.createScaleBox(), "Center");
        JPanel confirmPanel = new JPanel(new BorderLayout());
        confirmPanel.add((Component)this.createConfirmButtons(), "Center");
        this.print.addActionListener(this);
        this.constrainBuild(mainPanel, this.gragraPanel, 0, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(mainPanel, confirmPanel, 0, 2, 2, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        this.dialog.pack();
        this.dialog.setLocation(50, 50);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton && (e.getSource() == this.previewPrint || e.getSource() == this.print)) {
            if (this.isEmpty()) {
                return;
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (printJob != null) {
                printJob.setJobName("GraGra");
                this.pageFormat = printJob.defaultPage();
                this.pageFormat.setOrientation(1);
                Book book = new Book();
                printJob.setPageable(book);
                if (printJob.printDialog()) {
                    this.pageable = new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
                    this.imageable = new Dimension(this.pageable.width - 2 * (int)this.pageFormat.getImageableX(), this.pageable.height - 2 * (int)this.pageFormat.getImageableY());
                    this.W = this.imageable.width;
                    this.H = this.imageable.height;
                    Vector<Vector<Image>> pages = this.getPagesToPrint(this.pageFormat);
                    if (pages != null) {
                        int i = 0;
                        while (i < pages.size()) {
                            PaintContent paintContent = new PaintContent();
                            paintContent.setPageImages(pages.elementAt(i));
                            book.append(paintContent, this.pageFormat);
                            ++i;
                        }
                    }
                    try {
                        printJob.print();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        this.previewFrame.dispose();
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == -4) {
            this.fontStyle = e.getIntValue();
        } else if (msgkey == -5) {
            this.fontSize = e.getIntValue();
        } else if (msgkey == -6) {
            this.scale = e.getDoubleValue();
        }
    }

    public void showDialog() {
        this.dialog.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics grs) {
        super.paintComponent(grs);
        Graphics2D g2D = (Graphics2D)grs;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setPaint(Color.white);
        g2D.drawRect(0, 0, this.getWidth(), this.getHeight());
        this.printImages(g2D);
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.gragraRuleChecks = new Vector();
        this.gragraRuleInfos = new Vector();
        this.gragraOptionalChecks = new Vector();
        this.optionalChecks = new Vector();
        this.gragraPanel.removeAll();
        this.gragraPanel.add((Component)this.createGraGraCheckBox(this.gragra), "Center");
        this.preview.setEnabled(false);
        this.print.setEnabled(false);
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        if (this.dialog != null && this.applFrame != null) {
            this.dialog.setLocation(this.applFrame.getLocation().x + this.applFrame.getWidth() / 4, this.applFrame.getLocation().y + this.applFrame.getHeight() / 4);
        }
    }

    public boolean isEmpty() {
        if (this.cancelled) {
            return true;
        }
        if (this.all.isSelected()) {
            return false;
        }
        if (this.g.isSelected()) {
            return false;
        }
        int i = 0;
        while (i < this.gragraRuleChecks.size()) {
            JCheckBox cb = this.gragraRuleChecks.elementAt(i);
            if (cb.isSelected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Vector<Image> getAllImages() {
        Vector<Image> images = new Vector<Image>();
        int i = 0;
        while (i < this.gragraRuleChecks.size()) {
            Vector<Image> imgs;
            JCheckBox cb = this.gragraRuleChecks.elementAt(i);
            EdRule r = this.gragra.getRules().elementAt(i);
            if ((this.all.isSelected() || cb.isSelected()) && (imgs = this.getImage(i, r)) != null) {
                int j = 0;
                while (j < imgs.size()) {
                    Image image = imgs.elementAt(j);
                    if (image != null) {
                        images.addElement(image);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.all.isSelected() || this.g.isSelected()) {
            Image image = null;
            image = this.gragra.getGraph().getGraphDimension((double)this.scale).width == 0 ? this.getImage(this.gragra.getGraph(), new Dimension(100, 50)) : this.getImage(this.gragra.getGraph(), null);
            if (image != null) {
                images.addElement(image);
            }
        }
        return images;
    }

    private void printImages(Graphics2D grs) {
        Vector<Vector<Image>> pages;
        if (this.pageFormat == null) {
            this.pageFormat = new PageFormat();
        }
        if ((pages = this.getPagesToPrint(this.pageFormat)).isEmpty()) {
            return;
        }
        int x = 0;
        int y = 0;
        int j = 0;
        while (j < pages.size()) {
            Vector<Image> pageImages = pages.elementAt(j);
            if (pageImages != null) {
                x = (int)this.pageFormat.getImageableX();
                y += (int)this.pageFormat.getImageableY();
                int i = 0;
                while (i < pageImages.size()) {
                    Image image = pageImages.elementAt(i);
                    grs.drawImage(image, x, y, null);
                    y += image.getHeight(null);
                    ++i;
                }
                grs.setPaint(Color.black);
                grs.drawLine(0, y += (int)this.pageFormat.getImageableY(), this.W, y);
                grs.setPaint(Color.white);
            }
            ++j;
        }
        this.setSize(this.W + (int)this.pageFormat.getImageableX() + 10, y + 10);
    }

    private Vector<Vector<Image>> getPagesToPrint(PageFormat pf) {
        Vector<Vector<Image>> pgs = new Vector<Vector<Image>>();
        Vector<Image> images = this.getAllImages();
        if (images.isEmpty()) {
            return pgs;
        }
        int y = (int)pf.getImageableY();
        Vector<Image> page = new Vector<Image>();
        int i = 0;
        while (i < images.size()) {
            Image image = images.elementAt(i);
            if (image != null) {
                if (y + image.getHeight(null) <= this.imageable.height) {
                    page.addElement(image);
                    if ((y += image.getHeight(null)) + 10 <= this.imageable.height) {
                        y = y + image.getHeight(null) + 10;
                    }
                } else {
                    if (!page.isEmpty()) {
                        pgs.addElement(page);
                    }
                    y = (int)this.pageFormat.getImageableY();
                    page = new Vector();
                    page.addElement(image);
                    if ((y += image.getHeight(null)) + 10 <= this.imageable.height) {
                        y = y + image.getHeight(null) + 10;
                    }
                }
            }
            ++i;
        }
        if (!page.isEmpty()) {
            pgs.addElement(page);
        }
        return pgs;
    }

    private JPanel createGraGraCheckBox(EdGraGra gra) {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel info = new JLabel("GraGra: EMPTY");
        if (gra == null) {
            return p;
        }
        info = new JLabel("GraGra:  " + gra.getName());
        int y = 0;
        this.constrainBuild(p, info, 0, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        this.all = new JCheckBox("All");
        this.all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JCheckBox && e.getSource() == GraGraPrint.this.all) {
                    if (GraGraPrint.this.all.isSelected()) {
                        GraGraPrint.this.deselectRules();
                        GraGraPrint.this.g.setSelected(false);
                        GraGraPrint.this.preview.setEnabled(true);
                        GraGraPrint.this.print.setEnabled(true);
                    } else if (GraGraPrint.this.isEmpty()) {
                        GraGraPrint.this.preview.setEnabled(false);
                        GraGraPrint.this.print.setEnabled(false);
                    }
                }
            }
        });
        this.constrainBuild(p, this.all, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        JLabel opt = new JLabel("optional");
        this.constrainBuild(p, opt, 1, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        int i = 0;
        while (i < gra.getRules().size()) {
            final EdRule r = gra.getRules().elementAt(i);
            final int indx = i;
            if (r != null) {
                JCheckBox cb = new JCheckBox(r.getBasisRule().getName());
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JCheckBox item = (JCheckBox)e.getSource();
                        if (item.isSelected()) {
                            GraGraPrint.this.all.setSelected(false);
                            GraGraPrint.this.gragraOptionalChecks.elementAt(indx).setEnabled(true);
                            GraGraPrint.this.preview.setEnabled(true);
                            GraGraPrint.this.print.setEnabled(true);
                        } else {
                            GraGraPrint.this.gragraOptionalChecks.elementAt(indx).setEnabled(false);
                            if (GraGraPrint.this.isEmpty()) {
                                GraGraPrint.this.preview.setEnabled(false);
                                GraGraPrint.this.print.setEnabled(false);
                            }
                        }
                    }
                });
                this.gragraRuleChecks.add(cb);
                this.constrainBuild(p, cb, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
                cb = new JCheckBox();
                cb.setEnabled(false);
                this.gragraOptionalChecks.addElement(cb);
                final Vector checks = new Vector();
                this.optionalChecks.add(checks);
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JCheckBox item = (JCheckBox)e.getSource();
                        if (item.isSelected()) {
                            GraGraPrint.this.ruleCheck = GraGraPrint.this.getRuleCheckBox(r, indx, checks);
                        }
                    }
                });
                this.constrainBuild(p, cb, 1, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
                info = new JLabel("");
                this.gragraRuleInfos.addElement(info);
                this.constrainBuild(p, info, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
            }
            ++i;
        }
        this.g = new JCheckBox(this.gragra.getGraph().getBasisGraph().getName());
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JCheckBox && e.getSource() == GraGraPrint.this.g) {
                    if (GraGraPrint.this.g.isSelected()) {
                        GraGraPrint.this.all.setSelected(false);
                        GraGraPrint.this.preview.setEnabled(true);
                        GraGraPrint.this.print.setEnabled(true);
                    } else if (GraGraPrint.this.isEmpty()) {
                        GraGraPrint.this.preview.setEnabled(false);
                        GraGraPrint.this.print.setEnabled(false);
                    }
                }
            }
        });
        this.constrainBuild(p, this.g, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        return p;
    }

    JDialog getRuleCheckBox(EdRule r, int n, Vector<JCheckBox> v) {
        final JDialog dial = new JDialog(new JFrame(), "optional", true);
        JPanel p = new JPanel(new GridBagLayout());
        dial.getContentPane().add(p);
        int y = 0;
        JCheckBox cb = new JCheckBox("LHS");
        this.constrainBuild(p, cb, 0, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        v.addElement(cb);
        cb = new JCheckBox("RHS");
        this.constrainBuild(p, cb, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        v.addElement(cb);
        if (r.getNACs().size() != 0) {
            JLabel l = new JLabel("NAC:");
            this.constrainBuild(p, l, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
            int i = 0;
            while (i < r.getNACs().size()) {
                EdNAC nac = r.getNACs().elementAt(i);
                cb = new JCheckBox(nac.getName());
                v.addElement(cb);
                this.constrainBuild(p, cb, 0, ++y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
                ++i;
            }
        }
        ++y;
        JButton ok = new JButton("OK");
        ok.setBorderPainted(true);
        final Vector<JCheckBox> checks = v;
        final int indx = n;
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean check = false;
                int i = 0;
                while (i < checks.size()) {
                    JCheckBox c = (JCheckBox)checks.elementAt(i);
                    if (c.isSelected()) {
                        check = true;
                    }
                    ++i;
                }
                if (!check) {
                    GraGraPrint.this.deselectRuleOptional(indx);
                }
                dial.setVisible(false);
            }
        });
        this.constrainBuild(p, ok, 0, y, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 5);
        dial.pack();
        dial.setLocation(this.dialog.getX() + 100, this.dialog.getY() + 50);
        dial.setVisible(true);
        return dial;
    }

    private JPanel createScaleBox() {
        JPanel p = new JPanel();
        JLabel l = new JLabel("Scale:  ");
        p.add(l);
        final JTextField s = new JTextField("1.0", 3);
        p.add(s);
        this.scale = 1.0;
        s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JTextField) {
                    try {
                        Double d = new Double(((JTextField)e.getSource()).getText().trim());
                        GraGraPrint.this.scale = d;
                    }
                    catch (NumberFormatException ex) {
                        s.setText("1.0");
                    }
                }
            }
        });
        return p;
    }

    private JPanel createConfirmButtons() {
        JPanel p = new JPanel(new GridBagLayout());
        this.preview = new JButton("Preview");
        this.preview.setEnabled(false);
        this.preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPrint.this.dialog.setVisible(false);
                GraGraPrint.this.previewFrame.setVisible(true);
            }
        });
        this.constrainBuild(p, this.preview, 0, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 10, 5, 5);
        this.print = new JButton("Print");
        this.print.setEnabled(false);
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPrint.this.dialog.setVisible(false);
            }
        });
        this.constrainBuild(p, this.print, 1, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 10, 5, 5);
        JButton b = new JButton("Cancel");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPrint.this.cancelled = true;
                GraGraPrint.this.dialog.setVisible(false);
            }
        });
        this.constrainBuild(p, b, 2, 0, 1, 1, 1, 10, 0.0, 0.0, 5, 5, 5, 10);
        return p;
    }

    void deselectRules() {
        int i = 0;
        while (i < this.gragraRuleChecks.size()) {
            this.gragraRuleChecks.elementAt(i).setSelected(false);
            this.gragraOptionalChecks.elementAt(i).setEnabled(false);
            ++i;
        }
    }

    void deselectRuleOptional(int n) {
        JCheckBox cb = this.gragraOptionalChecks.elementAt(n);
        cb.setSelected(false);
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    private Image getImage(EdGraph graph, Dimension imageDim) {
        int h;
        int w;
        Image image;
        if (graph == null) {
            return null;
        }
        Dimension graphDim = graph.getGraphDimension(this.scale);
        if (graphDim == null) {
            return null;
        }
        graphDim.width = graphDim.width;
        graphDim.height = graphDim.height;
        Dimension d = new Dimension(graphDim.width, 20 + graphDim.height);
        if (imageDim != null) {
            if (imageDim.width > d.width) {
                d.width = imageDim.width;
            }
            if (imageDim.height > d.height) {
                d.height = imageDim.height;
            }
        }
        if ((image = this.createImage(w = d.width, h = d.height)) == null) {
            return null;
        }
        Graphics2D grs = (Graphics2D)image.getGraphics();
        grs.setPaint(Color.white);
        grs.fill(new Rectangle(0, 0, w, h));
        GraphCanvas canvas = new GraphCanvas();
        canvas.setSize(d);
        canvas.setGraph(graph);
        Image im = this.createImage(graphDim.width, graphDim.height);
        canvas.setScale(this.scale);
        canvas.setFontStyle(this.fontStyle);
        canvas.setFontSize(this.fontSize);
        canvas.paint(im.getGraphics());
        grs.setPaint(Color.black);
        grs.drawString(graph.getBasisGraph().getName(), 10, 15);
        grs.drawImage(im, 1, 20, null);
        grs.drawRect(1, 20, w - 2, h - 20 - 2);
        return image;
    }

    private Image getImage(Vector<EdNAC> nacGraphs) {
        if (nacGraphs == null || nacGraphs.isEmpty()) {
            return null;
        }
        int iw = 0;
        int ih = 0;
        Vector<EdGraph> imageGraphs = new Vector<EdGraph>();
        int i = 0;
        while (i < nacGraphs.size()) {
            EdGraph eg = nacGraphs.elementAt(i);
            if (this.optional != null && (this.optional.isEmpty() || this.optional.elementAt(i + 2).booleanValue())) {
                Dimension graphDim = eg.getGraphDimension(this.scale);
                if (graphDim.width > iw) {
                    iw = graphDim.width;
                }
                if (graphDim.height > ih) {
                    ih = graphDim.height;
                }
                if (iw > 0 && ih > 0) {
                    imageGraphs.addElement(eg);
                }
            }
            ++i;
        }
        iw += 10;
        ih = 20 + ih + 10;
        Vector<Image> images = new Vector<Image>();
        int i2 = 0;
        while (i2 < imageGraphs.size()) {
            EdGraph eg = (EdGraph)imageGraphs.elementAt(i2);
            Image image = this.getImage(eg, new Dimension(iw, ih));
            images.addElement(image);
            ++i2;
        }
        Dimension space = new Dimension(10, ih);
        int w = 0;
        int h = 0;
        int n = 0;
        int i3 = 0;
        while (i3 < images.size()) {
            if (i3 == 0) {
                w = iw;
                n = 1;
            } else if (w + space.width > this.W) {
                n = i3;
                i3 = images.size();
            } else if (w + space.width + iw > this.W) {
                w += space.width;
                n = i3;
                i3 = images.size();
            } else {
                ++n;
                w = w + space.width + iw;
            }
            ++i3;
        }
        int nn = Math.round((float)images.size() / (float)n);
        if (nn > 0) {
            h = nn * ih + 20;
            while (h > this.H) {
                h = --nn * ih + 20;
            }
            Image bigImage = this.createImage(w, h);
            Graphics2D grs = (Graphics2D)bigImage.getGraphics();
            grs.setPaint(Color.white);
            grs.fill(new Rectangle(0, 0, w, h));
            int x = 0;
            int y = 0;
            int i4 = 0;
            while (i4 < images.size()) {
                Image image = (Image)images.elementAt(i4);
                if (x + space.width > this.W || x + space.width + iw > this.W) {
                    x = 0;
                    y += ih;
                }
                grs.drawImage(image, x, y, null);
                x = x + iw + space.width;
                ++i4;
            }
            return bigImage;
        }
        return null;
    }

    private Image getRuleArrow(Dimension d, boolean horizontal) {
        if (d == null) {
            return null;
        }
        Image image = this.createImage(d.width, d.height);
        Graphics2D grs = (Graphics2D)image.getGraphics();
        grs.setPaint(Color.white);
        grs.fill(new Rectangle(0, 0, d.width, d.height));
        grs.setPaint(Color.black);
        Arrow arrow = null;
        if (horizontal) {
            grs.drawLine(0, d.height / 2, d.width, d.height / 2);
            arrow = new Arrow(1.0, 0, d.height / 2, d.width, d.height / 2);
        } else {
            grs.drawLine(d.width / 2, 0, d.width / 2, d.height);
            arrow = new Arrow(1.0, d.width / 2, 0, d.width / 2, d.height);
        }
        arrow.draw(grs);
        return image;
    }

    private Vector<Image> getImage(int ruleIndx, EdRule r) {
        int i;
        if (r == null) {
            return null;
        }
        this.optional = new Vector();
        if (this.gragraOptionalChecks.elementAt(ruleIndx).isSelected()) {
            Vector<JCheckBox> v = this.optionalChecks.elementAt(ruleIndx);
            i = 0;
            while (i < v.size()) {
                Boolean b;
                JCheckBox cb = v.elementAt(i);
                if (cb.isSelected()) {
                    b = new Boolean(true);
                    this.optional.addElement(b);
                } else {
                    b = new Boolean(false);
                    this.optional.addElement(b);
                }
                ++i;
            }
        } else {
            Boolean b = new Boolean(true);
            this.optional.addElement(b);
            b = new Boolean(true);
            this.optional.addElement(b);
            i = 0;
            while (i < r.getNACs().size()) {
                b = new Boolean(true);
                this.optional.addElement(b);
                ++i;
            }
        }
        int w = 0;
        int h = 0;
        Dimension leftDim = r.getLeft().getGraphDimension(this.scale);
        Dimension rightDim = r.getRight().getGraphDimension(this.scale);
        w = leftDim.width > rightDim.width ? leftDim.width : rightDim.width;
        h = leftDim.height > rightDim.height ? leftDim.height : rightDim.height;
        h = 20 + h + 10;
        int lw = 0;
        int lh = 0;
        Image leftImage = null;
        if (this.optional.elementAt(0).booleanValue() && (leftImage = this.getImage(r.getLeft(), new Dimension(w += 10, h))) != null) {
            lw = w;
            lh = h;
        }
        int rw = 0;
        int rh = 0;
        Image rightImage = null;
        if (this.optional.elementAt(1).booleanValue() && (rightImage = this.getImage(r.getRight(), new Dimension(w, h))) != null) {
            rw = w;
            rh = h;
        }
        Image ruleArrow = null;
        boolean horizontal = true;
        Dimension arrowDim = new Dimension(0, 0);
        if (leftImage != null && rightImage != null) {
            if (lw + 30 >= this.W || lw + 30 + rw >= this.W) {
                arrowDim = new Dimension(lw, 30);
                horizontal = false;
                ruleArrow = this.getRuleArrow(arrowDim, horizontal);
            } else {
                arrowDim = new Dimension(30, h + 20);
                horizontal = true;
                ruleArrow = this.getRuleArrow(arrowDim, horizontal);
            }
        }
        int ruleW = 0;
        int ruleH = 0;
        Image ruleImage = null;
        Graphics2D grs = null;
        int x = 0;
        int y = 0;
        if (leftImage != null && rightImage != null && horizontal) {
            ruleW = lw + arrowDim.width + rw;
            ruleH = lh;
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(leftImage, x, y, null);
            grs.drawImage(ruleArrow, x += lw, y, null);
            if (ruleArrow != null) {
                x += ruleArrow.getWidth(null);
            }
            grs.drawImage(rightImage, x, y, null);
        } else if (leftImage != null && rightImage != null && !horizontal) {
            ruleW = lw;
            if (ruleArrow != null) {
                ruleH = lh + ruleArrow.getHeight(null) + lh;
            }
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(leftImage, x, y, null);
            grs.drawImage(ruleArrow, x, y += lh, null);
            if (ruleArrow != null) {
                y += ruleArrow.getHeight(null);
            }
            grs.drawImage(rightImage, x, y, null);
        } else if (leftImage != null) {
            ruleW = lw;
            ruleH = lh;
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(leftImage, x, y, null);
        } else if (rightImage != null) {
            ruleW = rw;
            ruleH = rh;
            ruleImage = this.createImage(ruleW, ruleH);
            grs = (Graphics2D)ruleImage.getGraphics();
            grs.setColor(Color.white);
            grs.fillRect(0, 0, ruleW, ruleH);
            grs.drawImage(rightImage, x, y, null);
        }
        Vector<Image> images = new Vector<Image>();
        int bigImageW = 0;
        int bigImageH = 0;
        if (ruleImage != null) {
            bigImageW = ruleW;
            bigImageH = ruleH;
        }
        Image bigImage = null;
        Image nacImage = null;
        Vector<EdNAC> nacs = r.getNACs();
        nacImage = this.getImage(nacs);
        if (nacImage != null) {
            if (ruleImage != null) {
                if (ruleH + nacImage.getHeight(null) > this.H) {
                    bigImageW = this.W;
                    bigImageH = this.H;
                    bigImage = this.createImage(bigImageW, bigImageH);
                    grs = (Graphics2D)bigImage.getGraphics();
                    grs.setPaint(Color.white);
                    grs.fillRect(0, 0, bigImageW, bigImageH);
                    grs.setColor(Color.black);
                    grs.drawString("Rule: " + r.getBasisRule().getName(), 10, 15);
                    x = 5;
                    y = 20;
                    grs.drawImage(ruleImage, x, y, null);
                    grs.drawRect(1, 20, ruleW + 10 - 2, ruleH + 5);
                    images.addElement(bigImage);
                } else {
                    bigImageH += nacImage.getHeight(null);
                }
            } else {
                bigImageH = nacImage.getHeight(null);
            }
            bigImageW = nacImage.getWidth(null) > bigImageW ? nacImage.getWidth(null) : ruleW;
        }
        if (images.isEmpty()) {
            bigImageH = 20 + bigImageH + 5;
            bigImage = this.createImage(bigImageW += 10, bigImageH);
            grs = (Graphics2D)bigImage.getGraphics();
            grs.setPaint(Color.white);
            grs.fillRect(0, 0, bigImageW, bigImageH);
            grs.setColor(Color.black);
            grs.drawString("Rule: " + r.getBasisRule().getName(), 10, 15);
            x = 5;
            y = 20;
            grs.drawImage(ruleImage, x, y, null);
            if (nacImage != null) {
                if (ruleImage != null) {
                    y += ruleImage.getHeight(null);
                }
                grs.drawImage(nacImage, x, y, null);
            }
            grs.drawRect(1, 20, bigImageW - 2, bigImageH - 20 - 1);
            images.addElement(bigImage);
        } else if (nacImage != null) {
            bigImageW = this.W;
            bigImageH = this.H;
            bigImage = this.createImage(bigImageW, bigImageH);
            grs = (Graphics2D)bigImage.getGraphics();
            grs.setPaint(Color.white);
            grs.fillRect(0, 0, bigImageW, bigImageH);
            grs.setColor(Color.black);
            grs.drawString("NAC(s) of Rule: " + r.getBasisRule().getName(), 10, 15);
            x = 5;
            y = 20;
            grs.drawImage(nacImage, x, y, null);
            grs.drawRect(1, 20, nacImage.getWidth(null) + 10 - 2, nacImage.getHeight(null) - 1);
            images.addElement(bigImage);
        }
        return images;
    }

    class PaintContent
    implements Printable {
        private Vector<Image> myPageImages;

        PaintContent() {
        }

        @Override
        public int print(Graphics grs, PageFormat pf, int pageIndex) throws PrinterException {
            if (this.myPageImages != null) {
                Graphics2D g2D = (Graphics2D)grs;
                g2D.setFont(GraGraPrint.this.font);
                int x = (int)pf.getImageableX();
                int y = (int)pf.getImageableY();
                int i = 0;
                while (i < this.myPageImages.size()) {
                    Image image = this.myPageImages.elementAt(i);
                    g2D.drawImage(image, x, y, null);
                    y += image.getHeight(null);
                    ++i;
                }
                return 0;
            }
            return 1;
        }

        public void setPageImages(Vector<Image> imgs) {
            this.myPageImages = imgs;
        }
    }

    class PaintCover
    implements Printable {
        PaintCover() {
        }

        @Override
        public int print(Graphics grs, PageFormat pf, int pageIndex) throws PrinterException {
            grs.setFont(GraGraPrint.this.font);
            grs.setColor(Color.black);
            grs.drawString("Graph Grammar", 100, 200);
            return 0;
        }
    }
}

